/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client;

public class RouteDescription {
    private final String cidrBlock;
    private final String gatewayId;
    private final String instanceId;
    private final String networkInterfaceId;
    private final String state;

    public RouteDescription(String cidrBlock, String gatewayId, String instanceId, String networkInterfaceId, String state) {
        this.cidrBlock = cidrBlock;
        this.gatewayId = gatewayId;
        this.instanceId = instanceId;
        this.networkInterfaceId = networkInterfaceId;
        this.state = state;
    }

    public static RouteDescription createGatewayRoute(String cidrBlock, String gatewayId, String state) {
        return new RouteDescription(cidrBlock, gatewayId, null, null, state);
    }

    public static RouteDescription createInstanceRoute(String cidrBlock, String instanceId, String state) {
        return new RouteDescription(cidrBlock, null, instanceId, null, state);
    }

    public static RouteDescription createNetworkInterfaceRoute(String cidrBlock, String networkInterfaceId, String state) {
        return new RouteDescription(cidrBlock, null, null, networkInterfaceId, state);
    }

    public String getCidrBlock() {
        return this.cidrBlock;
    }

    public String getGatewayId() {
        return this.gatewayId;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public String getNetworkInterfaceId() {
        return this.networkInterfaceId;
    }

    public String getState() {
        return this.state;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.cidrBlock == null ? 0 : this.cidrBlock.hashCode());
        result = 31 * result + (this.gatewayId == null ? 0 : this.gatewayId.hashCode());
        result = 31 * result + (this.instanceId == null ? 0 : this.instanceId.hashCode());
        result = 31 * result + (this.networkInterfaceId == null ? 0 : this.networkInterfaceId.hashCode());
        result = 31 * result + (this.state == null ? 0 : this.state.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RouteDescription other = (RouteDescription)obj;
        if (this.cidrBlock == null ? other.cidrBlock != null : !this.cidrBlock.equals(other.cidrBlock)) {
            return false;
        }
        if (this.gatewayId == null ? other.gatewayId != null : !this.gatewayId.equals(other.gatewayId)) {
            return false;
        }
        if (this.instanceId == null ? other.instanceId != null : !this.instanceId.equals(other.instanceId)) {
            return false;
        }
        if (this.networkInterfaceId == null ? other.networkInterfaceId != null : !this.networkInterfaceId.equals(other.networkInterfaceId)) {
            return false;
        }
        return !(this.state == null ? other.state != null : !this.state.equals(other.state));
    }
}

