/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.RequestResult;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.Outputter;
import com.amazon.aes.webservices.client.instanceStatus.InstanceStatusContainer;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;

public class DescribeInstanceStatus
extends BaseCmd {
    private static final String HIDE_HEALTHY = "HIDE-HEALTHY";
    private static final String HIDE_HEALTHY_SHORTOPT = "I";
    private static final String HIDE_HEALTHY_LONGOPT = "hide-healthy";
    private static final String HIDE_HEALTHY_DESCRIPTION = "Hide instances where all status checks pass.";
    private static final String INCLUDE_ALL_INSTANCES = "INCLUDE-ALL-INSTANCES";
    private static final String INCLUDE_ALL_INSTANCES_SHORTOPT = "A";
    private static final String INCLUDE_ALL_INSTANCES_LONGOPT = "include-all-instances";
    private static final String INCLUDE_ALL_INSTANCES_DESCRIPTION = "List all instances, not just those that are running.";

    public DescribeInstanceStatus(String[] args) {
        super("ec2dins", "ec2-describe-instance-status");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    private Options getOptions() {
        Options o = new Options();
        OptionBuilder.withLongOpt((String)"filter");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"FILTER");
        OptionBuilder.withDescription((String)"Add a filter criterion for the result-set.");
        o.addOption(OptionBuilder.create((String)"F"));
        OptionBuilder.withLongOpt((String)HIDE_HEALTHY_LONGOPT);
        OptionBuilder.withArgName((String)HIDE_HEALTHY);
        OptionBuilder.withDescription((String)HIDE_HEALTHY_DESCRIPTION);
        OptionBuilder.isRequired((boolean)false);
        o.addOption(OptionBuilder.create((String)HIDE_HEALTHY_SHORTOPT));
        OptionBuilder.withLongOpt((String)INCLUDE_ALL_INSTANCES_LONGOPT);
        OptionBuilder.withArgName((String)INCLUDE_ALL_INSTANCES);
        OptionBuilder.withDescription((String)INCLUDE_ALL_INSTANCES_DESCRIPTION);
        OptionBuilder.isRequired((boolean)false);
        o.addOption(OptionBuilder.create((String)INCLUDE_ALL_INSTANCES_SHORTOPT));
        return o;
    }

    @Override
    public String getOptionString() {
        return "[-h] [INSTANCE [INSTANCE [...]]]";
    }

    @Override
    public void printDescription() {
        super.printDescription();
        System.out.println("     Describe the status for one or more instances.");
        System.out.println("     Checks are performed on your instances to determine if they are ");
        System.out.println("     in running order or not. Use this command to see the result of these ");
        System.out.println("     instance checks so that you can take remedial action if possible.");
        System.out.println("");
        System.out.println("     There are two types of checks performed: INSTANCE and SYSTEM.");
        System.out.println("     INSTANCE checks examine the health and reachability of the");
        System.out.println("     application environment. SYSTEM checks examine the health of ");
        System.out.println("     the infrastructure surrounding your instance.");
        System.out.println("");
        System.out.println("     How Retirement Works:");
        System.out.println("     ---------------------");
        System.out.println("     It may happen the instance host becomes unhealthy, requiring all ");
        System.out.println("     instances on that host to be evicted at a future point in time.");
        System.out.println("     Your instance(s) will be marked as RETIRING, with the date of when ");
        System.out.println("     they will be forcefully evicted from the host.");
        System.out.println("");
        System.out.println("     Your instance will not be restarted if it is forcefully evicted from ");
        System.out.println("     a retiring host. Avoid eviction by manually restarting your instance ");
        System.out.println("     when it shows as RETIRING. This ensures your instance is started on ");
        System.out.println("     a healthy host.");
        System.out.println("");
        System.out.println("     How Events Work:");
        System.out.println("     ----------------");
        System.out.println("     An event is a reminder of an operation that will affect this instance.");
        System.out.println("     The fields NotBefore and NotAfter indicate the scheduled date that the");
        System.out.println("     event comes into effect:");
        System.out.println("       * NotBefore: the event will not occur before this time");
        System.out.println("       * NotAfter: the event will not occur after this time");
    }

    @Override
    public void printOptions() {
        super.printOptions(true);
        this.printOption(HIDE_HEALTHY_LONGOPT);
        this.printOption(INCLUDE_ALL_INSTANCES_LONGOPT);
        this.printOption("filter");
    }

    @Override
    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        String[] instanceIds = this.getNonOptions();
        Integer maxResults = instanceIds != null && instanceIds.length > 0 ? null : Integer.valueOf(1000);
        String nextToken = null;
        do {
            RequestResultPair rsp = maxResults != null ? jec2.describeInstanceStatus(maxResults, this.getFilters(true), Boolean.valueOf(this.isOptionSet(INCLUDE_ALL_INSTANCES)), nextToken) : jec2.describeInstanceStatus(instanceIds, this.getFilters(true), Boolean.valueOf(this.isOptionSet(INCLUDE_ALL_INSTANCES)), nextToken);
            InstanceStatusContainer instanceStatusContainer = (InstanceStatusContainer)rsp.getResponse();
            out.outputInstanceStatusDescriptions(System.out, instanceStatusContainer.getInstanceStatusDescriptions(), this.isOptionSet(HIDE_HEALTHY_SHORTOPT));
            out.printRequestId(System.out, (RequestResult)rsp);
            nextToken = instanceStatusContainer.getNextToken();
            if (nextToken != "") continue;
            nextToken = null;
        } while (nextToken != null);
        return true;
    }

    public static void main(String[] args) {
        new DescribeInstanceStatus(args).invoke();
    }
}

