/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.ec2.model.CreateNetworkInterfaceRequest;
import com.amazonaws.services.ec2.model.NetworkInterfaceAssociation;
import com.amazonaws.services.ec2.model.PrivateIpAddress;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class CreateNetworkInterfaceRequestMarshaller
implements Marshaller<Request<CreateNetworkInterfaceRequest>, CreateNetworkInterfaceRequest> {
    public Request<CreateNetworkInterfaceRequest> marshall(CreateNetworkInterfaceRequest createNetworkInterfaceRequest) {
        if (createNetworkInterfaceRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createNetworkInterfaceRequest, "AmazonEC2");
        request.addParameter("Action", "CreateNetworkInterface");
        request.addParameter("Version", "2012-07-20");
        if (createNetworkInterfaceRequest.getSubnetId() != null) {
            request.addParameter("SubnetId", StringUtils.fromString((String)createNetworkInterfaceRequest.getSubnetId()));
        }
        if (createNetworkInterfaceRequest.getDescription() != null) {
            request.addParameter("Description", StringUtils.fromString((String)createNetworkInterfaceRequest.getDescription()));
        }
        if (createNetworkInterfaceRequest.getPrivateIpAddress() != null) {
            request.addParameter("PrivateIpAddress", StringUtils.fromString((String)createNetworkInterfaceRequest.getPrivateIpAddress()));
        }
        List<String> groupsList = createNetworkInterfaceRequest.getGroups();
        int groupsListIndex = 1;
        for (String groupsListValue : groupsList) {
            if (groupsListValue != null) {
                request.addParameter("SecurityGroupId." + groupsListIndex, StringUtils.fromString((String)groupsListValue));
            }
            ++groupsListIndex;
        }
        List<PrivateIpAddress> privateIpAddressesList = createNetworkInterfaceRequest.getPrivateIpAddresses();
        int privateIpAddressesListIndex = 1;
        for (PrivateIpAddress privateIpAddressesListValue : privateIpAddressesList) {
            PrivateIpAddress privateIpAddressMember = privateIpAddressesListValue;
            if (privateIpAddressMember != null) {
                NetworkInterfaceAssociation networkInterfaceAssociationAssociation;
                if (privateIpAddressMember.getPrivateIpAddress() != null) {
                    request.addParameter("PrivateIpAddresses." + privateIpAddressesListIndex + ".PrivateIpAddress", StringUtils.fromString((String)privateIpAddressMember.getPrivateIpAddress()));
                }
                if (privateIpAddressMember.isPrimary() != null) {
                    request.addParameter("PrivateIpAddresses." + privateIpAddressesListIndex + ".Primary", StringUtils.fromBoolean((Boolean)privateIpAddressMember.isPrimary()));
                }
                if ((networkInterfaceAssociationAssociation = privateIpAddressMember.getAssociation()) != null) {
                    if (networkInterfaceAssociationAssociation.getPublicIp() != null) {
                        request.addParameter("PrivateIpAddresses." + privateIpAddressesListIndex + ".Association.PublicIp", StringUtils.fromString((String)networkInterfaceAssociationAssociation.getPublicIp()));
                    }
                    if (networkInterfaceAssociationAssociation.getIpOwnerId() != null) {
                        request.addParameter("PrivateIpAddresses." + privateIpAddressesListIndex + ".Association.IpOwnerId", StringUtils.fromString((String)networkInterfaceAssociationAssociation.getIpOwnerId()));
                    }
                    if (networkInterfaceAssociationAssociation.getAllocationId() != null) {
                        request.addParameter("PrivateIpAddresses." + privateIpAddressesListIndex + ".Association.AllocationId", StringUtils.fromString((String)networkInterfaceAssociationAssociation.getAllocationId()));
                    }
                    if (networkInterfaceAssociationAssociation.getAssociationId() != null) {
                        request.addParameter("PrivateIpAddresses." + privateIpAddressesListIndex + ".Association.AssociationId", StringUtils.fromString((String)networkInterfaceAssociationAssociation.getAssociationId()));
                    }
                }
            }
            ++privateIpAddressesListIndex;
        }
        if (createNetworkInterfaceRequest.getSecondaryPrivateIpAddressCount() != null) {
            request.addParameter("SecondaryPrivateIpAddressCount", StringUtils.fromInteger((Integer)createNetworkInterfaceRequest.getSecondaryPrivateIpAddressCount()));
        }
        return request;
    }
}

