/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.RequestResult;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.MissingArgument;
import com.amazon.aes.webservices.client.cmd.MissingNonOption;
import com.amazon.aes.webservices.client.cmd.Outputter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;

public class DeleteNetworkAclEntry
extends BaseCmd {
    private static final String[] RULE_NUMBER_DESC = new String[]{"The rule number to delete."};
    private static final String[] EGRESS_DESC = new String[]{"Specifies that the rule to be deleted is an egress rule.", "The rule is otherwise assumed to be ingress."};

    public DeleteNetworkAclEntry(String[] args) {
        super("ec2delnae", "ec2-delete-network-acl-entry");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    protected Options getOptions() {
        Options options = new Options();
        OptionBuilder.withLongOpt((String)"rule-number");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"RULE_NUMBER");
        OptionBuilder.withDescription((String)DeleteNetworkAclEntry.joinDescription(RULE_NUMBER_DESC));
        options.addOption(OptionBuilder.create((String)"n"));
        options.addOption(new Option(null, "egress", false, DeleteNetworkAclEntry.joinDescription(EGRESS_DESC)));
        return options;
    }

    public String getOptionString() {
        return "NETWORK_ACL -n RULE_NUMBER [-egress]";
    }

    public void printDescription() {
        super.printDescription();
        System.out.println("     Delete a network ACL entry. ");
        System.out.println("     NETWORK_ACL is the ID of the network acl from which to delete the entry.");
    }

    public void printOptions() {
        super.printOptions(true);
        this.printOption("rule-number");
        this.printOption("egress");
    }

    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        this.assertNonOptionSet("NETWORK_ACL");
        this.warnIfTooManyNonOptions();
        String aclId = this.getNonOptions()[0];
        if (aclId == null || "".equals(aclId)) {
            throw new MissingNonOption("network-acl");
        }
        String ruleNumberString = this.getOptionValue("rule-number");
        if (ruleNumberString == null || "".equals(ruleNumberString)) {
            throw new MissingArgument("rule-number");
        }
        int ruleNumber = Integer.parseInt(ruleNumberString);
        boolean egress = this.isOptionSet("egress");
        RequestResultPair result = jec2.deleteNetworkAclEntry(aclId, ruleNumber, egress);
        out.output(System.out, (Boolean)result.getResponse());
        out.printRequestId(System.out, (RequestResult)result);
        return true;
    }

    public static void main(String[] args) {
        new DeleteNetworkAclEntry(args).invoke();
    }
}

