/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.Outputter;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import org.apache.commons.cli.Options;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMReader;
import org.codehaus.xfire.util.Base64;

public class FingerprintKey
extends BaseCmd {
    public FingerprintKey(String[] args) {
        super("ec2fp", "ec2-fingerprint-key");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    private Options getOptions() {
        return new Options();
    }

    protected String getOptionString() {
        return "KEYFILE";
    }

    public void printDescription() {
        super.printDescription();
        System.out.println("     Generate a fingerprint for a private key generated by Amazon EC2.");
        System.out.println("     The KEYFILE parameter is a file containing an unencrypted PEM encoded");
        System.out.println("     PKCS#8 private key (as generated by Amazon EC2).");
    }

    public void printOptions() {
        super.printOptions();
    }

    protected boolean isOnline() {
        return false;
    }

    protected boolean invokeOffline(Outputter out) throws Exception {
        this.assertNonOptionSet("KEYFILE");
        this.warnIfTooManyNonOptions();
        try {
            PrivateKey pk = this.loadPrivateKeyByName(this.getNonOptions()[0]);
            String fp = this.toHexFingerPrint(MessageDigest.getInstance("SHA1").digest(pk.getEncoded()));
            System.out.println(fp);
            return true;
        }
        catch (IOException e) {
            System.err.println("File error: " + e.toString());
        }
        catch (InvalidKeySpecException e) {
            System.err.println("Invalid private key: " + e.toString());
        }
        catch (NoSuchAlgorithmException e) {
            System.err.println("Internal error: " + e.toString());
        }
        return false;
    }

    private PrivateKey loadPrivateKeyByName(String fileName) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException {
        String line;
        BufferedReader br = new BufferedReader(new FileReader(fileName));
        StringBuffer keyBuf = new StringBuffer();
        boolean pkcs8 = false;
        while ((line = br.readLine()) != null) {
            if (line.startsWith("-----BEGIN PRIVATE KEY")) {
                pkcs8 = true;
                continue;
            }
            if (line.startsWith("-----END")) continue;
            keyBuf.append(line);
        }
        br.close();
        if (pkcs8) {
            PKCS8EncodedKeySpec privKeySpec = new PKCS8EncodedKeySpec(Base64.decode((String)keyBuf.toString()));
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PrivateKey privKey = keyFactory.generatePrivate(privKeySpec);
            return privKey;
        }
        PEMReader pemReader = new PEMReader((Reader)new BufferedReader(new FileReader(fileName)));
        return ((KeyPair)pemReader.readObject()).getPrivate();
    }

    private String toHexFingerPrint(byte[] data) {
        StringBuffer sb = new StringBuffer();
        sb.append(this.toString(data[0]));
        for (int i = 1; i < data.length; ++i) {
            sb.append(':');
            sb.append(this.toString(data[i]));
        }
        return sb.toString();
    }

    private String toString(byte b) {
        if (b < 0) {
            return Integer.toHexString(b & 0xFF);
        }
        if (b < 16) {
            return '0' + Integer.toHexString(b);
        }
        return Integer.toHexString(b);
    }

    public static void main(String[] args) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        new FingerprintKey(args).invoke();
    }
}

