/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.RequestResult;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.SpotPriceHistoryDescription;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.Outputter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.TimeZone;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;

public class DescribeSpotPriceHistory
extends BaseCmd {
    private static final String[] INSTANCE_TYPE_DESC = new String[]{"The instance type for which prices should be returned."};
    private static final String INSTANCE_TYPE_ARG = "INSTANCE-TYPE";
    private static final String[] DESCRIPTION = new String[]{"The product description for which prices should be returned."};
    private static final String PRODUCT_DESC_ARG = "PRODUCT-DESCRIPTION";
    private static final String[] START_DESC = new String[]{"The date and time after which the price changes should be returned.", "The time specified must be in the local timezone.", "The format of the date and time must be of the form", "'yyyy-MM-ddTHH:mm:ss'. For instance, 10PM on August 30, 2009 will be", "'2009-08-30T22:00:00'"};
    private static final String START_ARG = "START-TIME";
    private static final String[] END_DESC = new String[]{"Price changes up until this point in time should be returned.", "The time specified must be in the local timezone.", "The format of the date and time must be of the form", "'yyyy-MM-ddTHH:mm:ss'. For instance, 10PM on August 30, 2009 will be", "'2009-08-30T22:00:00'"};
    private static final String END_ARG = "END-TIME";
    private static DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");

    public DescribeSpotPriceHistory(String[] args) {
        super("ec2dsph", "ec2-describe-spot-price-history");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    private Options getOptions() {
        Options result = new Options();
        OptionBuilder.withLongOpt((String)"instance-type");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription((String)DescribeSpotPriceHistory.joinDescription(INSTANCE_TYPE_DESC));
        OptionBuilder.withArgName((String)INSTANCE_TYPE_ARG);
        result.addOption(OptionBuilder.create((String)"t"));
        OptionBuilder.withLongOpt((String)"product-description");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription((String)DescribeSpotPriceHistory.joinDescription(DESCRIPTION));
        OptionBuilder.withArgName((String)PRODUCT_DESC_ARG);
        result.addOption(OptionBuilder.create((String)"d"));
        OptionBuilder.withLongOpt((String)"start-time");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription((String)DescribeSpotPriceHistory.joinDescription(START_DESC));
        OptionBuilder.withArgName((String)START_ARG);
        result.addOption(OptionBuilder.create((String)"s"));
        OptionBuilder.withLongOpt((String)"end-time");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription((String)DescribeSpotPriceHistory.joinDescription(END_DESC));
        OptionBuilder.withArgName((String)END_ARG);
        result.addOption(OptionBuilder.create((String)"e"));
        return result;
    }

    protected String getOptionString() {
        return "[-t INSTANCE-TYPE [...]] [-d PRODUCT-DESCRIPTION [...]] [-s START-TIME] [-e END-TIME]";
    }

    public void printDescription() {
        super.printDescription();
        System.out.println("     List all Spot Instance price changes.");
        System.out.println("     This list can be filtered on various criteria.");
    }

    public void printOptions() {
        super.printOptions(true);
        this.printOption("instance-type");
        this.printOption("product-description");
        this.printOption("start-time");
        this.printOption("end-time");
    }

    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        List<String> instanceTypes = null;
        if (this.isOptionSet("instance-type")) {
            instanceTypes = Arrays.asList(this.getOptionValues("instance-type"));
        }
        List<String> description = null;
        if (this.isOptionSet("product-description")) {
            description = Arrays.asList(this.getOptionValues("product-description"));
        }
        GregorianCalendar start = null;
        String startValue = null;
        if (this.isOptionSet("start-time")) {
            startValue = this.getOptionValue("start-time");
            Date localDate = dateFormat.parse(startValue);
            start = new GregorianCalendar();
            start.setTimeZone(TimeZone.getTimeZone("UTC"));
            start.setTime(localDate);
        }
        GregorianCalendar end = null;
        String endValue = null;
        if (this.isOptionSet("end-time")) {
            endValue = this.getOptionValue("end-time");
            Date localDate = dateFormat.parse(endValue);
            end = new GregorianCalendar();
            end.setTimeZone(TimeZone.getTimeZone("UTC"));
            end.setTime(localDate);
        }
        RequestResultPair rsp = jec2.describeSpotPriceHistory(start, end, instanceTypes, description);
        for (SpotPriceHistoryDescription desc : (List)rsp.getResponse()) {
            out.output(System.out, desc);
        }
        out.printRequestId(System.out, (RequestResult)rsp);
        return true;
    }

    public static void main(String[] args) {
        new DescribeSpotPriceHistory(args).invoke();
    }
}

