/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.RequestResult;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.ReservationDescription;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.Outputter;
import java.util.List;
import org.apache.commons.cli.Options;

public class DescribeInstances
extends BaseCmd {
    public DescribeInstances(String[] args) {
        super("ec2din", "ec2-describe-instances");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    private Options getOptions() {
        return new Options();
    }

    protected String getOptionString() {
        return "[INSTANCE [INSTANCE [...]]]";
    }

    public void printDescription() {
        super.printDescription();
        System.out.println("     List and describe your instances");
        System.out.println("     The INSTANCE parameter is the instance ID(s) to describe.");
        System.out.println("     If unspecified all your instances will be returned.");
    }

    public void printOptions() {
        super.printOptions();
    }

    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        String[] instanceIds = this.getNonOptions();
        RequestResultPair rsp = jec2.describeInstances(instanceIds);
        for (ReservationDescription res : (List)rsp.getResponse()) {
            out.output(System.out, res);
        }
        out.printRequestId(System.out, (RequestResult)rsp);
        return true;
    }

    public static void main(String[] args) {
        new DescribeInstances(args).invoke();
    }
}

