/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.service.CustomerGatewayConfigurationService;
import com.amazon.aes.service.impl.CustomerGatewayConfigurationServiceImpl;
import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.RequestResult;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.VpnConnectionDescription;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.Outputter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;

public class CreateVpnConnection
extends BaseCmd {
    private static final String TYPE_DESC = "The type of VPN connection.";
    private static final String CUSTOMER_GATEWAY_DESC = "The ID of the customer gateway.";
    private static final String VPN_GATEWAY_DESC = "The ID of the VPN connection gateway.";
    private static final String[] OUTPUT_FORMAT_DESC = new String[]{"Causes the response to include customer gateway configuration", "information, in the format specified by this option. The returned", "information can be formatter for various devices, including Cisco", "(cisco-ios-isr), Juniper (juniperjunos-j), human-readable (generic)", "and in the native XML format (xml)."};
    private static final String STYLESHEET_DESC = "A custom stylesheet for the formatting of the configuration.";
    private CustomerGatewayConfigurationService configurationService = new CustomerGatewayConfigurationServiceImpl();
    private String type;
    private String customerGatewayId;
    private String vpnGatewayId;
    private String format;
    private String stylesheet;

    public CreateVpnConnection(String[] args) {
        super("ec2addvpn", "ec2-create-vpn-connection");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    protected String getOptionString() {
        return "[SPECIFIC OPTIONS]";
    }

    private Options getOptions() {
        Options options = new Options();
        OptionBuilder.withLongOpt((String)"type");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"TYPE");
        OptionBuilder.withDescription((String)this.joinDescription(TYPE_DESC));
        options.addOption(OptionBuilder.create((String)"t"));
        OptionBuilder.withLongOpt((String)"customer-gateway");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"CUSTOMER_GATEWAY");
        OptionBuilder.withDescription((String)this.joinDescription(CUSTOMER_GATEWAY_DESC));
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"vpn-gateway");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"VPN_GATEWAY");
        OptionBuilder.withDescription((String)this.joinDescription(VPN_GATEWAY_DESC));
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"format");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"FORMAT");
        OptionBuilder.withDescription((String)CreateVpnConnection.joinDescription(OUTPUT_FORMAT_DESC));
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"stylesheet");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"STYLESHEET");
        OptionBuilder.withDescription((String)this.joinDescription(STYLESHEET_DESC));
        options.addOption(OptionBuilder.create());
        return options;
    }

    public void printDescription() {
        super.printDescription();
        System.out.println("     Creates a VPN connection between an existing VPN gateway and customer");
        System.out.println("     gateway.");
    }

    public void printOptions() {
        super.printOptions(true);
        this.printOption("type");
        this.printOption("customer-gateway");
        this.printOption("vpn-gateway");
        this.printOption("format");
        this.printOption("stylesheet");
    }

    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        this.validateParameters();
        this.type = this.getOptionValue("type");
        this.customerGatewayId = this.getOptionValue("customer-gateway");
        this.vpnGatewayId = this.getOptionValue("vpn-gateway");
        this.format = this.getOptionValue("format");
        this.stylesheet = this.getOptionValue("stylesheet");
        RequestResultPair rsp = jec2.createVpnConnection(this.type, this.customerGatewayId, this.vpnGatewayId);
        out.output(System.out, (VpnConnectionDescription)rsp.getResponse());
        CustomerGatewayConfigurationService.ConfigurationOutputter configurationOutputter = this.stylesheet != null && !"".equals(this.stylesheet) ? this.configurationService.getConfigurationOutputterByLocation(System.out, this.stylesheet) : this.configurationService.getConfigurationOutputterByFormat(System.out, this.format);
        configurationOutputter.output(((VpnConnectionDescription)rsp.getResponse()).getCustomerGatewayConfiguration());
        out.printRequestId(System.out, (RequestResult)rsp);
        return true;
    }

    protected void parseOpts(String[] args) {
        super.parseOpts(args);
    }

    protected void validateParameters() {
        this.assertOptionSet("type");
        this.assertOptionSet("customer-gateway");
        this.assertOptionSet("vpn-gateway");
    }

    public static void main(String[] args) {
        new CreateVpnConnection(args).invoke();
    }
}

