/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client;

import com.amazon.aes.webservices.client.AddressInfo;
import com.amazon.aes.webservices.client.AttachmentDescription;
import com.amazon.aes.webservices.client.AvailabilityZoneDescription;
import com.amazon.aes.webservices.client.BlockDeviceMappingAttribute;
import com.amazon.aes.webservices.client.BundleInstanceTask;
import com.amazon.aes.webservices.client.ConsoleOutput;
import com.amazon.aes.webservices.client.CryptoProxy;
import com.amazon.aes.webservices.client.DescribeImageAttributeResult;
import com.amazon.aes.webservices.client.ImageAttribute;
import com.amazon.aes.webservices.client.ImageDescription;
import com.amazon.aes.webservices.client.ImageListAttribute;
import com.amazon.aes.webservices.client.ImageListAttributeItem;
import com.amazon.aes.webservices.client.ImageMapAttributeItem;
import com.amazon.aes.webservices.client.InstancePlacement;
import com.amazon.aes.webservices.client.Jec2SoapFaultException;
import com.amazon.aes.webservices.client.KernelAttribute;
import com.amazon.aes.webservices.client.KeyPairInfo;
import com.amazon.aes.webservices.client.LaunchPermissionAttribute;
import com.amazon.aes.webservices.client.ProductCodesAttribute;
import com.amazon.aes.webservices.client.RamdiskAttribute;
import com.amazon.aes.webservices.client.RegionDescription;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.ReservationDescription;
import com.amazon.aes.webservices.client.ReservedInstancesDescription;
import com.amazon.aes.webservices.client.ReservedInstancesOfferingDescription;
import com.amazon.aes.webservices.client.SecurityGroupDescription;
import com.amazon.aes.webservices.client.SnapshotDescription;
import com.amazon.aes.webservices.client.TerminatingInstanceDescription;
import com.amazon.aes.webservices.client.VolumeDescription;
import com.amazonaws.ec2.doc._2009_03_01.AllocateAddressResponseType;
import com.amazonaws.ec2.doc._2009_03_01.AllocateAddressType;
import com.amazonaws.ec2.doc._2009_03_01.AmazonEC2Client;
import com.amazonaws.ec2.doc._2009_03_01.AmazonEC2PortType;
import com.amazonaws.ec2.doc._2009_03_01.AssociateAddressResponseType;
import com.amazonaws.ec2.doc._2009_03_01.AssociateAddressType;
import com.amazonaws.ec2.doc._2009_03_01.AttachVolumeResponseType;
import com.amazonaws.ec2.doc._2009_03_01.AttachVolumeType;
import com.amazonaws.ec2.doc._2009_03_01.AttachmentSetItemResponseType;
import com.amazonaws.ec2.doc._2009_03_01.AuthorizeSecurityGroupIngressResponseType;
import com.amazonaws.ec2.doc._2009_03_01.AuthorizeSecurityGroupIngressType;
import com.amazonaws.ec2.doc._2009_03_01.AvailabilityZoneItemType;
import com.amazonaws.ec2.doc._2009_03_01.BlockDeviceMappingItemType;
import com.amazonaws.ec2.doc._2009_03_01.BlockDeviceMappingType;
import com.amazonaws.ec2.doc._2009_03_01.BundleInstanceResponseType;
import com.amazonaws.ec2.doc._2009_03_01.BundleInstanceS3StorageType;
import com.amazonaws.ec2.doc._2009_03_01.BundleInstanceTaskStorageType;
import com.amazonaws.ec2.doc._2009_03_01.BundleInstanceTaskType;
import com.amazonaws.ec2.doc._2009_03_01.BundleInstanceType;
import com.amazonaws.ec2.doc._2009_03_01.CancelBundleTaskResponseType;
import com.amazonaws.ec2.doc._2009_03_01.CancelBundleTaskType;
import com.amazonaws.ec2.doc._2009_03_01.ConfirmProductInstanceResponseType;
import com.amazonaws.ec2.doc._2009_03_01.ConfirmProductInstanceType;
import com.amazonaws.ec2.doc._2009_03_01.CreateKeyPairResponseType;
import com.amazonaws.ec2.doc._2009_03_01.CreateKeyPairType;
import com.amazonaws.ec2.doc._2009_03_01.CreateSecurityGroupResponseType;
import com.amazonaws.ec2.doc._2009_03_01.CreateSecurityGroupType;
import com.amazonaws.ec2.doc._2009_03_01.CreateSnapshotResponseType;
import com.amazonaws.ec2.doc._2009_03_01.CreateSnapshotType;
import com.amazonaws.ec2.doc._2009_03_01.CreateVolumeResponseType;
import com.amazonaws.ec2.doc._2009_03_01.CreateVolumeType;
import com.amazonaws.ec2.doc._2009_03_01.DeleteKeyPairResponseType;
import com.amazonaws.ec2.doc._2009_03_01.DeleteKeyPairType;
import com.amazonaws.ec2.doc._2009_03_01.DeleteSecurityGroupResponseType;
import com.amazonaws.ec2.doc._2009_03_01.DeleteSecurityGroupType;
import com.amazonaws.ec2.doc._2009_03_01.DeleteSnapshotResponseType;
import com.amazonaws.ec2.doc._2009_03_01.DeleteSnapshotType;
import com.amazonaws.ec2.doc._2009_03_01.DeleteVolumeResponseType;
import com.amazonaws.ec2.doc._2009_03_01.DeleteVolumeType;
import com.amazonaws.ec2.doc._2009_03_01.DeregisterImageType;
import com.amazonaws.ec2.doc._2009_03_01.DescribeAddressesInfoType;
import com.amazonaws.ec2.doc._2009_03_01.DescribeAddressesItemType;
import com.amazonaws.ec2.doc._2009_03_01.DescribeAddressesResponseInfoType;
import com.amazonaws.ec2.doc._2009_03_01.DescribeAddressesResponseItemType;
import com.amazonaws.ec2.doc._2009_03_01.DescribeAddressesResponseType;
import com.amazonaws.ec2.doc._2009_03_01.DescribeAddressesType;
import com.amazonaws.ec2.doc._2009_03_01.DescribeAvailabilityZonesResponseType;
import com.amazonaws.ec2.doc._2009_03_01.DescribeAvailabilityZonesSetItemType;
import com.amazonaws.ec2.doc._2009_03_01.DescribeAvailabilityZonesSetType;
import com.amazonaws.ec2.doc._2009_03_01.DescribeAvailabilityZonesType;
import com.amazonaws.ec2.doc._2009_03_01.DescribeBundleTasksInfoType;
import com.amazonaws.ec2.doc._2009_03_01.DescribeBundleTasksItemType;
import com.amazonaws.ec2.doc._2009_03_01.DescribeBundleTasksResponseType;
import com.amazonaws.ec2.doc._2009_03_01.DescribeBundleTasksType;
import com.amazonaws.ec2.doc._2009_03_01.DescribeImageAttributeResponseType;
import com.amazonaws.ec2.doc._2009_03_01.DescribeImageAttributeType;
import com.amazonaws.ec2.doc._2009_03_01.DescribeImagesExecutableBySetType;
import com.amazonaws.ec2.doc._2009_03_01.DescribeImagesExecutableByType;
import com.amazonaws.ec2.doc._2009_03_01.DescribeImagesInfoType;
import com.amazonaws.ec2.doc._2009_03_01.DescribeImagesItemType;
import com.amazonaws.ec2.doc._2009_03_01.DescribeImagesOwnerType;
import com.amazonaws.ec2.doc._2009_03_01.DescribeImagesOwnersType;
import com.amazonaws.ec2.doc._2009_03_01.DescribeImagesResponseInfoType;
import com.amazonaws.ec2.doc._2009_03_01.DescribeImagesResponseItemType;
import com.amazonaws.ec2.doc._2009_03_01.DescribeImagesResponseType;
import com.amazonaws.ec2.doc._2009_03_01.DescribeImagesType;
import com.amazonaws.ec2.doc._2009_03_01.DescribeInstancesInfoType;
import com.amazonaws.ec2.doc._2009_03_01.DescribeInstancesItemType;
import com.amazonaws.ec2.doc._2009_03_01.DescribeInstancesResponseType;
import com.amazonaws.ec2.doc._2009_03_01.DescribeInstancesType;
import com.amazonaws.ec2.doc._2009_03_01.DescribeKeyPairsInfoType;
import com.amazonaws.ec2.doc._2009_03_01.DescribeKeyPairsItemType;
import com.amazonaws.ec2.doc._2009_03_01.DescribeKeyPairsResponseInfoType;
import com.amazonaws.ec2.doc._2009_03_01.DescribeKeyPairsResponseItemType;
import com.amazonaws.ec2.doc._2009_03_01.DescribeKeyPairsResponseType;
import com.amazonaws.ec2.doc._2009_03_01.DescribeKeyPairsType;
import com.amazonaws.ec2.doc._2009_03_01.DescribeRegionsResponseType;
import com.amazonaws.ec2.doc._2009_03_01.DescribeRegionsSetItemType;
import com.amazonaws.ec2.doc._2009_03_01.DescribeRegionsSetType;
import com.amazonaws.ec2.doc._2009_03_01.DescribeRegionsType;
import com.amazonaws.ec2.doc._2009_03_01.DescribeReservedInstancesOfferingsResponseSetItemType;
import com.amazonaws.ec2.doc._2009_03_01.DescribeReservedInstancesOfferingsResponseType;
import com.amazonaws.ec2.doc._2009_03_01.DescribeReservedInstancesOfferingsSetItemType;
import com.amazonaws.ec2.doc._2009_03_01.DescribeReservedInstancesOfferingsSetType;
import com.amazonaws.ec2.doc._2009_03_01.DescribeReservedInstancesOfferingsType;
import com.amazonaws.ec2.doc._2009_03_01.DescribeReservedInstancesResponseSetItemType;
import com.amazonaws.ec2.doc._2009_03_01.DescribeReservedInstancesResponseType;
import com.amazonaws.ec2.doc._2009_03_01.DescribeReservedInstancesSetItemType;
import com.amazonaws.ec2.doc._2009_03_01.DescribeReservedInstancesSetType;
import com.amazonaws.ec2.doc._2009_03_01.DescribeReservedInstancesType;
import com.amazonaws.ec2.doc._2009_03_01.DescribeSecurityGroupsResponseType;
import com.amazonaws.ec2.doc._2009_03_01.DescribeSecurityGroupsSetItemType;
import com.amazonaws.ec2.doc._2009_03_01.DescribeSecurityGroupsSetType;
import com.amazonaws.ec2.doc._2009_03_01.DescribeSecurityGroupsType;
import com.amazonaws.ec2.doc._2009_03_01.DescribeSnapshotsResponseType;
import com.amazonaws.ec2.doc._2009_03_01.DescribeSnapshotsSetItemResponseType;
import com.amazonaws.ec2.doc._2009_03_01.DescribeSnapshotsSetItemType;
import com.amazonaws.ec2.doc._2009_03_01.DescribeSnapshotsSetType;
import com.amazonaws.ec2.doc._2009_03_01.DescribeSnapshotsType;
import com.amazonaws.ec2.doc._2009_03_01.DescribeVolumesResponseType;
import com.amazonaws.ec2.doc._2009_03_01.DescribeVolumesSetItemResponseType;
import com.amazonaws.ec2.doc._2009_03_01.DescribeVolumesSetItemType;
import com.amazonaws.ec2.doc._2009_03_01.DescribeVolumesSetType;
import com.amazonaws.ec2.doc._2009_03_01.DescribeVolumesType;
import com.amazonaws.ec2.doc._2009_03_01.DetachVolumeResponseType;
import com.amazonaws.ec2.doc._2009_03_01.DetachVolumeType;
import com.amazonaws.ec2.doc._2009_03_01.DisassociateAddressResponseType;
import com.amazonaws.ec2.doc._2009_03_01.DisassociateAddressType;
import com.amazonaws.ec2.doc._2009_03_01.EmptyElementType;
import com.amazonaws.ec2.doc._2009_03_01.GetConsoleOutputResponseType;
import com.amazonaws.ec2.doc._2009_03_01.GetConsoleOutputType;
import com.amazonaws.ec2.doc._2009_03_01.GroupItemType;
import com.amazonaws.ec2.doc._2009_03_01.GroupSetType;
import com.amazonaws.ec2.doc._2009_03_01.IpPermissionSetType;
import com.amazonaws.ec2.doc._2009_03_01.IpPermissionType;
import com.amazonaws.ec2.doc._2009_03_01.IpRangeItemType;
import com.amazonaws.ec2.doc._2009_03_01.IpRangeSetType;
import com.amazonaws.ec2.doc._2009_03_01.LaunchPermissionItemType;
import com.amazonaws.ec2.doc._2009_03_01.LaunchPermissionListType;
import com.amazonaws.ec2.doc._2009_03_01.LaunchPermissionOperationType;
import com.amazonaws.ec2.doc._2009_03_01.ModifyImageAttributeResponseType;
import com.amazonaws.ec2.doc._2009_03_01.ModifyImageAttributeType;
import com.amazonaws.ec2.doc._2009_03_01.ObjectFactory;
import com.amazonaws.ec2.doc._2009_03_01.PlacementRequestType;
import com.amazonaws.ec2.doc._2009_03_01.ProductCodeItemType;
import com.amazonaws.ec2.doc._2009_03_01.ProductCodeListType;
import com.amazonaws.ec2.doc._2009_03_01.ProductCodesSetItemType;
import com.amazonaws.ec2.doc._2009_03_01.ProductCodesSetType;
import com.amazonaws.ec2.doc._2009_03_01.PurchaseReservedInstancesOfferingResponseType;
import com.amazonaws.ec2.doc._2009_03_01.PurchaseReservedInstancesOfferingType;
import com.amazonaws.ec2.doc._2009_03_01.RebootInstancesInfoType;
import com.amazonaws.ec2.doc._2009_03_01.RebootInstancesItemType;
import com.amazonaws.ec2.doc._2009_03_01.RebootInstancesResponseType;
import com.amazonaws.ec2.doc._2009_03_01.RebootInstancesType;
import com.amazonaws.ec2.doc._2009_03_01.RegionItemType;
import com.amazonaws.ec2.doc._2009_03_01.RegisterImageResponseType;
import com.amazonaws.ec2.doc._2009_03_01.RegisterImageType;
import com.amazonaws.ec2.doc._2009_03_01.ReleaseAddressResponseType;
import com.amazonaws.ec2.doc._2009_03_01.ReleaseAddressType;
import com.amazonaws.ec2.doc._2009_03_01.ReservationInfoType;
import com.amazonaws.ec2.doc._2009_03_01.ReservationSetType;
import com.amazonaws.ec2.doc._2009_03_01.ResetImageAttributeResponseType;
import com.amazonaws.ec2.doc._2009_03_01.ResetImageAttributeType;
import com.amazonaws.ec2.doc._2009_03_01.RevokeSecurityGroupIngressResponseType;
import com.amazonaws.ec2.doc._2009_03_01.RevokeSecurityGroupIngressType;
import com.amazonaws.ec2.doc._2009_03_01.RunInstancesResponseType;
import com.amazonaws.ec2.doc._2009_03_01.RunInstancesType;
import com.amazonaws.ec2.doc._2009_03_01.RunningInstancesItemType;
import com.amazonaws.ec2.doc._2009_03_01.RunningInstancesSetType;
import com.amazonaws.ec2.doc._2009_03_01.SecurityGroupItemType;
import com.amazonaws.ec2.doc._2009_03_01.SecurityGroupSetType;
import com.amazonaws.ec2.doc._2009_03_01.TerminateInstancesInfoType;
import com.amazonaws.ec2.doc._2009_03_01.TerminateInstancesItemType;
import com.amazonaws.ec2.doc._2009_03_01.TerminateInstancesResponseInfoType;
import com.amazonaws.ec2.doc._2009_03_01.TerminateInstancesResponseItemType;
import com.amazonaws.ec2.doc._2009_03_01.TerminateInstancesResponseType;
import com.amazonaws.ec2.doc._2009_03_01.TerminateInstancesType;
import com.amazonaws.ec2.doc._2009_03_01.UserDataType;
import com.amazonaws.ec2.doc._2009_03_01.UserIdGroupPairSetType;
import com.amazonaws.ec2.doc._2009_03_01.UserIdGroupPairType;
import com.sun.org.apache.xml.internal.serialize.OutputFormat;
import com.sun.org.apache.xml.internal.serialize.XMLSerializer;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.Serializable;
import java.io.StringWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.apache.ws.security.SOAPConstants;
import org.apache.ws.security.WSEncryptionPart;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.message.WSSecHeader;
import org.apache.ws.security.message.WSSecSignature;
import org.apache.ws.security.message.WSSecTimestamp;
import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.XFireException;
import org.codehaus.xfire.XFireRuntimeException;
import org.codehaus.xfire.client.Client;
import org.codehaus.xfire.fault.XFireFault;
import org.codehaus.xfire.handler.AbstractHandler;
import org.codehaus.xfire.handler.Handler;
import org.codehaus.xfire.util.Base64;
import org.codehaus.xfire.util.dom.DOMInHandler;
import org.codehaus.xfire.util.dom.DOMOutHandler;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Jec2 {
    private static final String REQUEST_TIMEOUT = "20000";
    private static final String CONNECTION_TIMEOUT = "20000";
    private static boolean echoReq;
    private static boolean echoRsp;
    private ObjectFactory of;
    private URL url;
    private String key;
    private String cert;
    private CryptoProxy crypto;
    private AmazonEC2PortType ec2client;
    private static final String BODY;
    private static final String ENVELOPE_URI;

    public Jec2(URL url, String key, String cert) throws Exception {
        if (url == null) {
            throw new NullPointerException("url");
        }
        if (key == null || cert == null) {
            throw new NullPointerException("key or cert");
        }
        if (!new File(key).isFile()) {
            throw new FileNotFoundException(key);
        }
        if (!new File(cert).isFile()) {
            throw new FileNotFoundException(cert);
        }
        String echo = System.getProperty("com.amazon.aes.webservices.client.echo", "");
        boolean echoAll = echo.equalsIgnoreCase("both");
        echoReq = echo.equalsIgnoreCase("req") || echoAll;
        echoRsp = echo.equalsIgnoreCase("rsp") || echoAll;
        this.url = url;
        this.key = key;
        this.cert = cert;
        this.crypto = new CryptoProxy(key, cert);
        this.of = new ObjectFactory();
        this.setupClient();
    }

    protected void setupClient() {
        this.ec2client = new AmazonEC2Client().getAmazonEC2Port(this.url.toString());
        Client client = Client.getInstance((Object)this.ec2client);
        this.setupClientParams(client);
        client.addOutHandler((Handler)new DOMOutHandler());
        client.addOutHandler((Handler)new AbstractHandler(){

            public void invoke(MessageContext ctx) throws Exception {
                Document doc = (Document)ctx.getOutMessage().getProperty((Object)"dom.message");
                Jec2.this.signRequest(doc);
                if (echoReq) {
                    System.out.println("------------------------------[ REQUEST ]-------------------------------");
                    System.out.println(Jec2.this.toFormattedXml(doc));
                    System.out.println("------------------------------------------------------------------------");
                }
            }
        });
        if (echoRsp) {
            client.addInHandler((Handler)new DOMInHandler());
            client.addInHandler((Handler)new AbstractHandler(){

                public void invoke(MessageContext ctx) throws Exception {
                    Document doc = (Document)ctx.getInMessage().getProperty((Object)"dom.message");
                    System.out.println("------------------------------[ RESPONSE ]------------------------------");
                    System.out.println(Jec2.this.toFormattedXml(doc));
                    System.out.println("------------------------------------------------------------------------");
                }
            });
        }
    }

    protected void setupClientParams(Client client) {
        HttpClientParams params = new HttpClientParams();
        params.setParameter("http.socket.timeout", (Object)Integer.parseInt(System.getProperty("com.amazon.aes.webservices.client.requestTimeout", "20000")));
        params.setParameter("http.connection.timeout", (Object)Integer.parseInt(System.getProperty("com.amazon.aes.webservices.client.connectionTimeout", "20000")));
        client.setProperty("httpClient.params", (Object)params);
        String proxyHost = null;
        String proxyPort = "8080";
        if (this.url.getProtocol().equalsIgnoreCase("https")) {
            proxyHost = System.getProperty("https.proxyHost", proxyHost);
            proxyPort = System.getProperty("https.proxyPort", proxyPort);
        } else {
            proxyHost = System.getProperty("http.proxyHost", proxyHost);
            proxyPort = System.getProperty("http.proxyPort", proxyPort);
        }
        if (proxyHost != null) {
            if (echoReq) {
                System.out.println("Using proxy [" + proxyHost + ":" + proxyPort + "]");
            }
            client.setProperty("http.proxyHost", (Object)proxyHost);
            client.setProperty("http.proxyPort", (Object)proxyPort);
            String proxyUser = System.getProperty("http.proxyUser", null);
            String proxyPass = System.getProperty("http.proxyPass", null);
            if (proxyUser != null) {
                if (echoReq) {
                    System.out.println("Using proxy credentials [" + proxyUser + "@" + proxyPass + "] for all realms");
                }
                client.setProperty("http.proxy.user", (Object)proxyUser);
                client.setProperty("http.proxy.password", (Object)proxyPass);
            }
        }
    }

    private String toFormattedXml(Document doc) throws Exception {
        StringWriter sw = new StringWriter();
        OutputFormat format = new OutputFormat(doc);
        format.setLineWidth(65);
        format.setIndenting(true);
        format.setIndent(2);
        XMLSerializer serializer = new XMLSerializer(sw, format);
        serializer.serialize(doc);
        return sw.toString();
    }

    private void signRequest(Document doc) throws Exception {
        WSSecHeader header = new WSSecHeader("", false);
        WSSecSignature signer = new WSSecSignature();
        header.insertSecurityHeader(doc);
        signer.setKeyIdentifierType(1);
        signer.setSigCanonicalization("http://www.w3.org/2001/10/xml-exc-c14n#");
        signer.prepare(doc, (Crypto)this.crypto, header);
        WSSecTimestamp ts = new WSSecTimestamp();
        ts.setTimeToLive(300);
        ts.prepare(doc);
        ts.prependToHeader(header);
        signer.appendBSTElementToHeader(header);
        signer.appendToHeader(header);
        Vector<WSEncryptionPart> v = new Vector<WSEncryptionPart>();
        v.add(new WSEncryptionPart("Timestamp", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Content"));
        v.add(new WSEncryptionPart(BODY, ENVELOPE_URI, "Content"));
        signer.addReferencesToSign(v, header);
        signer.computeSignature();
    }

    protected Exception UnwrapException(Exception e) {
        if (e instanceof XFireRuntimeException && e.getCause() != null && e.getCause() instanceof XFireFault) {
            XFireFault fault = (XFireFault)e.getCause();
            if (fault.getCause() == null) {
                return new Jec2SoapFaultException(fault);
            }
            if (fault.getCause() instanceof XFireException && fault.getCause().getCause() != null) {
                return (Exception)fault.getCause().getCause();
            }
            return fault;
        }
        return e;
    }

    public RequestResultPair<String> registerImage(String imageLocation) throws Exception {
        RegisterImageType req = this.of.createRegisterImageType();
        req.setImageLocation(imageLocation);
        try {
            RegisterImageResponseType rsp = this.ec2client.registerImage(req);
            return new RequestResultPair<String>(rsp.getImageId(), rsp.getRequestId());
        }
        catch (Exception e) {
            throw this.UnwrapException(e);
        }
    }

    public String deregisterImage(String imageId) throws Exception {
        DeregisterImageType req = this.of.createDeregisterImageType();
        req.setImageId(imageId);
        try {
            return this.ec2client.deregisterImage(req).getRequestId();
        }
        catch (Exception e) {
            throw this.UnwrapException(e);
        }
    }

    public RequestResultPair<List<ImageDescription>> describeImages(String[] imageIds) throws Exception {
        return this.describeImages(Arrays.asList(imageIds), new ArrayList<String>(), new ArrayList<String>());
    }

    public RequestResultPair<List<ImageDescription>> describeImages(String[] imageIds, String[] owners, String[] executableBy) throws Exception {
        return this.describeImages(Arrays.asList(imageIds), Arrays.asList(owners), Arrays.asList(executableBy));
    }

    @Deprecated
    public RequestResultPair<List<ImageDescription>> describeImages(List<String> imageIds) throws Exception {
        return this.describeImages(imageIds, new ArrayList<String>(), new ArrayList<String>());
    }

    public RequestResultPair<List<ImageDescription>> describeImages(List<String> imageIds, List<String> ownerList, List<String> executableByList) throws Exception {
        DescribeImagesResponseType rsp;
        DescribeImagesType req = this.of.createDescribeImagesType();
        DescribeImagesInfoType info = this.of.createDescribeImagesInfoType();
        for (String imageId : imageIds) {
            DescribeImagesItemType item = this.of.createDescribeImagesItemType();
            item.setImageId(imageId);
            info.getItem().add(item);
        }
        DescribeImagesOwnersType owners = this.of.createDescribeImagesOwnersType();
        for (String ownerName : ownerList) {
            DescribeImagesOwnerType owner = this.of.createDescribeImagesOwnerType();
            owner.setOwner(ownerName);
            owners.getItem().add(owner);
        }
        DescribeImagesExecutableBySetType executableBy = this.of.createDescribeImagesExecutableBySetType();
        for (String user : executableByList) {
            DescribeImagesExecutableByType executer = this.of.createDescribeImagesExecutableByType();
            executer.setUser(user);
            executableBy.getItem().add(executer);
        }
        req.setImagesSet(info);
        req.setOwnersSet(owners);
        req.setExecutableBySet(executableBy);
        try {
            rsp = this.ec2client.describeImages(req);
        }
        catch (Exception e) {
            throw this.UnwrapException(e);
        }
        ArrayList<ImageDescription> result = new ArrayList<ImageDescription>();
        DescribeImagesResponseInfoType set = rsp.getImagesSet();
        for (DescribeImagesResponseItemType item : set.getItem()) {
            ArrayList<String> productCodes = new ArrayList<String>();
            if (item.getProductCodes() != null) {
                Iterator<ProductCodesSetItemType> i$ = item.getProductCodes().getItem().iterator();
                while (i$.hasNext()) {
                    ProductCodesSetItemType obj;
                    ProductCodesSetItemType productCode = obj = i$.next();
                    productCodes.add(productCode.getProductCode());
                }
            }
            result.add(new ImageDescription(item.getImageId(), item.getImageLocation(), item.getImageOwnerId(), item.getImageState(), item.isIsPublic(), item.getArchitecture(), productCodes, item.getImageType(), item.getKernelId(), item.getRamdiskId(), item.getPlatform()));
        }
        return new RequestResultPair<List<ImageDescription>>(result, rsp.getRequestId());
    }

    public RequestResultPair<Boolean> modifyImageAttribute(String imageId, ImageAttribute attribute, ImageListAttribute.ImageListAttributeOperationType operationType) throws Exception {
        ModifyImageAttributeType req = this.of.createModifyImageAttributeType();
        req.setImageId(imageId);
        switch (attribute.type) {
            case launchPermission: {
                if (operationType == null) {
                    throw new Exception("Invalid operation type");
                }
                this.marshallLaunchPermission((ImageListAttribute)attribute, operationType, req);
                break;
            }
            case productCodes: {
                this.marshallProductCode((ImageListAttribute)attribute, req);
                break;
            }
            default: {
                throw new Exception("Unknown image attribute.");
            }
        }
        try {
            ModifyImageAttributeResponseType rsp = this.ec2client.modifyImageAttribute(req);
            return new RequestResultPair<Boolean>(rsp.isReturn(), rsp.getRequestId());
        }
        catch (Exception e) {
            throw this.UnwrapException(e);
        }
    }

    private void marshallLaunchPermission(ImageListAttribute attribute, ImageListAttribute.ImageListAttributeOperationType operationType, ModifyImageAttributeType req) throws Exception {
        LaunchPermissionOperationType launchPermissionOperation = this.of.createLaunchPermissionOperationType();
        LaunchPermissionListType launchPermissionList = this.of.createLaunchPermissionListType();
        for (ImageListAttributeItem item : attribute.items) {
            LaunchPermissionItemType launchPermissionItem = this.of.createLaunchPermissionItemType();
            switch (item.type) {
                case group: {
                    launchPermissionItem.setGroup(item.value);
                    break;
                }
                case userId: {
                    launchPermissionItem.setUserId(item.value);
                    break;
                }
                default: {
                    throw new Exception("Unknown item type.");
                }
            }
            launchPermissionList.getItem().add(launchPermissionItem);
        }
        switch (operationType) {
            case add: {
                launchPermissionOperation.setAdd(launchPermissionList);
                break;
            }
            case remove: {
                launchPermissionOperation.setRemove(launchPermissionList);
                break;
            }
            default: {
                throw new Exception("Unknown attribute operation.");
            }
        }
        req.setLaunchPermission(launchPermissionOperation);
    }

    private void marshallProductCode(ImageListAttribute attribute, ModifyImageAttributeType req) throws Exception {
        ProductCodeListType productCodes = this.of.createProductCodeListType();
        for (ImageListAttributeItem productCode : attribute.items) {
            ProductCodeItemType item = this.of.createProductCodeItemType();
            item.setProductCode(productCode.value);
            productCodes.getItem().add(item);
        }
        req.setProductCodes(productCodes);
    }

    public RequestResultPair<Boolean> resetImageAttribute(String imageId, ImageAttribute.ImageAttributeType imageAttribute) throws Exception {
        ResetImageAttributeType req = this.of.createResetImageAttributeType();
        req.setImageId(imageId);
        EmptyElementType empty = this.of.createEmptyElementType();
        switch (imageAttribute) {
            case launchPermission: {
                req.setLaunchPermission(empty);
                break;
            }
            default: {
                throw new Exception("Unknown image attribute.");
            }
        }
        try {
            ResetImageAttributeResponseType rsp = this.ec2client.resetImageAttribute(req);
            return new RequestResultPair<Boolean>(rsp.isReturn(), rsp.getRequestId());
        }
        catch (Exception e) {
            throw this.UnwrapException(e);
        }
    }

    public RequestResultPair<DescribeImageAttributeResult> describeImageAttribute(String imageId, ImageAttribute.ImageAttributeType imageAttribute) throws Exception {
        DescribeImageAttributeResponseType rsp;
        DescribeImageAttributeType req = this.of.createDescribeImageAttributeType();
        req.setImageId(imageId);
        EmptyElementType empty = this.of.createEmptyElementType();
        switch (imageAttribute) {
            case launchPermission: {
                req.setLaunchPermission(empty);
                break;
            }
            case productCodes: {
                req.setProductCodes(empty);
                break;
            }
            case kernel: {
                req.setKernel(empty);
                break;
            }
            case ramdisk: {
                req.setRamdisk(empty);
                break;
            }
            case blockDeviceMapping: {
                req.setBlockDeviceMapping(empty);
                break;
            }
            default: {
                throw new Exception("Unknown image attribute.");
            }
        }
        try {
            rsp = this.ec2client.describeImageAttribute(req);
        }
        catch (Exception e) {
            throw this.UnwrapException(e);
        }
        ImageAttribute attribute = this.umarshallImageAttribute(rsp);
        DescribeImageAttributeResult imgAttr = new DescribeImageAttributeResult(rsp.getImageId(), attribute);
        return new RequestResultPair<DescribeImageAttributeResult>(imgAttr, rsp.getRequestId());
    }

    private ImageAttribute umarshallImageAttribute(DescribeImageAttributeResponseType rsp) throws Exception {
        if (rsp.getLaunchPermission() != null) {
            return this.unmarshallLaunchPermission(rsp);
        }
        if (rsp.getProductCodes() != null) {
            return this.unmarshallProductCode(rsp);
        }
        if (rsp.getKernel() != null) {
            return new KernelAttribute(rsp.getKernel().getValue());
        }
        if (rsp.getRamdisk() != null) {
            return new RamdiskAttribute(rsp.getRamdisk().getValue());
        }
        if (rsp.getBlockDeviceMapping() != null) {
            BlockDeviceMappingAttribute mappings = new BlockDeviceMappingAttribute();
            for (BlockDeviceMappingItemType item : rsp.getBlockDeviceMapping().getItem()) {
                if (item == null) continue;
                ImageMapAttributeItem mapping = new ImageMapAttributeItem(ImageMapAttributeItem.ImageMapAttributeItemType.blockDeviceMap, item.getVirtualName(), item.getDeviceName());
                mappings.items.add(mapping);
            }
            return mappings;
        }
        throw new Exception("Invalid server response");
    }

    private ImageAttribute unmarshallProductCode(DescribeImageAttributeResponseType rsp) {
        ProductCodesAttribute productCodes = new ProductCodesAttribute();
        Iterator<ProductCodeItemType> i$ = rsp.getProductCodes().getItem().iterator();
        while (i$.hasNext()) {
            ProductCodeItemType o;
            ProductCodeItemType item = o = i$.next();
            productCodes.addImageListAttributeItem(ImageListAttributeItem.ImageListAttributeItemType.productCode, item.getProductCode());
        }
        return productCodes;
    }

    private ImageAttribute unmarshallLaunchPermission(DescribeImageAttributeResponseType rsp) {
        LaunchPermissionAttribute launchPermission = new LaunchPermissionAttribute();
        LaunchPermissionListType list = rsp.getLaunchPermission();
        for (LaunchPermissionItemType o : list.getItem()) {
            LaunchPermissionItemType item = o;
            if (item.getGroup() != null) {
                launchPermission.addImageListAttributeItem(ImageListAttributeItem.ImageListAttributeItemType.group, item.getGroup());
                continue;
            }
            if (item.getUserId() == null) continue;
            launchPermission.addImageListAttributeItem(ImageListAttributeItem.ImageListAttributeItemType.userId, item.getUserId());
        }
        return launchPermission;
    }

    public RequestResultPair<ReservationDescription> runInstances(String imageId, int minCount, int maxCount, List<String> groupSet, String additionalInfo, String keyName, String b64UserData, String addressingType, String instanceType, PlacementRequestType placement, String kernelId, String ramdiskId, BlockDeviceMappingAttribute blockDeviceMapping) throws Exception {
        RunInstancesResponseType rsp;
        RunInstancesType req = this.of.createRunInstancesType();
        if (additionalInfo != null) {
            req.setAdditionalInfo(additionalInfo);
        }
        if (b64UserData != null) {
            UserDataType ud = this.of.createUserDataType();
            ud.getContent().add((Serializable)this.of.createUserDataTypeData(b64UserData));
            ud.setEncoding("base64");
            ud.setVersion("1.0");
            req.setUserData(ud);
        }
        if (addressingType != null) {
            req.setAddressingType(addressingType);
        }
        if (placement != null) {
            req.setPlacement(placement);
        }
        req.setImageId(imageId);
        req.setMinCount(minCount);
        req.setMaxCount(maxCount);
        req.setKeyName(keyName);
        req.setInstanceType(instanceType);
        if (kernelId != null) {
            req.setKernelId(kernelId);
        }
        if (ramdiskId != null) {
            req.setRamdiskId(ramdiskId);
        }
        if (blockDeviceMapping != null && !blockDeviceMapping.items.isEmpty()) {
            BlockDeviceMappingType mappings = this.of.createBlockDeviceMappingType();
            for (ImageMapAttributeItem item : blockDeviceMapping.items) {
                BlockDeviceMappingItemType mapping = this.of.createBlockDeviceMappingItemType();
                mapping.setVirtualName(item.key);
                mapping.setDeviceName(item.value);
                mappings.getItem().add(mapping);
            }
            req.setBlockDeviceMapping(mappings);
        }
        GroupSetType req_groupset = this.of.createGroupSetType();
        if (groupSet != null) {
            for (String groupName : groupSet) {
                GroupItemType groupItem = this.of.createGroupItemType();
                groupItem.setGroupId(groupName);
                req_groupset.getItem().add(groupItem);
            }
        }
        req.setGroupSet(req_groupset);
        try {
            rsp = this.ec2client.runInstances(req);
        }
        catch (Exception e) {
            throw this.UnwrapException(e);
        }
        ReservationDescription res = new ReservationDescription(rsp.getOwnerId(), rsp.getReservationId(), rsp.getRequesterId());
        GroupSetType grp_set = rsp.getGroupSet();
        for (GroupItemType rsp_item : grp_set.getItem()) {
            res.addGroup(rsp_item.getGroupId());
        }
        RunningInstancesSetType set = rsp.getInstancesSet();
        for (RunningInstancesItemType rsp_item : set.getItem()) {
            res.addInstance(rsp_item.getImageId(), rsp_item.getInstanceId(), rsp_item.getDnsName(), rsp_item.getPrivateDnsName(), rsp_item.getInstanceState(), rsp_item.getReason(), rsp_item.getKeyName(), rsp_item.getAmiLaunchIndex(), this.productCodesToList(rsp_item.getProductCodes()), rsp_item.getInstanceType(), rsp_item.getLaunchTime().toGregorianCalendar(), new InstancePlacement(rsp_item.getPlacement().getAvailabilityZone()), rsp_item.getKernelId(), rsp_item.getRamdiskId(), rsp_item.getPlatform());
        }
        return new RequestResultPair<ReservationDescription>(res, rsp.getRequestId());
    }

    public RequestResultPair<Boolean> rebootInstances(String[] instanceIds) throws Exception {
        return this.rebootInstances(Arrays.asList(instanceIds));
    }

    public RequestResultPair<Boolean> rebootInstances(List<String> instanceIds) throws Exception {
        RebootInstancesType req = this.of.createRebootInstancesType();
        RebootInstancesInfoType info = this.of.createRebootInstancesInfoType();
        for (String instanceId : instanceIds) {
            RebootInstancesItemType item = this.of.createRebootInstancesItemType();
            item.setInstanceId(instanceId);
            info.getItem().add(item);
        }
        req.setInstancesSet(info);
        try {
            RebootInstancesResponseType rsp = this.ec2client.rebootInstances(req);
            return new RequestResultPair<Boolean>(rsp.isReturn(), rsp.getRequestId());
        }
        catch (Exception e) {
            throw this.UnwrapException(e);
        }
    }

    public RequestResultPair<List<TerminatingInstanceDescription>> terminateInstances(String[] instanceIds) throws Exception {
        return this.terminateInstances(Arrays.asList(instanceIds));
    }

    public RequestResultPair<List<TerminatingInstanceDescription>> terminateInstances(List<String> instanceIds) throws Exception {
        TerminateInstancesResponseType rsp;
        TerminateInstancesType req = this.of.createTerminateInstancesType();
        TerminateInstancesInfoType info = this.of.createTerminateInstancesInfoType();
        for (String instanceId : instanceIds) {
            TerminateInstancesItemType item = this.of.createTerminateInstancesItemType();
            item.setInstanceId(instanceId);
            info.getItem().add(item);
        }
        req.setInstancesSet(info);
        try {
            rsp = this.ec2client.terminateInstances(req);
        }
        catch (Exception e) {
            throw this.UnwrapException(e);
        }
        ArrayList<TerminatingInstanceDescription> res = new ArrayList<TerminatingInstanceDescription>();
        TerminateInstancesResponseInfoType set = rsp.getInstancesSet();
        for (TerminateInstancesResponseItemType rsp_item : set.getItem()) {
            res.add(new TerminatingInstanceDescription(rsp_item.getInstanceId(), rsp_item.getPreviousState().getName(), rsp_item.getPreviousState().getCode(), rsp_item.getShutdownState().getName(), rsp_item.getShutdownState().getCode()));
        }
        return new RequestResultPair<List<TerminatingInstanceDescription>>(res, rsp.getRequestId());
    }

    public RequestResultPair<List<ReservationDescription>> describeInstances(String[] instanceIds) throws Exception {
        try {
            return this.describeInstances(Arrays.asList(instanceIds));
        }
        catch (Exception e) {
            throw this.UnwrapException(e);
        }
    }

    public RequestResultPair<List<ReservationDescription>> describeInstances(List<String> instanceIds) throws Exception {
        DescribeInstancesResponseType rsp;
        DescribeInstancesType req = this.of.createDescribeInstancesType();
        DescribeInstancesInfoType info = this.of.createDescribeInstancesInfoType();
        for (String instanceId : instanceIds) {
            DescribeInstancesItemType item = this.of.createDescribeInstancesItemType();
            item.setInstanceId(instanceId);
            info.getItem().add(item);
        }
        req.setInstancesSet(info);
        try {
            rsp = this.ec2client.describeInstances(req);
        }
        catch (Exception e) {
            throw this.UnwrapException(e);
        }
        ArrayList<ReservationDescription> reservations = new ArrayList<ReservationDescription>();
        ReservationSetType rsp_set = rsp.getReservationSet();
        for (ReservationInfoType item : rsp_set.getItem()) {
            ReservationDescription res = new ReservationDescription(item.getOwnerId(), item.getReservationId(), item.getRequesterId());
            GroupSetType grp_set = item.getGroupSet();
            for (GroupItemType rsp_item : grp_set.getItem()) {
                res.addGroup(rsp_item.getGroupId());
            }
            RunningInstancesSetType set = item.getInstancesSet();
            for (RunningInstancesItemType rsp_item : set.getItem()) {
                res.addInstance(rsp_item.getImageId(), rsp_item.getInstanceId(), rsp_item.getDnsName(), rsp_item.getPrivateDnsName(), rsp_item.getInstanceState(), rsp_item.getReason(), rsp_item.getKeyName(), rsp_item.getAmiLaunchIndex(), this.productCodesToList(rsp_item.getProductCodes()), rsp_item.getInstanceType(), rsp_item.getLaunchTime().toGregorianCalendar(), new InstancePlacement(rsp_item.getPlacement().getAvailabilityZone()), rsp_item.getKernelId(), rsp_item.getRamdiskId(), rsp_item.getPlatform());
            }
            reservations.add(res);
        }
        return new RequestResultPair<List<ReservationDescription>>(reservations, rsp.getRequestId());
    }

    private List<String> productCodesToList(ProductCodesSetType productCodes) {
        ArrayList<String> pCodes = new ArrayList<String>();
        if (productCodes != null) {
            Iterator<ProductCodesSetItemType> i$ = productCodes.getItem().iterator();
            while (i$.hasNext()) {
                ProductCodesSetItemType obj;
                ProductCodesSetItemType item = obj = i$.next();
                pCodes.add(item.getProductCode());
            }
        }
        return pCodes;
    }

    public ConfirmProductInstanceResult confirmProductInstance(String productCode, String instanceId) throws Exception {
        ConfirmProductInstanceResponseType rsp;
        ConfirmProductInstanceType req = this.of.createConfirmProductInstanceType();
        req.setProductCode(productCode);
        req.setInstanceId(instanceId);
        try {
            rsp = this.ec2client.confirmProductInstance(req);
        }
        catch (Exception e) {
            throw this.UnwrapException(e);
        }
        return new ConfirmProductInstanceResult(rsp.isReturn(), rsp.getOwnerId());
    }

    public RequestResultPair<Boolean> createSecurityGroup(String name, String desc) throws Exception {
        CreateSecurityGroupType req = this.of.createCreateSecurityGroupType();
        req.setGroupName(name);
        req.setGroupDescription(desc);
        try {
            CreateSecurityGroupResponseType rsp = this.ec2client.createSecurityGroup(req);
            return new RequestResultPair<Boolean>(rsp.isReturn(), rsp.getRequestId());
        }
        catch (Exception e) {
            throw this.UnwrapException(e);
        }
    }

    public RequestResultPair<ConsoleOutput> getConsoleOutput(String instanceId) throws Exception {
        GetConsoleOutputResponseType resp;
        GetConsoleOutputType req = this.of.createGetConsoleOutputType();
        req.setInstanceId(instanceId);
        try {
            resp = this.ec2client.getConsoleOutput(req);
        }
        catch (Exception e) {
            throw this.UnwrapException(e);
        }
        ConsoleOutput output = new ConsoleOutput(resp.getInstanceId(), resp.getTimestamp().toGregorianCalendar(), new String(Base64.decode((String)resp.getOutput())));
        return new RequestResultPair<ConsoleOutput>(output, resp.getRequestId());
    }

    public RequestResultPair<Boolean> deleteSecurityGroup(String name) throws Exception {
        DeleteSecurityGroupType req = this.of.createDeleteSecurityGroupType();
        req.setGroupName(name);
        try {
            DeleteSecurityGroupResponseType rsp = this.ec2client.deleteSecurityGroup(req);
            return new RequestResultPair<Boolean>(rsp.isReturn(), rsp.getRequestId());
        }
        catch (Exception e) {
            throw this.UnwrapException(e);
        }
    }

    public RequestResultPair<List<SecurityGroupDescription>> describeSecurityGroups(String[] groupNames) throws Exception {
        return this.describeSecurityGroups(Arrays.asList(groupNames));
    }

    public RequestResultPair<List<SecurityGroupDescription>> describeSecurityGroups(List<String> groupNames) throws Exception {
        DescribeSecurityGroupsResponseType rsp;
        DescribeSecurityGroupsType req = this.of.createDescribeSecurityGroupsType();
        DescribeSecurityGroupsSetType req_set = this.of.createDescribeSecurityGroupsSetType();
        for (String name : groupNames) {
            DescribeSecurityGroupsSetItemType item = this.of.createDescribeSecurityGroupsSetItemType();
            item.setGroupName(name);
            req_set.getItem().add(item);
        }
        req.setSecurityGroupSet(req_set);
        try {
            rsp = this.ec2client.describeSecurityGroups(req);
        }
        catch (Exception e) {
            throw this.UnwrapException(e);
        }
        ArrayList<SecurityGroupDescription> result = new ArrayList<SecurityGroupDescription>();
        SecurityGroupSetType rsp_set = rsp.getSecurityGroupInfo();
        for (SecurityGroupItemType item : rsp_set.getItem()) {
            SecurityGroupDescription group = new SecurityGroupDescription(item.getGroupName(), item.getGroupDescription(), item.getOwnerId());
            IpPermissionSetType perms = item.getIpPermissions();
            for (IpPermissionType perm : perms.getItem()) {
                SecurityGroupDescription.IpPermission group_perms = group.addPermission(perm.getIpProtocol(), perm.getFromPort(), perm.getToPort());
                for (UserIdGroupPairType uid_group : perm.getGroups().getItem()) {
                    group_perms.addUserGroupPair(uid_group.getUserId(), uid_group.getGroupName());
                }
                for (IpRangeItemType range : perm.getIpRanges().getItem()) {
                    group_perms.addIpRange(range.getCidrIp());
                }
            }
            result.add(group);
        }
        return new RequestResultPair<List<SecurityGroupDescription>>(result, rsp.getRequestId());
    }

    public RequestResultPair<Boolean> authorizeSecurityGroupIngress(SecurityGroupDescription gDesc) throws Exception {
        AuthorizeSecurityGroupIngressType req = this.of.createAuthorizeSecurityGroupIngressType();
        req.setUserId(gDesc.owner);
        req.setGroupName(gDesc.name);
        req.setIpPermissions(this.putIpPermissionsInIpPermissionSetType(gDesc.perms));
        try {
            AuthorizeSecurityGroupIngressResponseType rsp = this.ec2client.authorizeSecurityGroupIngress(req);
            return new RequestResultPair<Boolean>(rsp.isReturn(), rsp.getRequestId());
        }
        catch (Exception e) {
            throw this.UnwrapException(e);
        }
    }

    public RequestResultPair<Boolean> revokeSecurityGroupIngress(SecurityGroupDescription gDesc) throws Exception {
        RevokeSecurityGroupIngressType req = this.of.createRevokeSecurityGroupIngressType();
        req.setUserId(gDesc.owner);
        req.setGroupName(gDesc.name);
        req.setIpPermissions(this.putIpPermissionsInIpPermissionSetType(gDesc.perms));
        try {
            RevokeSecurityGroupIngressResponseType rsp = this.ec2client.revokeSecurityGroupIngress(req);
            return new RequestResultPair<Boolean>(rsp.isReturn(), rsp.getRequestId());
        }
        catch (Exception e) {
            throw this.UnwrapException(e);
        }
    }

    private IpPermissionSetType putIpPermissionsInIpPermissionSetType(List<SecurityGroupDescription.IpPermission> perms) throws Exception {
        IpPermissionSetType ipst = this.of.createIpPermissionSetType();
        for (SecurityGroupDescription.IpPermission ip : perms) {
            IpPermissionType ipit = this.of.createIpPermissionType();
            ipit.setFromPort(ip.fromPort);
            ipit.setToPort(ip.toPort);
            ipit.setIpProtocol(ip.protocol);
            UserIdGroupPairSetType uidgpst = this.of.createUserIdGroupPairSetType();
            for (String[] uidgp : ip.uid_group_pairs) {
                UserIdGroupPairType uidgpt = this.of.createUserIdGroupPairType();
                uidgpt.setUserId(uidgp[0]);
                uidgpt.setGroupName(uidgp[1]);
                uidgpst.getItem().add(uidgpt);
            }
            ipit.setGroups(uidgpst);
            IpRangeSetType iprst = this.of.createIpRangeSetType();
            for (String ipRange : ip.cidrIps) {
                IpRangeItemType ipRangeItem = this.of.createIpRangeItemType();
                ipRangeItem.setCidrIp(ipRange);
                iprst.getItem().add(ipRangeItem);
            }
            ipit.setIpRanges(iprst);
            ipst.getItem().add(ipit);
        }
        return ipst;
    }

    public RequestResultPair<KeyPairInfo> createKeyPair(String keyName) throws Exception {
        CreateKeyPairResponseType rsp;
        CreateKeyPairType req = this.of.createCreateKeyPairType();
        req.setKeyName(keyName);
        try {
            rsp = this.ec2client.createKeyPair(req);
        }
        catch (Exception e) {
            throw this.UnwrapException(e);
        }
        KeyPairInfo info = new KeyPairInfo(rsp.getKeyName(), rsp.getKeyFingerprint(), rsp.getKeyMaterial());
        return new RequestResultPair<KeyPairInfo>(info, rsp.getRequestId());
    }

    public RequestResultPair<List<KeyPairInfo>> describeKeyPairs(String[] keyIds) throws Exception {
        return this.describeKeyPairs(Arrays.asList(keyIds));
    }

    public RequestResultPair<List<KeyPairInfo>> describeKeyPairs(List<String> keyIds) throws Exception {
        DescribeKeyPairsResponseType rsp;
        DescribeKeyPairsType req = this.of.createDescribeKeyPairsType();
        DescribeKeyPairsInfoType info = this.of.createDescribeKeyPairsInfoType();
        for (String imageId : keyIds) {
            DescribeKeyPairsItemType item = this.of.createDescribeKeyPairsItemType();
            item.setKeyName(imageId);
            info.getItem().add(item);
        }
        req.setKeySet(info);
        try {
            rsp = this.ec2client.describeKeyPairs(req);
        }
        catch (Exception e) {
            throw this.UnwrapException(e);
        }
        ArrayList<KeyPairInfo> result = new ArrayList<KeyPairInfo>();
        DescribeKeyPairsResponseInfoType set = rsp.getKeySet();
        for (DescribeKeyPairsResponseItemType item : set.getItem()) {
            result.add(new KeyPairInfo(item.getKeyName(), item.getKeyFingerprint(), null));
        }
        return new RequestResultPair<List<KeyPairInfo>>(result, rsp.getRequestId());
    }

    public RequestResultPair<Boolean> deleteKeyPair(String keyName) throws Exception {
        DeleteKeyPairType req = this.of.createDeleteKeyPairType();
        req.setKeyName(keyName);
        try {
            DeleteKeyPairResponseType rsp = this.ec2client.deleteKeyPair(req);
            return new RequestResultPair<Boolean>(rsp.isReturn(), rsp.getRequestId());
        }
        catch (Exception e) {
            throw this.UnwrapException(e);
        }
    }

    public RequestResultPair<List<AvailabilityZoneDescription>> describeAvailabilityZones(String[] zoneNames) throws Exception {
        return this.describeAvailabilityZones(Arrays.asList(zoneNames));
    }

    public RequestResultPair<List<AvailabilityZoneDescription>> describeAvailabilityZones(List<String> zoneNames) throws Exception {
        DescribeAvailabilityZonesResponseType rsp;
        DescribeAvailabilityZonesType req = this.of.createDescribeAvailabilityZonesType();
        DescribeAvailabilityZonesSetType req_set = this.of.createDescribeAvailabilityZonesSetType();
        for (String name : zoneNames) {
            DescribeAvailabilityZonesSetItemType item = this.of.createDescribeAvailabilityZonesSetItemType();
            item.setZoneName(name);
            req_set.getItem().add(item);
        }
        req.setAvailabilityZoneSet(req_set);
        try {
            rsp = this.ec2client.describeAvailabilityZones(req);
        }
        catch (Exception e) {
            throw this.UnwrapException(e);
        }
        ArrayList<AvailabilityZoneDescription> result = new ArrayList<AvailabilityZoneDescription>();
        for (AvailabilityZoneItemType item : rsp.getAvailabilityZoneInfo().getItem()) {
            result.add(new AvailabilityZoneDescription(item.getZoneName(), item.getZoneState(), item.getRegionName()));
        }
        return new RequestResultPair<List<AvailabilityZoneDescription>>(result, rsp.getRequestId());
    }

    public RequestResultPair<List<RegionDescription>> describeRegions(String[] regionNames) throws Exception {
        return this.describeRegions(Arrays.asList(regionNames));
    }

    public RequestResultPair<List<RegionDescription>> describeRegions(List<String> regionNames) throws Exception {
        DescribeRegionsResponseType rsp;
        DescribeRegionsType req = this.of.createDescribeRegionsType();
        DescribeRegionsSetType req_set = this.of.createDescribeRegionsSetType();
        for (String name : regionNames) {
            DescribeRegionsSetItemType item = this.of.createDescribeRegionsSetItemType();
            item.setRegionName(name);
            req_set.getItem().add(item);
        }
        req.setRegionSet(req_set);
        try {
            rsp = this.ec2client.describeRegions(req);
        }
        catch (Exception e) {
            throw this.UnwrapException(e);
        }
        ArrayList<RegionDescription> result = new ArrayList<RegionDescription>();
        for (RegionItemType item : rsp.getRegionInfo().getItem()) {
            result.add(new RegionDescription(item.getRegionName(), item.getRegionEndpoint()));
        }
        return new RequestResultPair<List<RegionDescription>>(result, rsp.getRequestId());
    }

    public RequestResultPair<String> allocateAddress() throws Exception {
        AllocateAddressResponseType rsp;
        AllocateAddressType req = this.of.createAllocateAddressType();
        try {
            rsp = this.ec2client.allocateAddress(req);
        }
        catch (Exception e) {
            throw this.UnwrapException(e);
        }
        String result = rsp.getPublicIp();
        return new RequestResultPair<String>(result, rsp.getRequestId());
    }

    public RequestResultPair<Boolean> releaseAddress(String publicIp) throws Exception {
        ReleaseAddressType req = this.of.createReleaseAddressType();
        req.setPublicIp(publicIp);
        try {
            ReleaseAddressResponseType rsp = this.ec2client.releaseAddress(req);
            return new RequestResultPair<Boolean>(rsp.isReturn(), rsp.getRequestId());
        }
        catch (Exception e) {
            throw this.UnwrapException(e);
        }
    }

    public RequestResultPair<List<AddressInfo>> describeAddresses(String[] publicIps) throws Exception {
        return this.describeAddresses(Arrays.asList(publicIps));
    }

    public RequestResultPair<List<AddressInfo>> describeAddresses(List<String> publicIps) throws Exception {
        DescribeAddressesResponseType rsp;
        DescribeAddressesType req = this.of.createDescribeAddressesType();
        DescribeAddressesInfoType info = this.of.createDescribeAddressesInfoType();
        for (String publicIp : publicIps) {
            DescribeAddressesItemType item = this.of.createDescribeAddressesItemType();
            item.setPublicIp(publicIp);
            info.getItem().add(item);
        }
        req.setPublicIpsSet(info);
        try {
            rsp = this.ec2client.describeAddresses(req);
        }
        catch (Exception e) {
            throw this.UnwrapException(e);
        }
        ArrayList<AddressInfo> result = new ArrayList<AddressInfo>();
        DescribeAddressesResponseInfoType set = rsp.getAddressesSet();
        for (DescribeAddressesResponseItemType item : set.getItem()) {
            result.add(new AddressInfo(item.getPublicIp(), item.getInstanceId()));
        }
        return new RequestResultPair<List<AddressInfo>>(result, rsp.getRequestId());
    }

    public RequestResultPair<Boolean> associateAddress(String publicIp, String instanceId) throws Exception {
        AssociateAddressType req = this.of.createAssociateAddressType();
        req.setPublicIp(publicIp);
        req.setInstanceId(instanceId);
        try {
            AssociateAddressResponseType rsp = this.ec2client.associateAddress(req);
            return new RequestResultPair<Boolean>(rsp.isReturn(), rsp.getRequestId());
        }
        catch (Exception e) {
            throw this.UnwrapException(e);
        }
    }

    public RequestResultPair<Boolean> disassociateAddress(String publicIp) throws Exception {
        DisassociateAddressType req = this.of.createDisassociateAddressType();
        req.setPublicIp(publicIp);
        try {
            DisassociateAddressResponseType rsp = this.ec2client.disassociateAddress(req);
            return new RequestResultPair<Boolean>(rsp.isReturn(), rsp.getRequestId());
        }
        catch (Exception e) {
            throw this.UnwrapException(e);
        }
    }

    public RequestResultPair<BundleInstanceTask> bundleInstance(String instanceId, String awsAccessKeyId, String bucket, String prefix, String policy, String policySignature) throws Exception {
        BundleInstanceResponseType resp;
        BundleInstanceType req = this.of.createBundleInstanceType();
        BundleInstanceTaskStorageType storage = this.of.createBundleInstanceTaskStorageType();
        BundleInstanceS3StorageType s3 = this.of.createBundleInstanceS3StorageType();
        s3.setAwsAccessKeyId(awsAccessKeyId);
        s3.setBucket(bucket);
        s3.setPrefix(prefix);
        s3.setUploadPolicy(policy);
        s3.setUploadPolicySignature(policySignature);
        storage.setS3(s3);
        req.setInstanceId(instanceId);
        req.setStorage(storage);
        try {
            resp = this.ec2client.bundleInstance(req);
        }
        catch (Exception e) {
            throw this.UnwrapException(e);
        }
        BundleInstanceTask task = this.createBundleInstanceTask(resp.getBundleInstanceTask());
        return new RequestResultPair<BundleInstanceTask>(task, resp.getRequestId());
    }

    protected BundleInstanceTask createBundleInstanceTask(BundleInstanceTaskType btask) {
        String errorCode = null;
        String errorMessage = null;
        if (btask.getError() != null) {
            errorCode = btask.getError().getCode();
            errorMessage = btask.getError().getMessage();
        }
        return new BundleInstanceTask(btask.getBundleId(), btask.getInstanceId(), btask.getStorage().getS3().getBucket(), btask.getStorage().getS3().getPrefix(), btask.getState(), btask.getStartTime().toGregorianCalendar(), btask.getUpdateTime().toGregorianCalendar(), btask.getProgress(), errorCode, errorMessage);
    }

    public RequestResultPair<List<BundleInstanceTask>> describeBundleTasks(List<String> bundleIds) throws Exception {
        DescribeBundleTasksResponseType resp;
        DescribeBundleTasksType req = this.of.createDescribeBundleTasksType();
        DescribeBundleTasksInfoType info = this.of.createDescribeBundleTasksInfoType();
        for (String bundleId : bundleIds) {
            DescribeBundleTasksItemType item = this.of.createDescribeBundleTasksItemType();
            item.setBundleId(bundleId);
            info.getItem().add(item);
        }
        req.setBundlesSet(info);
        try {
            resp = this.ec2client.describeBundleTasks(req);
        }
        catch (Exception e) {
            throw this.UnwrapException(e);
        }
        LinkedList<BundleInstanceTask> tasks = new LinkedList<BundleInstanceTask>();
        for (BundleInstanceTaskType task : resp.getBundleInstanceTasksSet().getItem()) {
            tasks.add(this.createBundleInstanceTask(task));
        }
        return new RequestResultPair<List<BundleInstanceTask>>(tasks, resp.getRequestId());
    }

    public RequestResultPair<BundleInstanceTask> cancelBundleTask(String bundleId) throws Exception {
        CancelBundleTaskResponseType resp;
        CancelBundleTaskType req = this.of.createCancelBundleTaskType();
        req.setBundleId(bundleId);
        try {
            resp = this.ec2client.cancelBundleTask(req);
        }
        catch (Exception e) {
            throw this.UnwrapException(e);
        }
        BundleInstanceTask task = this.createBundleInstanceTask(resp.getBundleInstanceTask());
        return new RequestResultPair<BundleInstanceTask>(task, resp.getRequestId());
    }

    public RequestResultPair<VolumeDescription> createVolume(String size, String snapshotId, String availabilityZone) throws Exception {
        CreateVolumeResponseType rsp;
        CreateVolumeType req = this.of.createCreateVolumeType();
        req.setSize(size);
        req.setSnapshotId(snapshotId);
        req.setAvailabilityZone(availabilityZone);
        try {
            rsp = this.ec2client.createVolume(req);
        }
        catch (Exception e) {
            throw this.UnwrapException(e);
        }
        VolumeDescription desc = new VolumeDescription(rsp.getVolumeId(), rsp.getSize(), rsp.getSnapshotId(), rsp.getAvailabilityZone(), rsp.getStatus(), rsp.getCreateTime().toGregorianCalendar());
        return new RequestResultPair<VolumeDescription>(desc, rsp.getRequestId());
    }

    public RequestResultPair<Boolean> deleteVolume(String volumeId) throws Exception {
        DeleteVolumeType req = this.of.createDeleteVolumeType();
        req.setVolumeId(volumeId);
        try {
            DeleteVolumeResponseType rsp = this.ec2client.deleteVolume(req);
            return new RequestResultPair<Boolean>(rsp.isReturn(), rsp.getRequestId());
        }
        catch (Exception e) {
            throw this.UnwrapException(e);
        }
    }

    public RequestResultPair<List<VolumeDescription>> describeVolumes(List<String> volumes) throws Exception {
        DescribeVolumesResponseType rsp;
        DescribeVolumesType req = this.of.createDescribeVolumesType();
        DescribeVolumesSetType req_set = this.of.createDescribeVolumesSetType();
        for (String volumeId : volumes) {
            DescribeVolumesSetItemType item = this.of.createDescribeVolumesSetItemType();
            item.setVolumeId(volumeId);
            req_set.getItem().add(item);
        }
        req.setVolumeSet(req_set);
        try {
            rsp = this.ec2client.describeVolumes(req);
        }
        catch (Exception e) {
            throw this.UnwrapException(e);
        }
        ArrayList<VolumeDescription> result = new ArrayList<VolumeDescription>();
        for (DescribeVolumesSetItemResponseType item : rsp.getVolumeSet().getItem()) {
            VolumeDescription volumeDescription = new VolumeDescription(item.getVolumeId(), item.getSize(), item.getSnapshotId(), item.getAvailabilityZone(), item.getStatus(), item.getCreateTime().toGregorianCalendar());
            for (AttachmentSetItemResponseType att : item.getAttachmentSet().getItem()) {
                AttachmentDescription attachment = new AttachmentDescription(att.getVolumeId(), att.getInstanceId(), att.getDevice(), att.getStatus(), att.getAttachTime().toGregorianCalendar());
                volumeDescription.addAttachment(attachment);
            }
            result.add(volumeDescription);
        }
        return new RequestResultPair<List<VolumeDescription>>(result, rsp.getRequestId());
    }

    public RequestResultPair<List<VolumeDescription>> describeVolumes(String[] volumes) throws Exception {
        return this.describeVolumes(Arrays.asList(volumes));
    }

    public RequestResultPair<AttachmentDescription> attachVolume(String volumeId, String instanceId, String device) throws Exception {
        AttachVolumeResponseType rsp;
        AttachVolumeType req = this.of.createAttachVolumeType();
        req.setVolumeId(volumeId);
        req.setInstanceId(instanceId);
        req.setDevice(device);
        try {
            rsp = this.ec2client.attachVolume(req);
        }
        catch (Exception e) {
            throw this.UnwrapException(e);
        }
        AttachmentDescription desc = new AttachmentDescription(rsp.getVolumeId(), rsp.getInstanceId(), rsp.getDevice(), rsp.getStatus(), rsp.getAttachTime().toGregorianCalendar());
        return new RequestResultPair<AttachmentDescription>(desc, rsp.getRequestId());
    }

    public RequestResultPair<AttachmentDescription> detachVolume(String volumeId, String instanceId, String device, Boolean force) throws Exception {
        DetachVolumeResponseType rsp;
        DetachVolumeType req = this.of.createDetachVolumeType();
        req.setVolumeId(volumeId);
        req.setInstanceId(instanceId);
        req.setDevice(device);
        req.setForce(force);
        try {
            rsp = this.ec2client.detachVolume(req);
        }
        catch (Exception e) {
            throw this.UnwrapException(e);
        }
        AttachmentDescription desc = new AttachmentDescription(rsp.getVolumeId(), rsp.getInstanceId(), rsp.getDevice(), rsp.getStatus(), rsp.getAttachTime().toGregorianCalendar());
        return new RequestResultPair<AttachmentDescription>(desc, rsp.getRequestId());
    }

    public RequestResultPair<SnapshotDescription> createSnapshot(String volumeId) throws Exception {
        CreateSnapshotResponseType rsp;
        CreateSnapshotType req = this.of.createCreateSnapshotType();
        req.setVolumeId(volumeId);
        try {
            rsp = this.ec2client.createSnapshot(req);
        }
        catch (Exception e) {
            throw this.UnwrapException(e);
        }
        SnapshotDescription desc = new SnapshotDescription(rsp.getSnapshotId(), rsp.getVolumeId(), rsp.getStatus(), rsp.getStartTime().toGregorianCalendar(), rsp.getProgress());
        return new RequestResultPair<SnapshotDescription>(desc, rsp.getRequestId());
    }

    public RequestResultPair<Boolean> deleteSnapshot(String snapshotId) throws Exception {
        DeleteSnapshotType req = this.of.createDeleteSnapshotType();
        req.setSnapshotId(snapshotId);
        try {
            DeleteSnapshotResponseType rsp = this.ec2client.deleteSnapshot(req);
            return new RequestResultPair<Boolean>(rsp.isReturn(), rsp.getRequestId());
        }
        catch (Exception e) {
            throw this.UnwrapException(e);
        }
    }

    public RequestResultPair<List<SnapshotDescription>> describeSnapshots(List<String> snapshots) throws Exception {
        DescribeSnapshotsResponseType rsp;
        DescribeSnapshotsType req = this.of.createDescribeSnapshotsType();
        DescribeSnapshotsSetType req_set = this.of.createDescribeSnapshotsSetType();
        for (String snapshotId : snapshots) {
            DescribeSnapshotsSetItemType item = this.of.createDescribeSnapshotsSetItemType();
            item.setSnapshotId(snapshotId);
            req_set.getItem().add(item);
        }
        req.setSnapshotSet(req_set);
        try {
            rsp = this.ec2client.describeSnapshots(req);
        }
        catch (Exception e) {
            throw this.UnwrapException(e);
        }
        ArrayList<SnapshotDescription> result = new ArrayList<SnapshotDescription>();
        for (DescribeSnapshotsSetItemResponseType item : rsp.getSnapshotSet().getItem()) {
            result.add(new SnapshotDescription(item.getSnapshotId(), item.getVolumeId(), item.getStatus(), item.getStartTime().toGregorianCalendar(), item.getProgress()));
        }
        return new RequestResultPair<List<SnapshotDescription>>(result, rsp.getRequestId());
    }

    public RequestResultPair<List<ReservedInstancesOfferingDescription>> describeReservedInstancesOfferings(List<String> offeringsIds, String availabilityZone, String instanceType, String productDescription) throws Exception {
        DescribeReservedInstancesOfferingsResponseType rsp;
        DescribeReservedInstancesOfferingsType req = this.of.createDescribeReservedInstancesOfferingsType();
        req.setAvailabilityZone(availabilityZone);
        req.setInstanceType(instanceType);
        req.setProductDescription(productDescription);
        DescribeReservedInstancesOfferingsSetType reqSet = this.of.createDescribeReservedInstancesOfferingsSetType();
        for (String offeringId : offeringsIds) {
            DescribeReservedInstancesOfferingsSetItemType item = this.of.createDescribeReservedInstancesOfferingsSetItemType();
            item.setReservedInstancesOfferingId(offeringId);
            reqSet.getItem().add(item);
        }
        req.setReservedInstancesOfferingsSet(reqSet);
        try {
            rsp = this.ec2client.describeReservedInstancesOfferings(req);
        }
        catch (Exception e) {
            throw this.UnwrapException(e);
        }
        ArrayList<ReservedInstancesOfferingDescription> result = new ArrayList<ReservedInstancesOfferingDescription>();
        for (DescribeReservedInstancesOfferingsResponseSetItemType item : rsp.getReservedInstancesOfferingsSet().getItem()) {
            result.add(new ReservedInstancesOfferingDescription(item.getReservedInstancesOfferingId(), item.getAvailabilityZone(), item.getInstanceType(), item.getDuration(), item.getFixedPrice(), item.getUsagePrice(), item.getProductDescription()));
        }
        return new RequestResultPair<List<ReservedInstancesOfferingDescription>>(result, rsp.getRequestId());
    }

    public RequestResultPair<List<ReservedInstancesDescription>> describeReservedInstances(List<String> instanceReservationIds) throws Exception {
        DescribeReservedInstancesResponseType rsp;
        DescribeReservedInstancesType req = this.of.createDescribeReservedInstancesType();
        DescribeReservedInstancesSetType reqSet = this.of.createDescribeReservedInstancesSetType();
        for (String instanceReservationId : instanceReservationIds) {
            DescribeReservedInstancesSetItemType item = this.of.createDescribeReservedInstancesSetItemType();
            item.setReservedInstancesId(instanceReservationId);
            reqSet.getItem().add(item);
        }
        req.setReservedInstancesSet(reqSet);
        try {
            rsp = this.ec2client.describeReservedInstances(req);
        }
        catch (Exception e) {
            throw this.UnwrapException(e);
        }
        ArrayList<ReservedInstancesDescription> result = new ArrayList<ReservedInstancesDescription>();
        for (DescribeReservedInstancesResponseSetItemType item : rsp.getReservedInstancesSet().getItem()) {
            result.add(new ReservedInstancesDescription(item.getReservedInstancesId(), item.getAvailabilityZone(), item.getInstanceType(), item.getDuration(), item.getFixedPrice(), item.getUsagePrice(), item.getProductDescription(), item.getStart().toGregorianCalendar(), item.getInstanceCount().intValue(), item.getState()));
        }
        return new RequestResultPair<List<ReservedInstancesDescription>>(result, rsp.getRequestId());
    }

    public RequestResultPair<String> purchaseReservedInstancesOffering(String offeringId, int instanceCount) throws Exception {
        PurchaseReservedInstancesOfferingResponseType rsp;
        PurchaseReservedInstancesOfferingType req = this.of.createPurchaseReservedInstancesOfferingType();
        req.setReservedInstancesOfferingId(offeringId);
        req.setInstanceCount(instanceCount);
        try {
            rsp = this.ec2client.purchaseReservedInstancesOffering(req);
        }
        catch (Exception e) {
            throw this.UnwrapException(e);
        }
        String result = rsp.getReservedInstancesId();
        return new RequestResultPair<String>(result, rsp.getRequestId());
    }

    public RequestResultPair<List<SnapshotDescription>> describeSnapshots(String[] snapshots) throws Exception {
        return this.describeSnapshots(Arrays.asList(snapshots));
    }

    public static void main(String[] args) {
        String url = "https://ec2.amazonaws.com";
        if (args.length < 2) {
            System.out.println("Usage: " + Jec2.class.getSimpleName() + " <key> <cert> [url]");
            System.exit(1);
        }
        String key = args[0];
        String cert = args[1];
        if (args.length > 2) {
            url = args[2];
        }
        try {
            Jec2 ec2 = new Jec2(new URL(url), key, cert);
            RequestResultPair<List<ReservationDescription>> instances = ec2.describeInstances(new String[0]);
            System.out.println("DescribeInstances " + instances.getResponse());
            RequestResultPair<List<ImageDescription>> images = ec2.describeImages(new String[0]);
            System.out.println("DescribeImages " + images.getResponse());
            RequestResultPair<List<KeyPairInfo>> keypairs = ec2.describeKeyPairs(new String[0]);
            System.out.println("DescribeKeyPairs: " + keypairs.getResponse());
            RequestResultPair<List<ReservationDescription>> reservations = ec2.describeInstances(new String[0]);
            System.out.println("DescribeInstances" + reservations.getResponse());
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }

    static {
        BODY = SOAPConstants.SOAP11_CONSTANTS.getBodyQName().getLocalPart();
        ENVELOPE_URI = SOAPConstants.SOAP11_CONSTANTS.getEnvelopeURI();
    }

    public class ConfirmProductInstanceResult {
        public boolean confirmed;
        public String ownerId;

        public ConfirmProductInstanceResult(boolean confirmed, String ownerId) {
            this.confirmed = confirmed;
            this.ownerId = ownerId;
        }
    }
}

