/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.ConsoleOutput;
import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.RequestResult;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.GeneralError;
import com.amazon.aes.webservices.client.cmd.InvalidArgumentCombination;
import com.amazon.aes.webservices.client.cmd.Outputter;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import javax.crypto.Cipher;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMReader;
import org.codehaus.xfire.util.Base64;
import sun.misc.BASE64Decoder;

public class GetPassword
extends BaseCmd {
    private static final String[] PRIV_LAUNCH_KEY_DESC = new String[]{"file containing the unencrypted PEM encoded PKCS#8 private", "key portion of the keypair specified when launching", "the instance."};
    final String START_TAG = "<Password>\r\n";
    final String END_TAG = "\r\n</Password>";
    int currIndex = 0;

    public String GetPasswordFromOutput(String consoleOutput, PrivateKey privateKey) throws Exception {
        boolean foundPass = false;
        String nextPass = null;
        String encodedPass = null;
        String password = null;
        while ((nextPass = this.fetchNextEncodedPassword(consoleOutput)) != null) {
            foundPass = true;
            encodedPass = nextPass;
        }
        if (!foundPass) {
            throw new GeneralError("No <Password> element found on console output");
        }
        if (this.isOptionSet("verbose")) {
            System.err.println("Found encrypted password: " + encodedPass);
        }
        try {
            password = this.decodePassword(encodedPass, privateKey);
        }
        catch (Exception e) {
            throw new GeneralError("Failed to decode password with the provided key. Please check your key and try again.", e);
        }
        return password;
    }

    public String fetchNextEncodedPassword(String ConsoleOutput2) throws Exception {
        int startIndex = ConsoleOutput2.indexOf("<Password>\r\n", this.currIndex);
        if (startIndex == -1) {
            return null;
        }
        int endIndex = ConsoleOutput2.indexOf("\r\n</Password>", startIndex);
        if (endIndex == -1) {
            throw new GeneralError("Malformed console output. No </Password> tag found.");
        }
        String encodedPass = ConsoleOutput2.substring(startIndex + "<Password>\r\n".length(), endIndex);
        this.currIndex = endIndex + "\r\n</Password>".length();
        return encodedPass;
    }

    public String decodePassword(String buf, PrivateKey privateKey) throws Exception {
        byte[] decodeCypherText = new BASE64Decoder().decodeBuffer(buf);
        Cipher decrypt_cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
        decrypt_cipher.init(2, privateKey);
        byte[] plaintext = decrypt_cipher.doFinal(decodeCypherText);
        return new String(plaintext);
    }

    private PrivateKey loadPrivateKeyByName(String fileName) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException {
        String line;
        BufferedReader br = new BufferedReader(new FileReader(fileName));
        StringBuffer keyBuf = new StringBuffer();
        boolean pkcs8 = false;
        while ((line = br.readLine()) != null) {
            if (line.startsWith("-----BEGIN PRIVATE KEY")) {
                pkcs8 = true;
                continue;
            }
            if (line.startsWith("-----END")) continue;
            keyBuf.append(line);
        }
        br.close();
        if (pkcs8) {
            PKCS8EncodedKeySpec privKeySpec = new PKCS8EncodedKeySpec(Base64.decode((String)keyBuf.toString()));
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PrivateKey privKey = keyFactory.generatePrivate(privKeySpec);
            return privKey;
        }
        PEMReader pemReader = new PEMReader((Reader)new BufferedReader(new FileReader(fileName)));
        KeyPair kp = (KeyPair)pemReader.readObject();
        return kp == null ? null : kp.getPrivate();
    }

    public GetPassword(String[] args) {
        super("ec2gpass", "ec2-get-password");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    private Options getOptions() {
        Options result = new Options();
        OptionBuilder.withLongOpt((String)"instance");
        OptionBuilder.hasArgs();
        result.addOption(OptionBuilder.create((String)"i"));
        OptionBuilder.withLongOpt((String)"priv-launch-key");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription((String)GetPassword.joinDescription(PRIV_LAUNCH_KEY_DESC));
        result.addOption(OptionBuilder.create((String)"k"));
        return result;
    }

    protected String getOptionString() {
        return "INSTANCE -k KEYFILE";
    }

    public void printDescription() {
        super.printDescription();
        System.out.println("     Fetch and decrypt the Administrator password for a Windows instance.");
        System.out.println();
        System.out.println("     The password is encrypted with the private key used when launching");
        System.out.println("     the instance. It is Base64-encoded and emitted to the console output");
        System.out.println("     when the instance boots. This command parses the console output and");
        System.out.println("     decrypts the password.");
        System.out.println();
        System.out.println("     The KEYFILE parameter is a file containing the unencrypted PEM encoded");
        System.out.println("     PKCS#8 private key portion of the keypair specified when launching");
        System.out.println("     the instance.");
    }

    public void printOptions() {
        super.printOptions(true);
        this.printOption("priv-launch-key");
    }

    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        this.assertNonOptionSet("INSTANCE");
        this.assertOptionSet("priv-launch-key");
        this.warnIfTooManyNonOptions();
        String instanceId = this.getNonOptions()[0];
        PrivateKey privateKey = this.loadPrivateKey(this.getOptionValue("priv-launch-key"));
        RequestResultPair rsp = jec2.getConsoleOutput(instanceId);
        out.output(System.out, this.GetPasswordFromOutput(new String(((ConsoleOutput)rsp.getResponse()).output), privateKey));
        System.out.println();
        out.printRequestId(System.out, (RequestResult)rsp);
        return true;
    }

    protected PrivateKey loadPrivateKey(String privKeyFile) {
        try {
            PrivateKey privateKey = this.loadPrivateKeyByName(privKeyFile);
            if (privateKey == null) {
                throw new InvalidArgumentCombination("Unable to load private key from: " + privKeyFile);
            }
            return privateKey;
        }
        catch (Exception e) {
            throw new InvalidArgumentCombination("Unable to load private key: " + e.getMessage());
        }
    }

    public static void main(String[] args) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        new GetPassword(args).invoke();
    }
}

