/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.DescribeImageAttributeResult;
import com.amazon.aes.webservices.client.ImageAttribute;
import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.RequestResult;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.cmd.ImageAttributeBaseCmd;
import com.amazon.aes.webservices.client.cmd.Outputter;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DescribeImageAttribute
extends ImageAttributeBaseCmd {
    private static final String PROFILE_DESC = "Describe the OS-profile associated with the specified AKI.";
    private static final String RAMDISK_DESC = "Describe the ramdisk id the AMI will be launched with.";
    private static final String KERNEL_DESC = "Describe the kernel id the AMI will be launched with.";
    private static final String PRODUCT_CODE_DESC = "Describe the product code associated with the specified IMAGE.";
    private static final String LAUNCH_PERMISSION_DESC = "Describe launch permissions granted on the specified IMAGE.";
    private static final String BLOCK_DEVICE_MAPPING_DESC = "Describe the block-device mappings for the specified AMI.";

    public DescribeImageAttribute(String[] args) {
        super("ec2datt", "ec2-describe-image-attribute");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    private Options getOptions() {
        Options result = new Options();
        OptionBuilder.withLongOpt((String)"launch-permission");
        OptionBuilder.withDescription((String)LAUNCH_PERMISSION_DESC);
        result.addOption(OptionBuilder.create((String)"l"));
        OptionBuilder.withLongOpt((String)"product-code");
        OptionBuilder.withDescription((String)PRODUCT_CODE_DESC);
        result.addOption(OptionBuilder.create((String)"p"));
        OptionBuilder.withLongOpt((String)"kernel");
        OptionBuilder.withDescription((String)KERNEL_DESC);
        result.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"ramdisk");
        OptionBuilder.withDescription((String)RAMDISK_DESC);
        result.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"block-device-mapping");
        OptionBuilder.withDescription((String)BLOCK_DEVICE_MAPPING_DESC);
        result.addOption(OptionBuilder.create((String)"B"));
        return result;
    }

    @Override
    protected String getOptionString() {
        return null;
    }

    @Override
    protected List<String> getOptionStrings() {
        ArrayList<String> options = new ArrayList<String>();
        options.add("IMAGE (-l | -p )");
        options.add("AMI (-B | --kernel | --ramdisk)");
        return options;
    }

    @Override
    public void printOptions() {
        super.printOptions(true);
        this.printOption("block-device-mapping");
        this.printOption("launch-permission");
        this.printOption("product-code");
        this.printOption("kernel");
        this.printOption("ramdisk");
    }

    @Override
    public void printDescription() {
        super.printDescription();
        System.out.println("     Describe an attribute on an Amazon Image. The IMAGE parameter is the ID");
        System.out.println("     of the Amazon Image to describe an attribute for. An Amazon Image may be:");
        System.out.println("     \t- an Amazon Machine Image (AMI) or");
        System.out.println("     \t- an Amazon Kernel  Image (AKI) or");
        System.out.println("     \t- an Amazon Ramdisk Image (ARI).");
    }

    @Override
    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        String imageId = this.getAmiId();
        this.assertAtLeastOneOptionSet(ATTRIBUTE_ARGS);
        this.assertOnlyOneOptionSet(ATTRIBUTE_ARGS);
        ImageAttribute.ImageAttributeType attributeType = this.getImageAttributeType(jec2);
        RequestResultPair result = jec2.describeImageAttribute(imageId, attributeType);
        ImageAttribute attribute = ((DescribeImageAttributeResult)result.getResponse()).imageAttribute;
        if (attribute != null) {
            out.output(System.out, ((DescribeImageAttributeResult)result.getResponse()).imageId, attribute);
            out.printRequestId(System.out, (RequestResult)result);
            return true;
        }
        return false;
    }

    public static void main(String[] args) {
        new DescribeImageAttribute(args).invoke();
    }
}

