/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.AddressInfo;
import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.RequestResult;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.Outputter;
import java.util.List;
import org.apache.commons.cli.Options;

public class DescribeAddresses
extends BaseCmd {
    public DescribeAddresses(String[] args) {
        super("ec2daddr", "ec2-describe-addresses");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    private Options getOptions() {
        return new Options();
    }

    protected String getOptionString() {
        return "[IP [IP [...]]]";
    }

    public void printDescription() {
        super.printDescription();
        System.out.println("     List and describe your allocated elastic IP addresses");
        System.out.println("     The IP parameter specifies the IP(s) to be described.");
        System.out.println("     If unspecified all addresses allocated to you will be returned.");
    }

    public void printOptions() {
        super.printOptions();
    }

    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        String[] publicIps = this.getNonOptions();
        RequestResultPair rsp = jec2.describeAddresses(publicIps);
        for (AddressInfo kp : (List)rsp.getResponse()) {
            out.outputAddress(System.out, kp.publicIp, kp.instanceId);
        }
        out.printRequestId(System.out, (RequestResult)rsp);
        return true;
    }

    public static void main(String[] args) {
        new DescribeAddresses(args).invoke();
    }
}

