/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.RequestResult;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.VolumeDescription;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.MissingAtLeastOneArgument;
import com.amazon.aes.webservices.client.cmd.Outputter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;

public class CreateVolume
extends BaseCmd {
    private static final String AVAILABILITY_ZONE_DESC = "The zone in which the volume should be created.";
    private static final String SNAPSHOT_DESC = "The snapshot on which the volume should be based.";
    private static final String VOLUME_SIZE_DESC = "The size of the volume, in GiB (2^30 octets), to be created.";
    private static final String AVAILABILITY_ZONE_ARG = "ZONE";
    private static final String SNAPSHOT_ARG = "SNAPSHOT";
    private static final String VOLUME_SIZE_ARG = "SIZE";

    public CreateVolume(String[] args) {
        super("ec2addvol", "ec2-create-volume");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    private Options getOptions() {
        Options result = new Options();
        OptionBuilder.withLongOpt((String)"size");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription((String)VOLUME_SIZE_DESC);
        OptionBuilder.withArgName((String)VOLUME_SIZE_ARG);
        result.addOption(OptionBuilder.create((String)"s"));
        OptionBuilder.withLongOpt((String)"snapshot");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription((String)SNAPSHOT_DESC);
        OptionBuilder.withArgName((String)SNAPSHOT_ARG);
        result.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"availability-zone");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription((String)AVAILABILITY_ZONE_DESC);
        OptionBuilder.withArgName((String)AVAILABILITY_ZONE_ARG);
        result.addOption(OptionBuilder.create((String)"z"));
        return result;
    }

    protected String getOptionString() {
        return "(-s SIZE | --snapshot SNAPSHOT [-s SIZE]) -z ZONE";
    }

    public void printDescription() {
        super.printDescription();
        System.out.println("     Create a new volume.");
        System.out.println("     Create a volume, possibly based on a snapshot, of the indicated size in the specified zone.");
    }

    public void printOptions() {
        super.printOptions();
        this.printOption("size");
        this.printOption("snapshot");
        this.printOption("availability-zone");
    }

    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        this.warnIfTooManyNonOptions();
        if (!this.isOptionSet("size") && !this.isOptionSet("snapshot")) {
            throw new MissingAtLeastOneArgument(new String[]{"size", "snapshot"});
        }
        this.assertOptionSet("availability-zone");
        String size = this.isOptionSet("size") ? this.getOptionValue("size") : null;
        String snapshotId = this.isOptionSet("snapshot") ? this.getOptionValue("snapshot") : null;
        String zone = this.getOptionValue("availability-zone");
        RequestResultPair rsp = jec2.createVolume(size, snapshotId, zone);
        if (rsp.getResponse() != null) {
            out.output(System.out, (VolumeDescription)rsp.getResponse());
            out.printRequestId(System.out, (RequestResult)rsp);
            return true;
        }
        return false;
    }

    public static void main(String[] args) {
        new CreateVolume(args).invoke();
    }
}

