/////////////////////////////////////////////////////////////////////////////
// Name:        Languages.cpp
// Purpose:     Languages dialog
// Author:      Alex Thuering
// Created:	23.05.2003
// Remarks:	Based on LangChoice from audacity
// RCS-ID:      $Id: Languages.cpp,v 1.8 2010/04/03 21:45:27 ntalex Exp $
// Copyright:   (c) Alex Thuering
// Licence:     GPL
/////////////////////////////////////////////////////////////////////////////

#include "Languages.h"
#include <wxVillaLib/utils.h>
#include <wx/defs.h>
#include <wx/button.h>
#include <wx/choice.h>
#include <wx/dialog.h>
#include <wx/intl.h>
#include <wx/sizer.h>
#include <wx/stattext.h>

// languages supported by dvdstyler
// arrays: langNames, langIds
#include "../locale/langs.h"

wxArrayString GetLangNames()
{
  wxArrayString langsArr;
  for (int i=0; i<(int)WXSIZEOF(langNames); i++)
	langsArr.Add(langNames[i]);
  return langsArr;
}

int GetLangCode(int index)
{
  return langIds[index];
}

wxString GetLangName(int code)
{
  for (int i=0; i<(int)WXSIZEOF(langNames); i++)
	if (code == langIds[i])
	  return langNames[i];
  return GetLangName(wxLANGUAGE_ENGLISH);
}

int ChooseLanguage()
{
  wxSingleChoiceDialog dlg(NULL, _T("Choose Language for DVDStyler to use:"),
    _T("DVDStyler First Run"), WXSIZEOF(langNames), langNames);
  dlg.SetSelection(wxLocale::GetSystemLanguage());
  if (dlg.ShowModal() == wxID_OK)
    return langIds[dlg.GetSelection()];
  return wxLANGUAGE_ENGLISH;
}

const BitmapArray& GetLangBitmaps() {
	return GetLangBitmapArray();
}
