/* VERIFY     Copyright (c) 1995 Peter Mikalajunas
 *
 * VERIFY:  command that tells DOS to verify if files are written
 *          correctly to disk.
 * 
 * Author:  Peter Mikalajunas
 *          kd9fb@xnet.com
 * 
 * Date:    01/30/95
 * 
 * Version: 1.0
 * 
 * NOTE:    This implementation relies on the intdos() function in dos.h.
 *           As such, it is not strictly ANSI C. intdos() is available
 *           in Borland and Microsoft C.
 *
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <dos.h>    /* for intdos() */
#include <stdio.h>  /* for puts */
#include <string.h> /* for strcmp */

/*
 * 0 = Verify off
 * 1 = Verify on
 */
int get_verify_state (void)
{
   union REGS regs;

   regs.h.ah = 0x54;
   intdos (&regs, &regs);
   return regs.h.al;
}

void set_verify_state (int flag)
{
   union REGS regs;

   regs.h.ah = 0x2e;
   regs.h.al = flag;
   regs.h.dl = 0;
   intdos (&regs, &regs);
}

int main (int argc, char *argv[])
{
    int vflag;

   if (argc < 2)		/* no command line arguments */
   {
      if (get_verify_state () == 0)
       {
        puts ("VERIFICATION IS CURRENTLY OFF");
       }
      else if (get_verify_state () == 1)
       {
        puts ("VERIFICATION IS CURRENTLY ON");
       }
   }
   if (argc > 1)		/* handle on/off command line arguments */
   {
    if (strcmp (argv[1], "/on") == 0 || strcmp (argv[1], "/ON") == 0)
       {
        vflag=1;
        set_verify_state (vflag);
        puts ("VERIFICATION IS NOW SET ON");
       }
    if (strcmp (argv[1], "/off") == 0 || strcmp (argv[1], "/OFF") == 0)
       {
        vflag=0;
        set_verify_state (vflag);
        puts ("VERIFICATION IS NOW SET OFF");
       }
    if (strcmp (argv[1], "/?") == 0)
      {
       puts ("USAGE: VERIFY sets file copy verification ON or OFF.");
       puts(" ");
       puts ("       VERIFY used alone returns the current setting.");
       puts ("       VERIFY /on to turn verification on.");
       puts ("       VERIFY /off to turn verification off.");
      }
   }
   return 0;
}
