#!/bin/bash
#
#  userful-xconfig-command.sh
#
############################


############
# usage()
############
function usage()
{
	echo ""
	echo "Usage: userful xconfig [OPTION]"
	echo ""
	echo -e "\tOPTIONS:"
	echo -e "\t\t-h"
	echo -e "\t\t-help\t- Print this help message"
	echo -e "\t\t-gen\t- Generate a X config file for Multi-X"
	echo -e "\t\t-show\t- Show the X config file for Multi-X"
	echo -e "\t\t-remove\t- Remove the X config file for Multi-X"
	echo ""
	exit 1
}

#-------------------
# Start from here
#-------------------

# Import functions
source /opt/userful/bin/userful-bash-lib.sh

#
# Check if user has root access..
IsRoot

[[ -z $1 ]] && usage

case "$1" in
	-h|-help)
		usage
		;;

	-gen)
		exec /opt/userful/bin/userful-config-display
		;;

	-show)
		if which less > /dev/null 2>&1; then
			exec less /etc/X11/userful.Mxorg.conf
		else
			cat /etc/X11/userful.Mxorg.conf
		fi
		;;

	-remove)
		rm -f /etc/X11/userful.Mxorg.conf
		echo -e "\nRemoved the X config file for Multi-X.\n"
		;;

	*)
		echo -e "\nError: Invalid option - $1"
		usage
		;;
esac

