#!/bin/bash
#
# dm-supported-os.sh
#
# 	 Check supported OS and version by DM.
#
#    Copyright (c) 2005-2006 Userful Corporation
#    
#    Jason Kim <jason@userful.com>
#

TRUE=1
FALSE=0

SUPPORTED_OS=$FALSE

if [ ! -f /etc/userful/os-info ]; then
	/opt/userful/bin/dm-check-os.sh
fi
source /etc/userful/os-info
source /etc/userful/userful-supported-distros

case "$OSNAME" in
	fedora)
		SUPPORTED_VER=$FEDORA
		;;

	freedows)
		SUPPORTED_VER=$FREEDOWS
		;;

	novell)
		SUPPORTED_VER=$NOVELL
		;;

	suse)
		SUPPORTED_VER=$SUSE
		;;

	centos)
		SUPPORTED_VER=$CENTOS
		;;

	redhat)
		SUPPORTED_VER=$REDHAT
		;;

	mandrake)
		SUPPORTED_VER=$MANDRAKE
		;;

	xandros)
		SUPPORTED_VER=$XANDROS
		;;

	morphix)
		SUPPORTED_VER=$MORPHIX
		;;

	ubuntu)
		SUPPORTED_VER=$UBUNTU
		;;
	
	freespire)
		SUPPORTED_VER=$FREESPIRE
		;;

	debian)
		SUPPORTED_VER=$DEBIAN
		;;

	*)
		SUPPORTED_OS=$FALSE
		;;
esac

if [ "$SUPPORTED_VER" == "none" -o "$SUPPORTED_VER" == "" ]; then
    SUPPORTED_OS=$FALSE
else
    for V in $SUPPORTED_VER; do
	    if [ "$V" == "$OSVER" ]; then
		    SUPPORTED_OS=$TRUE
		    break
	    fi
    done
fi

if [ $SUPPORTED_OS -eq $TRUE ]; then
	exit 0  # supported
else
	echo "(EE) Not supported linux system"
	exit 1  # not supported
fi
