#!/bin/bash
#
# dm-config-kdm.sh
#
#    Update the kdmrc. Called from dm-config-display-manager.sh
#
#    Copyright (c) 2002-2006 Userful Corporation
#    
#    Jason Kim <jason@userful.com>
#

logfile="/var/log/userful-dm.log"
CONFIG_FILE=$1

if grep "^ReserveServers=" $CONFIG_FILE > /dev/null 2>&1; then
    sed -i -e "s/^ReserveServers=.*/ReserveServers=/g" $CONFIG_FILE
else
    sed -i -e "s/^#ReserveServers=.*/ReserveServers=/g" $CONFIG_FILE
fi

if grep "^ServerVTs=" $CONFIG_FILE > /dev/null 2>&1; then
    sed -i -e "s/^ServerVTs=.*/ServerVTs=/g" $CONFIG_FILE
else
    sed -i -e "s/^#ServerVTs=.*/ServerVTs=/g" $CONFIG_FILE
fi

if grep "^ConsoleTTYs=" $CONFIG_FILE > /dev/null 2>&1; then
    sed -i -e "s/^ConsoleTTYs=.*/ConsoleTTYs=/g" $CONFIG_FILE
else
    sed -i -e "s/^#ConsoleTTYs=.*/ConsoleTTYs=/g" $CONFIG_FILE
fi

sed -i -e "s/^#OpenDelay=.*/OpenDelay=3/g" $CONFIG_FILE
sed -i -e "s/^#OpenTimeout=.*/OpenTimeout=24/g" $CONFIG_FILE
sed -i -e "s/^#OpenRepeat=.*/OpenRepeat=1/g" $CONFIG_FILE
sed -i -e "s/^#StartAttempt=.*/StartAttempt=1/g" $CONFIG_FILE

# Set ServerCmd to /opt/userful/bin/login-server
if grep "ServerCmd=" $CONFIG_FILE > /dev/null 2>&1; then
    sed -i -e "s/^ServerCmd=.*/ServerCmd=\/opt\/userful\/bin\/login-server/g" $CONFIG_FILE
else
    sed -i -e "s/^\[X-:\*-Core\]/\[X-:\*-Core\]\nServerCmd=\/opt\/userful\/bin\/login-server/g" $CONFIG_FILE
fi

# Set TerminateServer
if grep "^TerminateServer=" $CONFIG_FILE > /dev/null 2>&1; then
    sed -i -e "s/^TerminateServer=.*/TerminateServer=true/g" $CONFIG_FILE
elif grep "^#TerminateServer=" $CONFIG_FILE > /dev/null 2>&1; then
    sed -i -e "s/^#TerminateServer=.*/TerminateServer=true/g" $CONFIG_FILE
else
    sed -i -e "s/^\[X-:\*-Core\]/\[X-:\*-Core\]\nTerminateServer=true/g" $CONFIG_FILE
fi

# Disable AutoLogin
sed -i -e "s/^AutoLoginEnable=true/AutoLoginEnable=flase/g" $CONFIG_FILE
