#!/bin/bash

# file: watch-x-config.sh
logfile="/var/log/userful-start.log"

MAX_X_START_TIME=60
MIN_TIME_TO_WAIT=10
START_TIME=`date +%s`

sleep $MIN_TIME_TO_WAIT
echo "(II) start watch-x-config.sh" >>  $logfile

while ! pgrep config-message && [ ! -e /tmp/ret-config-message ]; do
	NOW=`date +%s`
	TIME_TAKEN=$(( $NOW - $START_TIME ))

	if [ $TIME_TAKEN -gt $MAX_X_START_TIME ]; then
		echo "(EE) Can't start config-message program. May normal X fail to start." >>  $logfile
		pkill -9 X 2> /dev/null
		sleep 2
		break
	fi
	sleep 1
done
