#!/bin/bash
#
# Copyright (c) 2005-2006 by Userful Corporation
#
# Name: plug-inputdev.sh
# Author: Jason Kim
# Description:
#    This script is called from "add" section of input.agent. It updates usbinput and
#  sends signal to GUI, daemons and X.
#
###################################################################################

logfile="/var/log/usbinput.log"
PHYS=

if [ ! -e /var/run/x.pid -o ! -d /proc/`cat /var/run/x.pid` ]; then
	# If X is not running, just exit.
	exit 1
fi

if [ -f /etc/sysconfig/xtype ]; then
	. /etc/sysconfig/xtype
	if [ "$XTYPE" = "SINGLE" -o "$XTYPE" = "single" ]; then
		# If normal X is running, just exit.
		exit 1
	fi
fi

# remove " from the $1
PHYS=`echo $1 | tr -d "\""`

date >> $logfile
echo "New Device: $PHYS" >> $logfile

# update /etc/usbinput
/opt/userful/bin/make-config-file -r

# send signal to X to reopen the input devices
pkill -USR2 MXSigDaemon
# send signal to GUI and kbd/mse daemons
pkill -USR2 kbd-daemon
pkill -USR2 mse-daemon

