#!/bin/bash
#
# dm-config-pam.sh
#
#    Configure the pam config file of current Display Manager.
#
#    Copyright (c) 2005-2006 Userful Corporation
#    
#    Jason Kim <jason@userful.com>
#
#
# $1: CURRENTDM

PATH=$PATH:/usr/X11R6/bin/

# Update Display Manager's config files
if [ "$1" == "gdm" ]; then		### GDM ###
	chown gdm /tmp/.X11-unix/X*
	chown gdm /tmp/.X11-unix/.X*

	if [ -e /etc/pam.d/gdm ]; then
		grep pam_console.so /etc/pam.d/gdm | grep allow_nonroot_tty > /dev/null
		if [ $? != 0 ]; then
			sed -i -e "s/pam_console\.so/pam_console\.so allow_nonroot_tty /g" /etc/pam.d/gdm
		fi
			
		cat /etc/pam.d/gdm | grep pam_xconsole > /dev/null
		if [ $? != 0 ]; then
			echo "session    required	pam_xconsole.so default_user=gdm" >> /etc/pam.d/gdm 
    	fi
	fi
else							### KDM, XDM ###
	if [ -e /etc/pam.d/kde ]; then
		cat /etc/pam.d/kde | grep pam_xconsole > /dev/null
		if [ $? != 0 ]; then
			echo "session    required	pam_xconsole.so" >> /etc/pam.d/kde 
    	fi
	fi
	if [ -e /etc/pam.d/kde3 ]; then # for Mandrake
		cat /etc/pam.d/kde3 | grep pam_xconsole > /dev/null
		if [ $? != 0 ]; then
			echo "session    required	pam_xconsole.so" >> /etc/pam.d/kde3 
    	fi
	fi
	if [ -e /etc/pam.d/kdm ]; then
		cat /etc/pam.d/kdm | grep pam_xconsole > /dev/null
		if [ $? != 0 ]; then
			echo "session    required	pam_xconsole.so" >> /etc/pam.d/kdm 
    	fi
	fi
	if [ -e /etc/pam.d/xdm ]; then
		cat /etc/pam.d/xdm | grep pam_xconsole > /dev/null
		if [ $? != 0 ]; then
			echo "session    required	pam_xconsole.so" >> /etc/pam.d/xdm 
    	fi
	fi
fi

# only root can update xhost access control
chmod go-x `which xhost`

# update xhost access control
# only allow LOCAL connection
DISPLAY=:0 xhost > /tmp/xhost.tmp

while read XHOSTENTRY; do
	case "${XHOSTENTRY%:*}" in
		"INET"|"INET6"|"DNET"|"NIS"|"KRB":"SI" )
			# block connections
			DISPLAY=:0 xhost -$XHOSTENTRY
			;;
		* )
			# allow connection from LOCAL
			:
			;;
	esac
	#if echo $XHOSTENTRY | grep "^INET:"
	#echo $XHOSTENTRY
done < /tmp/xhost.tmp

rm -f /tmp/xhost.tmp

# add hostname from /etc/userful/xhost-list to allow connection
if [ -e /etc/userful/xhost-list ]; then
	while read XHOSTLIST; do
		if [ ${#XHOSTLIST} -gt 0 -a "${XHOSTLIST:0:1}" != "#" ]; then
			DISPLAY=:0 xhost +$XHOSTLIST
		fi
	done < /etc/userful/xhost-list
fi

