#!/bin/bash
#
# dm-config-mga-driver.sh
#
#    Configure mag_drv.o based on current X type.
#
#    Copyright (c) 2005-2006 Userful Corporation
#    
#    Jason Kim <jason@userful.com>
#

# Configure the mga driver based on current X type
if [ "$1" = "single" ]; then
	if [ -d /usr/X11R6/lib64/modules/drivers -a \
	   ! -e /usr/X11R6/lib64/modules/drivers/mga_drv.o ]; then
		mv -f /usr/X11R6/lib64/modules/drivers/mga_drv.o.multi-save \
			  /usr/X11R6/lib64/modules/drivers/mga_drv.o 2> /dev/null
	fi

	if [ -d /usr/X11R6/lib/modules/drivers -a \
       ! -e /usr/X11R6/lib/modules/drivers/mga_drv.o ]; then
		mv -f /usr/X11R6/lib/modules/drivers/mga_drv.o.multi-save \
			  /usr/X11R6/lib/modules/drivers/mga_drv.o 2> /dev/null
	fi

elif [ "$1" = "multi" ]; then
	# rename mga_drv.o in /usr/X11R6/lib64/modules/drivers/ to mga_drv.o.multi-save
	# use mga_drv.o in /opt/MX11R6/lib64 directory
	if [ -d /usr/X11R6/lib64/modules/drivers -a \
	   ! -e /usr/X11R6/lib64/modules/drivers/mga_drv.o.multi-save ]; then
		mv -f /usr/X11R6/lib64/modules/drivers/mga_drv.o \
			  /usr/X11R6/lib64/modules/drivers/mga_drv.o.multi-save 2> /dev/null
	# For MGA proprietary driver,  use new drvier in /usr/X11R6/lib64 directory
	elif [ -d /usr/X11R6/lib64/modules/drivers -a \
		   -e /usr/X11R6/lib64/modules/drivers/mga_drv.o -a \
		   -e /usr/X11R6/lib64/modules/drivers/mga_drv.o.multi-save ]; then 
			 mv -f /opt/MX11R6/lib64/modules/drivers/mga_drv.o \
			 	   /opt/MX11R6/lib64/modules/drivers/mga_drv.o.multi-save 2> /dev/null
	fi

	# rename mga_drv.o in /usr/X11R6/lib64/modules/drivers/ to mga_drv.o.multi-save
	# use driver in /opt/MX11R6/lib directory
	if [ -d /usr/X11R6/lib/modules/drivers -a \
	   ! -e /usr/X11R6/lib/modules/drivers/mga_drv.o.multi-save ]; then
			mv -f /usr/X11R6/lib/modules/drivers/mga_drv.o \
				  /usr/X11R6/lib/modules/drivers/mga_drv.o.multi-save 2> /dev/null
	# For MGA proprietary driver,  use new drvier in /usr/X11R6/lib directory
	elif [ -d /usr/X11R6/lib/modules/drivers -a \
		   -e /usr/X11R6/lib/modules/drivers/mga_drv.o -a \
		   -e /usr/X11R6/lib/modules/drivers/mga_drv.o.multi-save ]; then 
			 mv -f /opt/MX11R6/lib/modules/drivers/mga_drv.o \
			 	   /opt/MX11R6/lib/modules/drivers/mga_drv.o.multi-save 2> /dev/null
	fi
fi
