#!/bin/bash
#
# dm-gdm-config.sh
#
#    Update the config file of GDM. Called from dm-config-display-manager.sh
#
#    Copyright (c) 2005-2006 Userful Corporation
#    
#    Jason Kim <jason@userful.com>
#

logfile="/var/log/userful-dm.log"
CONFIG_FILE=$1

# set OSNAME and OSVER
source /etc/userful/os-info

# set MAXSTATIONS
if [ -e /etc/userful/dm-max-stations ]; then
	source /etc/userful/dm-max-stations
else
	date >> $logfile
	echo "No /etc/userful/dm-max-stations exist" >> $logfile
	exit 1
fi

sed -i -e "s/^FirstVT=7/#FirstVT=7/g" $CONFIG_FILE

if grep "VTAllocation=true" $CONFIG_FILE > /dev/null 2>&1; then
	sed -i -e "s/^VTAllocation=true/VTAllocation=false/g" $CONFIG_FILE
	sed -i -e "s/^#VTAllocation=true/VTAllocation=false/g" $CONFIG_FILE
elif ! grep "VTAllocation=false" $CONFIG_FILE > /dev/null 2>&1; then
	sed -i -e "s/^\[daemon\]/\[daemon\]\nVTAllocation=false/g" $CONFIG_FILE
fi

if grep "SystemMenu=true" $CONFIG_FILE > /dev/null 2>&1; then
	sed -i -e "s/^SystemMenu=true/SystemMenu=false/g" $CONFIG_FILE
	sed -i -e "s/^#SystemMenu=true/SystemMenu=false/g" $CONFIG_FILE
elif ! grep "SystemMenu=false" $CONFIG_FILE > /dev/null 2>&1; then
	sed -i -e "s/^\[greeter\]/\[greeter\]\nSystemMenu=false/g" $CONFIG_FILE
fi

sed -i -e "s/^0=Standard/#0=Standard/g" $CONFIG_FILE
sed -i -e "s/^1=Standard/#1=Standard/g" $CONFIG_FILE

# remove login servers
for ((i = 0; i < $MAXSTATIONS; i++))
do
	sed -i -e "/$i=Login/d" $CONFIG_FILE
done

# add login servers
: > $CONFIG_FILE.tmp  # create empty tmp file
while read GDM_CONF; do
	echo "$GDM_CONF" >> $CONFIG_FILE.tmp

	# add Login server entries after [servers] section
	if [ "$GDM_CONF" == "[servers]" ] ; then
		for (( i=0; i<$MAXSTATIONS; i++)); do
			echo "#$i=Login" >> $CONFIG_FILE.tmp
		done
	fi
done < $CONFIG_FILE

if grep "\[server-Login\]" $CONFIG_FILE.tmp > /dev/null 2>&1; then
	:
else
	echo "" >> $CONFIG_FILE.tmp
	echo "#Definition of the login-server" >> $CONFIG_FILE.tmp
	echo "[server-Login]" >> $CONFIG_FILE.tmp
	echo "name=Login server" >> $CONFIG_FILE.tmp
	echo "command=/opt/userful/bin/login-server" >> $CONFIG_FILE.tmp
	echo "flexible=true" >> $CONFIG_FILE.tmp
fi

rm -f $CONFIG_FILE
mv -f $CONFIG_FILE.tmp $CONFIG_FILE

