/*
Copyright (c) 1993-2008, Cognitive Technologies
All rights reserved.

         ,
    ,    ,    :

      *        
            ,     
          .
      *        / 
         ,   ,  
             ,    
           .
      *   Cognitive Technologies,      
              / 
        ,    ,   
        .

      /   "
 "  -  ,    ,
        ,  
 .         , 
  /   ,     
Ѩ ,   , ,  
 ,      
   (  ,  ,
 ,   /  ,  - 
  /       ,
    ),    ,   
           .

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    * Redistributions of source code must retain the above copyright notice,
      this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright notice,
      this list of conditions and the following disclaimer in the documentation
      and/or other materials provided with the distribution.
    * Neither the name of the Cognitive Technologies nor the names of its
      contributors may be used to endorse or promote products derived from this
      software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/*  myassert.h

    My Assert Macro (07-08-93 03:54pm,Basil)
	 BC++, v3.1 was used as base
*/

#ifdef __MYASSERT_H
#	Error: Do not specify MYASSERT.H directly - use SLANG.H. Postnikov.
#else
#	define __MYASSERT_H
#endif

#define MY_DEBUG_LEVEL    2

#ifdef NDEBUG
#	define WRONG() (FALSE)
#else
#  define WRONG() (assert(0),FALSE)
#endif

#ifdef __cplusplus
extern "C" {
#endif

#ifndef MY_DEBUG_LEVEL
   void   __assertfail( char  *__msg,
                                      char  *__cond,
                                      char  *__file,
         	                          int __line);
#else
   void   my_assert_fail(const char *cond, const char *__file, int __line);
#endif


#ifdef  __cplusplus
}
#endif

#undef assert

#ifdef NDEBUG
#  define assert(p)   ((void)0)
#else
#  ifdef _Windows
#    define _ENDL
#  else
#    define _ENDL "\n"
#  endif
	#ifdef MY_DEBUG_LEVEL
	#	define assert(p) 															\
				((p)) ?                                               \
					(void)0 :                                          \
					(void) my_assert_fail( #p, __FILE__, __LINE__)
	#else
	#  define assert(p) 															\
				((p) ?                                                \
					(void)0 :                                          \
					(void) __assertfail( "Assertion failed: %s, file %s, line %d" _ENDL, \
   	                 #p, __FILE__, __LINE__ ) )
	#endif
#endif
