/*
Copyright (c) 1993-2008, Cognitive Technologies
All rights reserved.

         ,
    ,    ,    :

      *        
            ,     
          .
      *        / 
         ,   ,  
             ,    
           .
      *   Cognitive Technologies,      
              / 
        ,    ,   
        .

      /   "
 "  -  ,    ,
        ,  
 .         , 
  /   ,     
Ѩ ,   , ,  
 ,      
   (  ,  ,
 ,   /  ,  - 
  /       ,
    ),    ,   
           .

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    * Redistributions of source code must retain the above copyright notice,
      this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright notice,
      this list of conditions and the following disclaimer in the documentation
      and/or other materials provided with the distribution.
    * Neither the name of the Cognitive Technologies nor the names of its
      contributors may be used to endorse or promote products derived from this
      software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

   #ifndef __LNSLANG_H
   #  include "lnslang.h"
	#endif
//	_TYPEDEFFAR( TFltBuf );

	/* 10-05-93 07:11pm, Basil.
	 * TFltBuf is class that supports buffer of vertical segments
	 * extraction/filtration. Main function - disjunctLast16()
	 * returns bitwise disjuncted last 16 lines of b/w tiff image
	 * Used algorithm of buffer updation by A.Ivanov and V.Postnikov
	 */



class TFltBuf
	{
		private:
         Int32  nCurLine;
         Int32  widthDWord;
         Int32 * x16;
         Int32 * x8;
         Int32 * x4;
         Int32 * x2;
      public:
         Int32 * cur16;        // disjunct of last 16 lines
         Int32 * last16;       // disjunct of last 16 lines

public:
TFltBuf		( int width_dword );
Bool        isOk( void ) { return (x16!=NULL); };
void        addLine( void* new_line ); // simply fills buffer (by first 16 lines)
void 			preBuffer( void );  // makes initial disjunct tree (after 16xaddLine())
void        updateByLine( void* new_line ); // updates tree by next image line
void 			destroy( void );
~TFltBuf		( void ) { destroy(); };
	}; // TFltBuf
