/*
Copyright (c) 1993-2008, Cognitive Technologies
All rights reserved.

         ,
    ,    ,    :

      *        
            ,     
          .
      *        / 
         ,   ,  
             ,    
           .
      *   Cognitive Technologies,      
              / 
        ,    ,   
        .

      /   "
 "  -  ,    ,
        ,  
 .         , 
  /   ,     
Ѩ ,   , ,  
 ,      
   (  ,  ,
 ,   /  ,  - 
  /       ,
    ),    ,   
           .

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    * Redistributions of source code must retain the above copyright notice,
      this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright notice,
      this list of conditions and the following disclaimer in the documentation
      and/or other materials provided with the distribution.
    * Neither the name of the Cognitive Technologies nor the names of its
      contributors may be used to endorse or promote products derived from this
      software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

#ifndef __XTIMER_H
#define __XTIMER_H

#include <time.h>
#include <compat_defs.h>

class XTimer
{
   clock_t start, finish;
   double  duration;
   char proc[64];
   Bool stopped;
private:
   double compute_duration()
   {
      return double(finish-start) / CLOCKS_PER_SEC;
   };

public:
   XTimer(const char* proc_id=NULL)
   {
      if (proc_id)
         strncpy(proc,proc_id, sizeof(proc));
      else

#ifdef E_LANG
         strncpy(proc,"lapsed time", sizeof(proc));
#else
         strncpy(proc," ", sizeof(proc));
#endif

      start = clock();
      stopped = FALSE;
   };

   double Update()
   {
      finish = clock();
      duration = compute_duration();
      return duration;
   };

   void   Stop(int nItems = -1)
   {
      if (!stopped)
      {
         Update();
         char message[512];
         if (nItems > 0)
         {
            sprintf( message,
#ifdef E_LANG
               "%s: %2.2f sec. (%2.2f per item)",
#else
               "%s: %2.2f . (  %2.2f)",
#endif
            proc, duration, duration/nItems
                   );
         }
         else
         {
            sprintf( message,
#ifdef E_LANG
               "%s: %2.2f sec.",
#else
               "%s: %2.2f .",
#endif
            proc, duration
                   );
         }

         CONSOLE(message);

         stopped = TRUE;
      }
   }

   ~XTimer() { /*Stop();*/ };
};

#endif
