/****************************************************************************
**
** Copyright (C) 2003-2006 Frank Hemer <frank@hemer.org>,
**                         Tilo Riemer <riemer@crossvc.com>
**
**
**----------------------------------------------------------------------------
**
**----------------------------------------------------------------------------
**
** CrossVC is available under two different licenses:
**
** If CrossVC is linked against the GPLed version of Qt 
** CrossVC is released under the terms of GPL also.
**
** If CrossVC is linked against a nonGPLed version of Qt 
** CrossVC is released under the terms of the 
** CrossVC License for non-Unix platforms (CLNU)
**
**
** CrossVC License for non-Unix platforms (CLNU):
**
** Redistribution and use in binary form, without modification, 
** are permitted provided that the following conditions are met:
**
** 1. Redistributions in binary form must reproduce the above copyright
**    notice, this list of conditions and the following disclaimer in the
**    documentation and/or other materials provided with the distribution.
** 2. It is not permitted to distribute the binary package under a name
**    different than CrossVC.
** 3. The name of the authors may not be used to endorse or promote
**    products derived from this software without specific prior written
**    permission.
** 4. The source code is the creative property of the authors.
**    Extensions and development under the terms of the Gnu Public License
**    are limited to the Unix platform. Any distribution or compilation of 
**    the source code against libraries licensed other than gpl requires 
**    the written permission of the authors.
**
**
** THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR 
** IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
** WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
** ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY 
** DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
** DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE 
** GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
** INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
** WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
** NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS 
** SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
**
**
**
** CrossVC License for Unix platforms:
**
** This program is free software; you can redistribute it and/or modify 
** it under the terms of the GNU General Public License as published by 
** the Free Software Foundation, version 2 of the License.
** This program is distributed in 
** the hope that it will be useful, but WITHOUT ANY WARRANTY; without 
** even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
** PARTICULAR PURPOSE.
**
** See the GNU General Public License version 2 for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software Foundation,
** Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**
*****************************************************************************/

#include "config.h"

#include "CCvsOutput.h"
#include "globals.h"
#include "SyntaxHighlighter.h"

#include <assert.h>

#define lf "\n"
#define LFOFFSET 1

CCvsOutput::CCvsOutput(Menu ** menu, QWidget * parent, const char * name)
: QTextEdit(parent,name),
m_ppMenu(menu),
m_currentMode(OFF)
{
   setTextFormat(Qt::LogText);
   QTextEdit::setUndoDepth(0);
   m_pSyntaxHighlighter = new CSyntaxHighlighter();
}

CCvsOutput::~CCvsOutput() {
}

void CCvsOutput::reset()
{
   QTextEdit::setText("");
   QTextEdit::setCursorPosition(0, 0);
   m_oriText = "";
   m_toggleText = "";
   m_oriState = 0;
   m_toggleState = 0;
   m_remaining = "";
   m_toggled = false;
}

void CCvsOutput::insert( const QString & text, uint /*insertionFlags*/)
{
   QString txt = text;
   QString insTxt = text;
   
   if (!m_toggleText.endsWith(lf)) {
      int off = m_toggleText.findRev(lf);
      if (off > -1) {
         txt = m_toggleText.mid(off+LFOFFSET) + txt;
         m_toggleState = m_pSyntaxHighlighter->highlightLine(txt,m_toggleState);
         m_toggleText.truncate(off+LFOFFSET);
      }
   } else m_toggleState = m_pSyntaxHighlighter->highlightLine(txt,m_toggleState);
   m_toggleText += txt;
   
   if (!m_remaining.isEmpty()) {
      insTxt = m_remaining + insTxt;
      m_remaining = "";
   }
   
   int pos = insTxt.findRev(lf)+LFOFFSET;
   if (pos == LFOFFSET-1) {
      m_remaining = insTxt;
      return;
   } else if (pos < (int)insTxt.length()) {
      m_remaining = insTxt.mid(pos);
      insTxt.truncate(pos);
   }
   
   switch (m_currentMode) {
      case OFF: {
         break;
      }
      case QUIET: {
         QStringList tokens;
         tokens << "cvs " << "? " << "-f server: " << "cvsnt ";
         for ( QStringList::Iterator it = tokens.begin(); it != tokens.end(); ++it ) {
            
            pos = 0;
            int startPos = 0;
            int endPos = 0;
            while ((startPos = insTxt.find(lf+*it,pos)) > -1) {
               startPos += LFOFFSET;
               // hide it if not a cvs[nt] error message
               if ( !(  
                        ( ((insTxt.find("cvs [", startPos) > -1) || (insTxt.find("cvsnt [", startPos) > -1))
                          && (insTxt.find("aborted]:", startPos) > -1) )
                        || 
                        ( ((insTxt.find("cvs server:", startPos) > -1) || (insTxt.find("cvsnt server:", startPos) > -1))
                          && (insTxt.find("no longer in the repository", startPos) > -1) )
                  ) )
               {
                  if ( (endPos = insTxt.find("\n",startPos)) > -1) {
                     insTxt.remove(startPos,endPos-startPos+1);
                     pos = startPos-LFOFFSET;
                  } else {//no \n
                     assert(false);
                     break;
                  }
               } else if ( (endPos = insTxt.find("\n",startPos)) > -1) {
                  pos = endPos + 1 - LFOFFSET;
               } else {//no \n
                  assert(false);
                  break;
               }
            }
            
            if (insTxt.startsWith(*it)) {
               // hide it if not a cvs[nt] error message
               if ( !(  
                        ( ((insTxt.find("cvs [", startPos) > -1) || (insTxt.find("cvsnt [", startPos) > -1))
                          && (insTxt.find("aborted]:", startPos) > -1) )
                        || 
                        ( ((insTxt.find("cvs server:", startPos) > -1) || (insTxt.find("cvsnt server:", startPos) > -1))
                          && (insTxt.find("no longer in the repository", startPos) > -1) )
                  ) )
               {
                  if ( (endPos = insTxt.find(lf)) > -1) {
                     insTxt.remove(0,endPos+LFOFFSET);
                  } else {//no \n
                     assert(false);
                     break;
                  }
               }
            }
            
         }
         break;
      }
      default: {
         qDebug("CCvsOutput::Mode unknown: "+QString::number(m_currentMode));
      }
   }
   
   if (insTxt.length()) {
      m_oriState = m_pSyntaxHighlighter->highlightLine(insTxt,m_oriState);
      m_oriText += insTxt;
      insTxt.truncate(insTxt.length()-LFOFFSET);
      if (insTxt.length()) QTextEdit::append(insTxt);
      else QTextEdit::append(lf);
      verticalScrollBar()->setValue(verticalScrollBar()->maxValue());
   }
}

void CCvsOutput::setMode( const int icmd)
{
   if (CvsOptions::g_bQuietCvs) {
      m_currentMode = QUIET;
      if (m_toggled) toggleShowAll();
   } else {
      m_currentMode = OFF;
   }
   setHighlightMode(icmd);
}

void CCvsOutput::setHighlightMode(const int icmd)
{
   SyntaxHighlighter::HighlightMode highlightMode;
   switch(icmd) {
      case CVS_STATUS_CMD: 
      case CVS_STATUS_FILES_CMD:
      highlightMode = SyntaxHighlighter::HM_STATUS;
      break;
      case CVS_UPDATE_DIR_CMD:
      case CVS_UPDATE_FILES_CMD:
      case CVS_CHECKOUT_CMD:
      case CVS_QUERY_UPDATE_CMD:
      case CVS_QUERY_UPDATE_ALL_CMD:
      case CVS_MERGE_REV_INTO_CMD:
      case CVS_MERGE_DIR_CMD:
      case CVS_MERGE_FILES_CMD:
      case CVS_AUTOUPDATE_DIR_CMD:
      case CVS_AUTOUPDATE_DIR_NO_PRUNE_CMD:
      case CVS_CHECKOUT_NO_PRUNE_CMD:
      case CVS_MERGE_DIR_NO_PRUNE_CMD:
      case CVS_UPDATE_VIRTUAL_DIR_CMD:
      case CVS_IMPORT_CMD:
      highlightMode = SyntaxHighlighter::HM_UPDATE;
      break;
      case CVS_DIFF_CMD:
      highlightMode = SyntaxHighlighter::HM_DIFF;
      break;
      case CVS_DIFF_SBS_CMD:
      highlightMode = SyntaxHighlighter::HM_DIFFSBS;
      break;
      case CVS_LOGINANDOUT_CMD:
      highlightMode = SyntaxHighlighter::HM_LOGIN;
      break;
      default:
      highlightMode = SyntaxHighlighter::HM_NONE;
      break;
   }
   m_pSyntaxHighlighter->setMode(highlightMode);
}

QPopupMenu * CCvsOutput::createPopupMenu ( const QPoint &)
{
   emit fillOutputMenu(m_currentMode);
   return static_cast<QPopupMenu*>(*m_ppMenu);
}

void CCvsOutput::toggleShowAll()
{
   if (m_toggled ^= true) QTextEdit::setText(m_toggleText);
   else QTextEdit::setText(m_oriText);
}

