/*******************************************************************************
 * Copyright (c) 2000, 2003 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.jdt.core.compiler;
 
/**
 * Maps each terminal symbol in the java-grammar into a unique integer. 
 * This integer is used to represent the terminal when computing a parsing action. 
 * 
 * Disclaimer : These constant values are generated automatically using a Java 
 * grammar, therefore their actual values are subject to change if new keywords 
 * were added to the language (for instance, 'assert' is a keyword in 1.4).
 * 
 * @see IScanner
 * @since 2.0
 */
public interface ITerminalSymbols {

	// special tokens not part of grammar - not autogenerated
	int 
		TokenNameWHITESPACE = 1000,
		TokenNameCOMMENT_LINE = 1001,
		TokenNameCOMMENT_BLOCK = 1002,
		TokenNameCOMMENT_JAVADOC = 1003;
	
    int
      TokenNameIdentifier = 5,
      TokenNameabstract = 98,
      TokenNameassert = 118,
      TokenNameboolean = 18,
      TokenNamebreak = 119,
      TokenNamebyte = 19,
      TokenNamecase = 211,
      TokenNamecatch = 225,
      TokenNamechar = 20,
      TokenNameclass = 165,
      TokenNamecontinue = 120,
      TokenNamedefault = 212,
      TokenNamedo = 121,
      TokenNamedouble = 21,
      TokenNameelse = 213,
      TokenNameextends = 243,
      TokenNamefalse = 37,
      TokenNamefinal = 99,
      TokenNamefinally = 226,
      TokenNamefloat = 22,
      TokenNamefor = 122,
      TokenNameif = 123,
      TokenNameimplements = 268,
      TokenNameimport = 191,
      TokenNameinstanceof = 65,
      TokenNameint = 23,
      TokenNameinterface = 180,
      TokenNamelong = 24,
      TokenNamenative = 100,
      TokenNamenew = 32,
      TokenNamenull = 38,
      TokenNamepackage = 214,
      TokenNameprivate = 101,
      TokenNameprotected = 102,
      TokenNamepublic = 103,
      TokenNamereturn = 124,
      TokenNameshort = 25,
      TokenNamestatic = 94,
      TokenNamestrictfp = 104,
      TokenNamesuper = 33,
      TokenNameswitch = 125,
      TokenNamesynchronized = 85,
      TokenNamethis = 34,
      TokenNamethrow = 126,
      TokenNamethrows = 227,
      TokenNametransient = 105,
      TokenNametrue = 39,
      TokenNametry = 127,
      TokenNamevoid = 26,
      TokenNamevolatile = 106,
      TokenNamewhile = 117,
      TokenNameIntegerLiteral = 40,
      TokenNameLongLiteral = 41,
      TokenNameFloatingPointLiteral = 42,
      TokenNameDoubleLiteral = 43,
      TokenNameCharacterLiteral = 44,
      TokenNameStringLiteral = 45,
      TokenNamePLUS_PLUS = 1,
      TokenNameMINUS_MINUS = 2,
      TokenNameEQUAL_EQUAL = 35,
      TokenNameLESS_EQUAL = 66,
      TokenNameGREATER_EQUAL = 67,
      TokenNameNOT_EQUAL = 36,
      TokenNameLEFT_SHIFT = 14,
      TokenNameRIGHT_SHIFT = 11,
      TokenNameUNSIGNED_RIGHT_SHIFT = 12,
      TokenNamePLUS_EQUAL = 168,
      TokenNameMINUS_EQUAL = 169,
      TokenNameMULTIPLY_EQUAL = 170,
      TokenNameDIVIDE_EQUAL = 171,
      TokenNameAND_EQUAL = 172,
      TokenNameOR_EQUAL = 173,
      TokenNameXOR_EQUAL = 174,
      TokenNameREMAINDER_EQUAL = 175,
      TokenNameLEFT_SHIFT_EQUAL = 176,
      TokenNameRIGHT_SHIFT_EQUAL = 177,
      TokenNameUNSIGNED_RIGHT_SHIFT_EQUAL = 178,
      TokenNameOR_OR = 80,
      TokenNameAND_AND = 79,
      TokenNamePLUS = 3,
      TokenNameMINUS = 4,
      TokenNameNOT = 71,
      TokenNameREMAINDER = 9,
      TokenNameXOR = 63,
      TokenNameAND = 62,
      TokenNameMULTIPLY = 8,
      TokenNameOR = 70,
      TokenNameTWIDDLE = 72,
      TokenNameDIVIDE = 10,
      TokenNameGREATER = 68,
      TokenNameLESS = 69,
      TokenNameLPAREN = 7,
      TokenNameRPAREN = 86,
      TokenNameLBRACE = 110,
      TokenNameRBRACE = 95,
      TokenNameLBRACKET = 15,
      TokenNameRBRACKET = 166,
      TokenNameSEMICOLON = 64,
      TokenNameQUESTION = 81,
      TokenNameCOLON = 154,
      TokenNameCOMMA = 90,
      TokenNameDOT = 6,
      TokenNameEQUAL = 167,
      TokenNameEOF = 158,
      TokenNameERROR = 309;
}
