#
# Functional Tests
#

import os, sys
if __name__ == '__main__':
    execfile(os.path.join(sys.path[0], 'framework.py'))

from Testing import ZopeTestCase

from Products.LinguaPlone.tests.LinguaPloneTestCase import \
     LinguaPloneFunctionalTestCase

from Products.LinguaPlone.config import IS_PLONE_2_0

FILES = [
    'create_translation.txt',
    'update_cookie.txt',
    'translate_edit.txt',
]

if not IS_PLONE_2_0:
    FILES.append('dynamic_view.txt')
    FILES.append('language_policies.txt')

def test_suite():
    from unittest import TestSuite, makeSuite
    from Testing.ZopeTestCase import FunctionalDocFileSuite
    suite = TestSuite()
    for doc_file in FILES:
        suite.addTest(FunctionalDocFileSuite(doc_file,
                      package='Products.LinguaPlone.tests',
                      test_class=LinguaPloneFunctionalTestCase))
    return suite

if __name__ == '__main__':
    framework(descriptions=1, verbosity=1)
