/*
 * Copyright (c) 2003 Benedikt Meurer (benedikt.meurer@unix-ag.uni-siegen.de)
 *               2004 Jean-François Wauthy (pollux@xfce.org)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif /* !HAVE_CONFIG_H */

#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif
#ifdef HAVE_STRING_H
#include <string.h>
#endif

#include <glib.h>

#include "option.h"


const gchar *
xfprint_option(const XfprintOption *options, const gchar *name)
{
	g_return_val_if_fail(name != NULL, NULL);
	g_return_val_if_fail(options != NULL, NULL);

	for (; options->name; options++)
		if (!strcmp(options->name, name))
			return(options->name);

	return(NULL);
}

const gchar *
xfprint_option_alias(const XfprintOption *options, const gchar *name)
{
	g_return_val_if_fail(name != NULL, NULL);
	g_return_val_if_fail(options != NULL, NULL);

	for (; options->alias; options++)
		if (!strcmp(options->name, name))
			return(options->alias);

	return(NULL);
}

GList *
xfprint_option_list(const XfprintOption *options)
{
	GList *list;

	g_return_val_if_fail(options != NULL, NULL);

	for (list = NULL; options->alias; options++)
		list = g_list_append(list, (gpointer)options->alias);

	return(list);
}

const gchar *
xfprint_option_name(const XfprintOption *options, const gchar *alias)
{
	g_return_val_if_fail(alias != NULL, NULL);
	g_return_val_if_fail(options != NULL, NULL);

	for (; options->name; options++)
		if (!strcmp(options->alias, alias))
			return(options->name);

	return(NULL);
}

