/*-
 * Copyright (c) 2006 Jani Monoses <jani@ubuntu.com> 
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *                                                                              
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *                                                                              
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif

#define DBUS_API_SUBJECT_TO_CHANGE
#include <dbus/dbus.h>

#define	HAL_DBUS_SERVICE		"org.freedesktop.Hal"
#define HAL_ROOT_COMPUTER		"/org/freedesktop/Hal/devices/computer"
#define	HAL_DBUS_INTERFACE_DEVICE	"org.freedesktop.Hal.Device"
#define	HAL_DBUS_INTERFACE_POWER	"org.freedesktop.Hal.Device.SystemPowerManagement"
#define	HAL_PM_CAN_SUSPEND		"power_management.can_suspend_to_ram"
#define	HAL_PM_CAN_HIBERNATE		"power_management.can_suspend_to_disk"

#include <xfce4-session/xfsm-shutdown-helper.h>

struct _XfsmShutdownHelper
{
  gint dummy;
};

XfsmShutdownHelper*
xfsm_shutdown_helper_spawn (void)
{
  XfsmShutdownHelper *helper = NULL;

  helper = g_new0 (XfsmShutdownHelper, 1);

  return helper;
}


gboolean
xfsm_shutdown_helper_need_password (const XfsmShutdownHelper *helper)
{
  return FALSE;
}


gboolean
xfsm_shutdown_helper_send_password (XfsmShutdownHelper *helper,
                                    const gchar        *password)
{
  return TRUE;
}


static struct
{ 
  XfsmShutdownCommand command;
  gchar * name;
} xfsm2hal[] =
{
	       { XFSM_REBOOT,    "Reboot"},
	       { XFSM_SHUTDOWN,  "Shutdown"},
	       { XFSM_SUSPEND,   "Suspend"},
	       { XFSM_HIBERNATE, "Hibernate"}
};

/* Return TRUE on success, FALSE otherwise */

static gboolean 
hal_dbus_power_command(XfsmShutdownCommand command)
{
    DBusConnection *connection;
    DBusMessage *method;
    DBusMessage *result;
    DBusError derror;
    gint i;
    gchar *methodname;
    dbus_int32_t wakeup = 0;
    
    for (i = 0; i < G_N_ELEMENTS (xfsm2hal); i++) {
      if ( xfsm2hal[i].command == command ) {
        methodname = xfsm2hal[i].name;
      }
    }
   
    dbus_error_init(&derror);
    
    connection = dbus_bus_get(DBUS_BUS_SYSTEM, &derror);

    if (connection == NULL)
        return FALSE;
    
    method = dbus_message_new_method_call(HAL_DBUS_SERVICE,
		                          HAL_ROOT_COMPUTER,
					  HAL_DBUS_INTERFACE_POWER,
					  methodname);

    if (command == XFSM_SUSPEND) {
	dbus_message_append_args (method, DBUS_TYPE_INT32, &wakeup, DBUS_TYPE_INVALID);
    }
    
    result = dbus_connection_send_with_reply_and_block(connection, method, 2000, &derror);
    
    dbus_message_unref(method);
    
    if (result == NULL)
	return FALSE;
    
    dbus_message_unref(result);
    return TRUE;
}

gboolean
xfsm_shutdown_helper_send_command (XfsmShutdownHelper  *helper,
                                   XfsmShutdownCommand  command)
{
  return hal_dbus_power_command (command); 
}


void
xfsm_shutdown_helper_destroy (XfsmShutdownHelper *helper)
{
  g_free (helper);
}


