#ifndef LIBXLU_CFG_I_H
#define LIBXLU_CFG_I_H

#include "libxlu_internal.h"
#include "libxlu_cfg_y.h"

void xlu__cfg_set_free(XLU_ConfigSetting *set);
XLU_ConfigSetting *xlu__cfg_set_mk(CfgParseContext*, int alloc, char *atom);
void xlu__cfg_set_add(CfgParseContext*, XLU_ConfigSetting *set, char *atom);
void xlu__cfg_set_store(CfgParseContext*, char *name,
                        XLU_ConfigSetting *set, int lineno);

char *xlu__cfgl_strdup(CfgParseContext*, const char *src);
char *xlu__cfgl_dequote(CfgParseContext*, const char *src);

void xlu__cfg_yyerror(YYLTYPE *locp, CfgParseContext*, char const *msg);
void xlu__cfgl_lexicalerror(CfgParseContext*, char const *msg);

void xlu__cfgl_likely_python(CfgParseContext *ctx);



/* Why oh why does bison not declare this in its autogenerated .h ? */
int xlu__cfg_yyparse(CfgParseContext *ctx);


#endif /*LIBXLU_CFG_I_H*/
