/** @file api_common.cc
 * @brief test common features of API classes
 */
/* Warning: This file is generated by /data/home/olly/tmp/xapian-svn-snapshot/tags/1.0.5/xapian/xapian-core/tests/generate-api_generated - do not modify directly! */
/* Copyright (C) 2007 Olly Betts
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */

#include <config.h>

#include "api_generated.h"

#include <xapian.h>

#include "apitest.h"
#include "testutils.h"

using namespace std;

/// Check uncopyable API classes which should have a default ctor actually do.
DEFINE_TESTCASE(defaultctor1, !backend) {
    Xapian::BM25Weight bm25weight;
    Xapian::BoolWeight boolweight;
    Xapian::TradWeight tradweight;
    return true;
}

/// Test that API classes have a copy ctor and assignment operator.
DEFINE_TESTCASE(copyassign1, !backend) {
    Xapian::Database database;
    Xapian::Database copy_database(database);
    database = copy_database;

    Xapian::DateValueRangeProcessor datevaluerangeprocessor(0);
    Xapian::DateValueRangeProcessor copy_datevaluerangeprocessor(datevaluerangeprocessor);
    datevaluerangeprocessor = copy_datevaluerangeprocessor;

    Xapian::Document document;
    Xapian::Document copy_document(document);
    document = copy_document;

    Xapian::ESet eset;
    Xapian::ESet copy_eset(eset);
    eset = copy_eset;

    Xapian::ESetIterator esetiterator;
    Xapian::ESetIterator copy_esetiterator(esetiterator);
    esetiterator = copy_esetiterator;

    Xapian::Enquire enquire(Xapian::InMemory::open());
    Xapian::Enquire copy_enquire(enquire);
    enquire = copy_enquire;

    Xapian::MSet mset;
    Xapian::MSet copy_mset(mset);
    mset = copy_mset;

    Xapian::MSetIterator msetiterator;
    Xapian::MSetIterator copy_msetiterator(msetiterator);
    msetiterator = copy_msetiterator;

    Xapian::MultiValueSorter multivaluesorter;
    Xapian::MultiValueSorter copy_multivaluesorter(multivaluesorter);
    multivaluesorter = copy_multivaluesorter;

    Xapian::NumberValueRangeProcessor numbervaluerangeprocessor(0, "");
    Xapian::NumberValueRangeProcessor copy_numbervaluerangeprocessor(numbervaluerangeprocessor);
    numbervaluerangeprocessor = copy_numbervaluerangeprocessor;

    Xapian::PositionIterator positioniterator;
    Xapian::PositionIterator copy_positioniterator(positioniterator);
    positioniterator = copy_positioniterator;

    Xapian::PostingIterator postingiterator;
    Xapian::PostingIterator copy_postingiterator(postingiterator);
    postingiterator = copy_postingiterator;

    Xapian::Query query;
    Xapian::Query copy_query(query);
    query = copy_query;

    Xapian::QueryParser queryparser;
    Xapian::QueryParser copy_queryparser(queryparser);
    queryparser = copy_queryparser;

    Xapian::RSet rset;
    Xapian::RSet copy_rset(rset);
    rset = copy_rset;

    Xapian::SimpleStopper simplestopper;
    Xapian::SimpleStopper copy_simplestopper(simplestopper);
    simplestopper = copy_simplestopper;

    Xapian::Stem stem;
    Xapian::Stem copy_stem(stem);
    stem = copy_stem;

    Xapian::StringValueRangeProcessor stringvaluerangeprocessor(0);
    Xapian::StringValueRangeProcessor copy_stringvaluerangeprocessor(stringvaluerangeprocessor);
    stringvaluerangeprocessor = copy_stringvaluerangeprocessor;

    Xapian::TermGenerator termgenerator;
    Xapian::TermGenerator copy_termgenerator(termgenerator);
    termgenerator = copy_termgenerator;

    Xapian::TermIterator termiterator;
    Xapian::TermIterator copy_termiterator(termiterator);
    termiterator = copy_termiterator;

    Xapian::ValueIterator valueiterator;
    Xapian::ValueIterator copy_valueiterator(valueiterator);
    valueiterator = copy_valueiterator;

    Xapian::WritableDatabase writabledatabase;
    Xapian::WritableDatabase copy_writabledatabase(writabledatabase);
    writabledatabase = copy_writabledatabase;

    return true;
}
