/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.xhtml;

import writer2latex.office.OfficeReader;
import writer2latex.office.OfficeStyleFamily;
import writer2latex.office.StyleWithProperties;
import writer2latex.util.Config;
import writer2latex.util.ExportNameCollection;
import writer2latex.util.Misc;
import writer2latex.xhtml.Converter;
import writer2latex.xhtml.ConverterHelper;
import writer2latex.xhtml.StyleInfo;
import writer2latex.xhtml.XhtmlStyleMap;

public abstract class StyleConverterHelper
extends ConverterHelper {
    protected ExportNameCollection styleNames = new ExportNameCollection(true);
    protected XhtmlStyleMap styleMap;
    protected boolean bConvertStyles = true;
    protected boolean bConvertHard = true;
    protected int nType;
    private String sScale;
    private String sColScale;
    private boolean bConvertToPx;

    public StyleConverterHelper(OfficeReader ofr, Config config, Converter converter, int nType) {
        super(ofr, config, converter);
        this.nType = nType;
        this.sScale = config.getXhtmlScaling();
        this.sColScale = config.getXhtmlColumnScaling();
        this.bConvertToPx = config.xhtmlConvertToPx();
    }

    protected String scale(String s) {
        if (this.bConvertToPx) {
            return Misc.length2px(Misc.multiply(this.sScale, s));
        }
        return Misc.multiply(this.sScale, s);
    }

    protected String colScale(String s) {
        return this.scale(Misc.multiply(this.sColScale, s));
    }

    protected static void applyDirection(StyleWithProperties style, StyleInfo info) {
        String sDir = style.getProperty("style:writing-mode");
        if ("lr-tb".equals(sDir)) {
            info.sDir = "ltr";
        } else if ("rl-tb".equals(sDir)) {
            info.sDir = "rtl";
        }
    }

    protected static void applyLang(StyleWithProperties style, StyleInfo info) {
        String sLang = style.getProperty("fo:language");
        String sCountry = style.getProperty("fo:country");
        if (sLang != null) {
            info.sLang = sCountry == null ? sLang : sLang + "-" + sCountry;
        }
    }

    public abstract OfficeStyleFamily getStyles();

    public abstract String getStyleDeclarations(String var1);
}

