# -*- Mode: Python; coding: utf-8; indent-tabs-mode: nil; tab-width: 4 -*-
#
# Copyright 2013-2014 Canonical
#
# This program is free software: you can redistribute it and/or modify it
# under the terms of the GNU General Public License version 3, as published
# by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program. If not, see <http://www.gnu.org/licenses/>.

from testtools.matchers import Equals
from autopilot.matchers import Eventually

from webbrowser_app.tests import StartOpenRemotePageTestCaseBase


class TestBackForward(StartOpenRemotePageTestCaseBase):

    """Tests the back and forward functionality."""

    def test_homepage_no_history(self):
        chrome = self.main_window.get_chrome()
        self.assertThat(chrome.get_back_button().enabled, Equals(False))
        self.assertThat(chrome.get_forward_button().enabled, Equals(False))

    def test_opening_new_page_enables_back_button(self):
        back_button = self.main_window.get_chrome().get_back_button()
        self.assertThat(back_button.enabled, Equals(False))
        url = self.base_url + "/aleaiactaest"
        self.go_to_url(url)
        self.assert_page_eventually_loaded(url)
        self.assertThat(back_button.enabled, Eventually(Equals(True)))

    def test_navigating_back_enables_forward_button(self):
        url = self.base_url + "/aleaiactaest"
        self.go_to_url(url)
        self.assert_page_eventually_loaded(url)
        chrome = self.main_window.get_chrome()
        forward_button = chrome.get_forward_button()
        self.assertThat(forward_button.enabled, Equals(False))
        self.pointing_device.click_object(chrome.get_back_button())
        self.assert_home_page_eventually_loaded()
        self.assertThat(forward_button.enabled, Eventually(Equals(True)))
