
/*---------------------------------------------------------------*/
/*---                                                         ---*/
/*--- This file (host-generic/h_generic_simd64.h) is          ---*/
/*--- Copyright (C) OpenWorks LLP.  All rights reserved.      ---*/
/*---                                                         ---*/
/*---------------------------------------------------------------*/

/*
   This file is part of LibVEX, a library for dynamic binary
   instrumentation and translation.

   Copyright (C) 2004-2007 OpenWorks LLP.  All rights reserved.

   This library is made available under a dual licensing scheme.

   If you link LibVEX against other code all of which is itself
   licensed under the GNU General Public License, version 2 dated June
   1991 ("GPL v2"), then you may use LibVEX under the terms of the GPL
   v2, as appearing in the file LICENSE.GPL.  If the file LICENSE.GPL
   is missing, you can obtain a copy of the GPL v2 from the Free
   Software Foundation Inc., 51 Franklin St, Fifth Floor, Boston, MA
   02110-1301, USA.

   For any other uses of LibVEX, you must first obtain a commercial
   license from OpenWorks LLP.  Please contact info@open-works.co.uk
   for information about commercial licensing.

   This software is provided by OpenWorks LLP "as is" and any express
   or implied warranties, including, but not limited to, the implied
   warranties of merchantability and fitness for a particular purpose
   are disclaimed.  In no event shall OpenWorks LLP be liable for any
   direct, indirect, incidental, special, exemplary, or consequential
   damages (including, but not limited to, procurement of substitute
   goods or services; loss of use, data, or profits; or business
   interruption) however caused and on any theory of liability,
   whether in contract, strict liability, or tort (including
   negligence or otherwise) arising in any way out of the use of this
   software, even if advised of the possibility of such damage.

   Neither the names of the U.S. Department of Energy nor the
   University of California nor the names of its contributors may be
   used to endorse or promote products derived from this software
   without prior written permission.
*/

/* Generic helper functions for doing 64-bit SIMD arithmetic in cases
   where the instruction selectors cannot generate code in-line.
   These are purely back-end entities and cannot be seen/referenced
   as clean helper functions from IR.

   These will get called from generated code and therefore should be
   well behaved -- no floating point or mmx insns, just straight
   integer code.

   Each function implements the correspondingly-named IR primop.
*/

#ifndef __H_GENERIC_SIMD64_H
#define __H_GENERIC_SIMD64_H

#include "libvex_basictypes.h"

/* DO NOT MAKE THESE INTO REGPARM FNS!  THIS WILL BREAK CALLING
   SEQUENCES GENERATED BY host-x86/isel.c. */

extern ULong h_generic_calc_Add32x2 ( ULong, ULong );
extern ULong h_generic_calc_Add16x4 ( ULong, ULong );
extern ULong h_generic_calc_Add8x8  ( ULong, ULong );

extern ULong h_generic_calc_QAdd16Sx4 ( ULong, ULong );
extern ULong h_generic_calc_QAdd8Sx8  ( ULong, ULong );
extern ULong h_generic_calc_QAdd16Ux4 ( ULong, ULong );
extern ULong h_generic_calc_QAdd8Ux8  ( ULong, ULong );

extern ULong h_generic_calc_Sub32x2 ( ULong, ULong );
extern ULong h_generic_calc_Sub16x4 ( ULong, ULong );
extern ULong h_generic_calc_Sub8x8  ( ULong, ULong );

extern ULong h_generic_calc_QSub16Sx4 ( ULong, ULong );
extern ULong h_generic_calc_QSub8Sx8  ( ULong, ULong );
extern ULong h_generic_calc_QSub16Ux4 ( ULong, ULong );
extern ULong h_generic_calc_QSub8Ux8  ( ULong, ULong );

extern ULong h_generic_calc_Mul16x4    ( ULong, ULong );
extern ULong h_generic_calc_MulHi16Sx4 ( ULong, ULong );
extern ULong h_generic_calc_MulHi16Ux4 ( ULong, ULong );

extern ULong h_generic_calc_CmpEQ32x2  ( ULong, ULong );
extern ULong h_generic_calc_CmpEQ16x4  ( ULong, ULong );
extern ULong h_generic_calc_CmpEQ8x8   ( ULong, ULong );
extern ULong h_generic_calc_CmpGT32Sx2 ( ULong, ULong );
extern ULong h_generic_calc_CmpGT16Sx4 ( ULong, ULong );
extern ULong h_generic_calc_CmpGT8Sx8  ( ULong, ULong );

extern ULong h_generic_calc_CmpNEZ32x2 ( ULong );
extern ULong h_generic_calc_CmpNEZ16x4 ( ULong );
extern ULong h_generic_calc_CmpNEZ8x8  ( ULong );

extern ULong h_generic_calc_QNarrow32Sx2 ( ULong, ULong );
extern ULong h_generic_calc_QNarrow16Sx4 ( ULong, ULong );
extern ULong h_generic_calc_QNarrow16Ux4 ( ULong, ULong );

extern ULong h_generic_calc_InterleaveHI8x8 ( ULong, ULong );
extern ULong h_generic_calc_InterleaveLO8x8 ( ULong, ULong );
extern ULong h_generic_calc_InterleaveHI16x4 ( ULong, ULong );
extern ULong h_generic_calc_InterleaveLO16x4 ( ULong, ULong );
extern ULong h_generic_calc_InterleaveHI32x2 ( ULong, ULong );
extern ULong h_generic_calc_InterleaveLO32x2 ( ULong, ULong );

extern ULong h_generic_calc_ShlN16x4 ( ULong, UInt );
extern ULong h_generic_calc_ShlN32x2 ( ULong, UInt );

extern ULong h_generic_calc_ShrN16x4 ( ULong, UInt );
extern ULong h_generic_calc_ShrN32x2 ( ULong, UInt );

extern ULong h_generic_calc_SarN8x8  ( ULong, UInt );
extern ULong h_generic_calc_SarN16x4 ( ULong, UInt );
extern ULong h_generic_calc_SarN32x2 ( ULong, UInt );

extern ULong h_generic_calc_Avg8Ux8  ( ULong, ULong );
extern ULong h_generic_calc_Avg16Ux4 ( ULong, ULong );

extern ULong h_generic_calc_Max16Sx4 ( ULong, ULong );
extern ULong h_generic_calc_Max8Ux8  ( ULong, ULong );
extern ULong h_generic_calc_Min16Sx4 ( ULong, ULong );
extern ULong h_generic_calc_Min8Ux8  ( ULong, ULong );


#endif /* ndef __H_GENERIC_SIMD64_H */

/*---------------------------------------------------------------*/
/*--- end                     host-generic/h_generic_simd64.h ---*/
/*---------------------------------------------------------------*/
