/* hashmap.c generated by valac, the Vala compiler
 * generated from hashmap.vala, do not modify */

/* hashmap.vala
 *
 * Copyright (C) 1995-1997  Peter Mattis, Spencer Kimball and Josh MacDonald
 * Copyright (C) 1997-2000  GLib Team and others
 * Copyright (C) 2007-2009  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>


#define VALA_TYPE_MAP (vala_map_get_type ())
#define VALA_MAP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_MAP, ValaMap))
#define VALA_MAP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_MAP, ValaMapClass))
#define VALA_IS_MAP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_MAP))
#define VALA_IS_MAP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_MAP))
#define VALA_MAP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_MAP, ValaMapClass))

typedef struct _ValaMap ValaMap;
typedef struct _ValaMapClass ValaMapClass;
typedef struct _ValaMapPrivate ValaMapPrivate;

#define VALA_TYPE_ITERABLE (vala_iterable_get_type ())
#define VALA_ITERABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ITERABLE, ValaIterable))
#define VALA_ITERABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ITERABLE, ValaIterableClass))
#define VALA_IS_ITERABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ITERABLE))
#define VALA_IS_ITERABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ITERABLE))
#define VALA_ITERABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ITERABLE, ValaIterableClass))

typedef struct _ValaIterable ValaIterable;
typedef struct _ValaIterableClass ValaIterableClass;

#define VALA_TYPE_COLLECTION (vala_collection_get_type ())
#define VALA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_COLLECTION, ValaCollection))
#define VALA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_COLLECTION, ValaCollectionClass))
#define VALA_IS_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_COLLECTION))
#define VALA_IS_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_COLLECTION))
#define VALA_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_COLLECTION, ValaCollectionClass))

typedef struct _ValaCollection ValaCollection;
typedef struct _ValaCollectionClass ValaCollectionClass;

#define VALA_TYPE_SET (vala_set_get_type ())
#define VALA_SET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SET, ValaSet))
#define VALA_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SET, ValaSetClass))
#define VALA_IS_SET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SET))
#define VALA_IS_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SET))
#define VALA_SET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SET, ValaSetClass))

typedef struct _ValaSet ValaSet;
typedef struct _ValaSetClass ValaSetClass;

#define VALA_TYPE_HASH_MAP (vala_hash_map_get_type ())
#define VALA_HASH_MAP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_HASH_MAP, ValaHashMap))
#define VALA_HASH_MAP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_HASH_MAP, ValaHashMapClass))
#define VALA_IS_HASH_MAP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_HASH_MAP))
#define VALA_IS_HASH_MAP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_HASH_MAP))
#define VALA_HASH_MAP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_HASH_MAP, ValaHashMapClass))

typedef struct _ValaHashMap ValaHashMap;
typedef struct _ValaHashMapClass ValaHashMapClass;
typedef struct _ValaHashMapPrivate ValaHashMapPrivate;
typedef struct _ValaHashMapNode ValaHashMapNode;

#define VALA_HASH_MAP_TYPE_KEY_SET (vala_hash_map_key_set_get_type ())
#define VALA_HASH_MAP_KEY_SET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_HASH_MAP_TYPE_KEY_SET, ValaHashMapKeySet))
#define VALA_HASH_MAP_KEY_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_HASH_MAP_TYPE_KEY_SET, ValaHashMapKeySetClass))
#define VALA_HASH_MAP_IS_KEY_SET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_HASH_MAP_TYPE_KEY_SET))
#define VALA_HASH_MAP_IS_KEY_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_HASH_MAP_TYPE_KEY_SET))
#define VALA_HASH_MAP_KEY_SET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_HASH_MAP_TYPE_KEY_SET, ValaHashMapKeySetClass))

typedef struct _ValaHashMapKeySet ValaHashMapKeySet;
typedef struct _ValaHashMapKeySetClass ValaHashMapKeySetClass;

#define VALA_HASH_MAP_TYPE_VALUE_COLLECTION (vala_hash_map_value_collection_get_type ())
#define VALA_HASH_MAP_VALUE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_HASH_MAP_TYPE_VALUE_COLLECTION, ValaHashMapValueCollection))
#define VALA_HASH_MAP_VALUE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_HASH_MAP_TYPE_VALUE_COLLECTION, ValaHashMapValueCollectionClass))
#define VALA_HASH_MAP_IS_VALUE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_HASH_MAP_TYPE_VALUE_COLLECTION))
#define VALA_HASH_MAP_IS_VALUE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_HASH_MAP_TYPE_VALUE_COLLECTION))
#define VALA_HASH_MAP_VALUE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_HASH_MAP_TYPE_VALUE_COLLECTION, ValaHashMapValueCollectionClass))

typedef struct _ValaHashMapValueCollection ValaHashMapValueCollection;
typedef struct _ValaHashMapValueCollectionClass ValaHashMapValueCollectionClass;
#define _vala_hash_map_node_free0(var) ((var == NULL) ? NULL : (var = (vala_hash_map_node_free (var), NULL)))
typedef struct _ValaIterablePrivate ValaIterablePrivate;

#define VALA_TYPE_ITERATOR (vala_iterator_get_type ())
#define VALA_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ITERATOR, ValaIterator))
#define VALA_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ITERATOR, ValaIteratorClass))
#define VALA_IS_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ITERATOR))
#define VALA_IS_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ITERATOR))
#define VALA_ITERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ITERATOR, ValaIteratorClass))

typedef struct _ValaIterator ValaIterator;
typedef struct _ValaIteratorClass ValaIteratorClass;
typedef struct _ValaCollectionPrivate ValaCollectionPrivate;
typedef struct _ValaSetPrivate ValaSetPrivate;
typedef struct _ValaHashMapKeySetPrivate ValaHashMapKeySetPrivate;
#define _vala_map_unref0(var) ((var == NULL) ? NULL : (var = (vala_map_unref (var), NULL)))

#define VALA_HASH_MAP_TYPE_KEY_ITERATOR (vala_hash_map_key_iterator_get_type ())
#define VALA_HASH_MAP_KEY_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_HASH_MAP_TYPE_KEY_ITERATOR, ValaHashMapKeyIterator))
#define VALA_HASH_MAP_KEY_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_HASH_MAP_TYPE_KEY_ITERATOR, ValaHashMapKeyIteratorClass))
#define VALA_HASH_MAP_IS_KEY_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_HASH_MAP_TYPE_KEY_ITERATOR))
#define VALA_HASH_MAP_IS_KEY_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_HASH_MAP_TYPE_KEY_ITERATOR))
#define VALA_HASH_MAP_KEY_ITERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_HASH_MAP_TYPE_KEY_ITERATOR, ValaHashMapKeyIteratorClass))

typedef struct _ValaHashMapKeyIterator ValaHashMapKeyIterator;
typedef struct _ValaHashMapKeyIteratorClass ValaHashMapKeyIteratorClass;
typedef struct _ValaIteratorPrivate ValaIteratorPrivate;
typedef struct _ValaHashMapKeyIteratorPrivate ValaHashMapKeyIteratorPrivate;
typedef struct _ValaHashMapValueCollectionPrivate ValaHashMapValueCollectionPrivate;

#define VALA_HASH_MAP_TYPE_VALUE_ITERATOR (vala_hash_map_value_iterator_get_type ())
#define VALA_HASH_MAP_VALUE_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_HASH_MAP_TYPE_VALUE_ITERATOR, ValaHashMapValueIterator))
#define VALA_HASH_MAP_VALUE_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_HASH_MAP_TYPE_VALUE_ITERATOR, ValaHashMapValueIteratorClass))
#define VALA_HASH_MAP_IS_VALUE_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_HASH_MAP_TYPE_VALUE_ITERATOR))
#define VALA_HASH_MAP_IS_VALUE_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_HASH_MAP_TYPE_VALUE_ITERATOR))
#define VALA_HASH_MAP_VALUE_ITERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_HASH_MAP_TYPE_VALUE_ITERATOR, ValaHashMapValueIteratorClass))

typedef struct _ValaHashMapValueIterator ValaHashMapValueIterator;
typedef struct _ValaHashMapValueIteratorClass ValaHashMapValueIteratorClass;
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))
typedef struct _ValaHashMapValueIteratorPrivate ValaHashMapValueIteratorPrivate;

struct _ValaMap {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaMapPrivate * priv;
};

struct _ValaMapClass {
	GTypeClass parent_class;
	void (*finalize) (ValaMap *self);
	ValaSet* (*get_keys) (ValaMap* self);
	ValaCollection* (*get_values) (ValaMap* self);
	gboolean (*contains) (ValaMap* self, gconstpointer key);
	gpointer (*get) (ValaMap* self, gconstpointer key);
	void (*set) (ValaMap* self, gconstpointer key, gconstpointer value);
	gboolean (*remove) (ValaMap* self, gconstpointer key);
	void (*clear) (ValaMap* self);
	gint (*get_size) (ValaMap* self);
};

struct _ValaHashMap {
	ValaMap parent_instance;
	ValaHashMapPrivate * priv;
};

struct _ValaHashMapClass {
	ValaMapClass parent_class;
};

struct _ValaHashMapPrivate {
	GType k_type;
	GBoxedCopyFunc k_dup_func;
	GDestroyNotify k_destroy_func;
	GType v_type;
	GBoxedCopyFunc v_dup_func;
	GDestroyNotify v_destroy_func;
	gint _array_size;
	gint _nnodes;
	ValaHashMapNode** _nodes;
	gint _nodes_length1;
	gint __nodes_size_;
	gint _stamp;
	GHashFunc _key_hash_func;
	GEqualFunc _key_equal_func;
	GEqualFunc _value_equal_func;
};

struct _ValaHashMapNode {
	gpointer key;
	gpointer value;
	ValaHashMapNode* next;
	guint key_hash;
};

struct _ValaIterable {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaIterablePrivate * priv;
};

struct _ValaIterableClass {
	GTypeClass parent_class;
	void (*finalize) (ValaIterable *self);
	GType (*get_element_type) (ValaIterable* self);
	ValaIterator* (*iterator) (ValaIterable* self);
};

struct _ValaCollection {
	ValaIterable parent_instance;
	ValaCollectionPrivate * priv;
};

struct _ValaCollectionClass {
	ValaIterableClass parent_class;
	gboolean (*contains) (ValaCollection* self, gconstpointer item);
	gboolean (*add) (ValaCollection* self, gconstpointer item);
	gboolean (*remove) (ValaCollection* self, gconstpointer item);
	void (*clear) (ValaCollection* self);
	gint (*get_size) (ValaCollection* self);
};

struct _ValaSet {
	ValaCollection parent_instance;
	ValaSetPrivate * priv;
};

struct _ValaSetClass {
	ValaCollectionClass parent_class;
};

struct _ValaHashMapKeySet {
	ValaSet parent_instance;
	ValaHashMapKeySetPrivate * priv;
};

struct _ValaHashMapKeySetClass {
	ValaSetClass parent_class;
};

struct _ValaHashMapKeySetPrivate {
	GType k_type;
	GBoxedCopyFunc k_dup_func;
	GDestroyNotify k_destroy_func;
	GType v_type;
	GBoxedCopyFunc v_dup_func;
	GDestroyNotify v_destroy_func;
	ValaHashMap* _map;
};

struct _ValaIterator {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaIteratorPrivate * priv;
};

struct _ValaIteratorClass {
	GTypeClass parent_class;
	void (*finalize) (ValaIterator *self);
	gboolean (*next) (ValaIterator* self);
	gpointer (*get) (ValaIterator* self);
};

struct _ValaHashMapKeyIterator {
	ValaIterator parent_instance;
	ValaHashMapKeyIteratorPrivate * priv;
};

struct _ValaHashMapKeyIteratorClass {
	ValaIteratorClass parent_class;
};

struct _ValaHashMapKeyIteratorPrivate {
	GType k_type;
	GBoxedCopyFunc k_dup_func;
	GDestroyNotify k_destroy_func;
	GType v_type;
	GBoxedCopyFunc v_dup_func;
	GDestroyNotify v_destroy_func;
	ValaHashMap* _map;
	gint _index;
	ValaHashMapNode* _node;
	gint _stamp;
};

struct _ValaHashMapValueCollection {
	ValaCollection parent_instance;
	ValaHashMapValueCollectionPrivate * priv;
};

struct _ValaHashMapValueCollectionClass {
	ValaCollectionClass parent_class;
};

struct _ValaHashMapValueCollectionPrivate {
	GType k_type;
	GBoxedCopyFunc k_dup_func;
	GDestroyNotify k_destroy_func;
	GType v_type;
	GBoxedCopyFunc v_dup_func;
	GDestroyNotify v_destroy_func;
	ValaHashMap* _map;
};

struct _ValaHashMapValueIterator {
	ValaIterator parent_instance;
	ValaHashMapValueIteratorPrivate * priv;
};

struct _ValaHashMapValueIteratorClass {
	ValaIteratorClass parent_class;
};

struct _ValaHashMapValueIteratorPrivate {
	GType k_type;
	GBoxedCopyFunc k_dup_func;
	GDestroyNotify k_destroy_func;
	GType v_type;
	GBoxedCopyFunc v_dup_func;
	GDestroyNotify v_destroy_func;
	ValaHashMap* _map;
	gint _index;
	ValaHashMapNode* _node;
	gint _stamp;
};


static gpointer vala_hash_map_parent_class = NULL;
static gpointer vala_hash_map_key_set_parent_class = NULL;
static gpointer vala_hash_map_key_iterator_parent_class = NULL;
static gpointer vala_hash_map_value_collection_parent_class = NULL;
static gpointer vala_hash_map_value_iterator_parent_class = NULL;

gpointer vala_map_ref (gpointer instance);
void vala_map_unref (gpointer instance);
GParamSpec* vala_param_spec_map (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_map (GValue* value, gpointer v_object);
void vala_value_take_map (GValue* value, gpointer v_object);
gpointer vala_value_get_map (const GValue* value);
GType vala_map_get_type (void) G_GNUC_CONST;
gpointer vala_iterable_ref (gpointer instance);
void vala_iterable_unref (gpointer instance);
GParamSpec* vala_param_spec_iterable (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_iterable (GValue* value, gpointer v_object);
void vala_value_take_iterable (GValue* value, gpointer v_object);
gpointer vala_value_get_iterable (const GValue* value);
GType vala_iterable_get_type (void) G_GNUC_CONST;
GType vala_collection_get_type (void) G_GNUC_CONST;
GType vala_set_get_type (void) G_GNUC_CONST;
GType vala_hash_map_get_type (void) G_GNUC_CONST;
static void vala_hash_map_node_free (ValaHashMapNode* self);
#define VALA_HASH_MAP_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_HASH_MAP, ValaHashMapPrivate))
enum  {
	VALA_HASH_MAP_DUMMY_PROPERTY
};
void vala_map_clear (ValaMap* self);
#define VALA_HASH_MAP_MIN_SIZE 11
#define VALA_HASH_MAP_MAX_SIZE 13845163
ValaHashMap* vala_hash_map_new (GType k_type, GBoxedCopyFunc k_dup_func, GDestroyNotify k_destroy_func, GType v_type, GBoxedCopyFunc v_dup_func, GDestroyNotify v_destroy_func, GHashFunc key_hash_func, GEqualFunc key_equal_func, GEqualFunc value_equal_func);
ValaHashMap* vala_hash_map_construct (GType object_type, GType k_type, GBoxedCopyFunc k_dup_func, GDestroyNotify k_destroy_func, GType v_type, GBoxedCopyFunc v_dup_func, GDestroyNotify v_destroy_func, GHashFunc key_hash_func, GEqualFunc key_equal_func, GEqualFunc value_equal_func);
ValaMap* vala_map_construct (GType object_type, GType k_type, GBoxedCopyFunc k_dup_func, GDestroyNotify k_destroy_func, GType v_type, GBoxedCopyFunc v_dup_func, GDestroyNotify v_destroy_func);
void vala_hash_map_set_key_hash_func (ValaHashMap* self, GHashFunc value);
void vala_hash_map_set_key_equal_func (ValaHashMap* self, GEqualFunc value);
void vala_hash_map_set_value_equal_func (ValaHashMap* self, GEqualFunc value);
static ValaSet* vala_hash_map_real_get_keys (ValaMap* base);
static ValaHashMapKeySet* vala_hash_map_key_set_new (GType k_type, GBoxedCopyFunc k_dup_func, GDestroyNotify k_destroy_func, GType v_type, GBoxedCopyFunc v_dup_func, GDestroyNotify v_destroy_func, ValaHashMap* map);
static ValaHashMapKeySet* vala_hash_map_key_set_construct (GType object_type, GType k_type, GBoxedCopyFunc k_dup_func, GDestroyNotify k_destroy_func, GType v_type, GBoxedCopyFunc v_dup_func, GDestroyNotify v_destroy_func, ValaHashMap* map);
static GType vala_hash_map_key_set_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static ValaCollection* vala_hash_map_real_get_values (ValaMap* base);
static ValaHashMapValueCollection* vala_hash_map_value_collection_new (GType k_type, GBoxedCopyFunc k_dup_func, GDestroyNotify k_destroy_func, GType v_type, GBoxedCopyFunc v_dup_func, GDestroyNotify v_destroy_func, ValaHashMap* map);
static ValaHashMapValueCollection* vala_hash_map_value_collection_construct (GType object_type, GType k_type, GBoxedCopyFunc k_dup_func, GDestroyNotify k_destroy_func, GType v_type, GBoxedCopyFunc v_dup_func, GDestroyNotify v_destroy_func, ValaHashMap* map);
static GType vala_hash_map_value_collection_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static ValaHashMapNode** vala_hash_map_lookup_node (ValaHashMap* self, gconstpointer key);
static gboolean vala_hash_map_real_contains (ValaMap* base, gconstpointer key);
static gpointer vala_hash_map_real_get (ValaMap* base, gconstpointer key);
static void vala_hash_map_real_set (ValaMap* base, gconstpointer key, gconstpointer value);
static ValaHashMapNode* vala_hash_map_node_new (gpointer k, gpointer v, guint hash);
static ValaHashMapNode* vala_hash_map_node_new (gpointer k, gpointer v, guint hash);
static void vala_hash_map_resize (ValaHashMap* self);
static gboolean vala_hash_map_real_remove (ValaMap* base, gconstpointer key);
static void vala_hash_map_real_clear (ValaMap* base);
static void vala_hash_map_node_instance_init (ValaHashMapNode * self);
gpointer vala_iterator_ref (gpointer instance);
void vala_iterator_unref (gpointer instance);
GParamSpec* vala_param_spec_iterator (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_iterator (GValue* value, gpointer v_object);
void vala_value_take_iterator (GValue* value, gpointer v_object);
gpointer vala_value_get_iterator (const GValue* value);
GType vala_iterator_get_type (void) G_GNUC_CONST;
#define VALA_HASH_MAP_KEY_SET_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_HASH_MAP_TYPE_KEY_SET, ValaHashMapKeySetPrivate))
enum  {
	VALA_HASH_MAP_KEY_SET_DUMMY_PROPERTY
};
ValaSet* vala_set_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func);
static void vala_hash_map_key_set_set_map (ValaHashMapKeySet* self, ValaHashMap* value);
static GType vala_hash_map_key_set_real_get_element_type (ValaIterable* base);
static ValaIterator* vala_hash_map_key_set_real_iterator (ValaIterable* base);
static ValaHashMapKeyIterator* vala_hash_map_key_iterator_new (GType k_type, GBoxedCopyFunc k_dup_func, GDestroyNotify k_destroy_func, GType v_type, GBoxedCopyFunc v_dup_func, GDestroyNotify v_destroy_func, ValaHashMap* map);
static ValaHashMapKeyIterator* vala_hash_map_key_iterator_construct (GType object_type, GType k_type, GBoxedCopyFunc k_dup_func, GDestroyNotify k_destroy_func, GType v_type, GBoxedCopyFunc v_dup_func, GDestroyNotify v_destroy_func, ValaHashMap* map);
static GType vala_hash_map_key_iterator_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static gboolean vala_hash_map_key_set_real_add (ValaCollection* base, gconstpointer key);
static void vala_hash_map_key_set_real_clear (ValaCollection* base);
static gboolean vala_hash_map_key_set_real_remove (ValaCollection* base, gconstpointer key);
static gboolean vala_hash_map_key_set_real_contains (ValaCollection* base, gconstpointer key);
gboolean vala_map_contains (ValaMap* self, gconstpointer key);
gint vala_map_get_size (ValaMap* self);
static void vala_hash_map_key_set_finalize (ValaIterable* obj);
#define VALA_HASH_MAP_KEY_ITERATOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_HASH_MAP_TYPE_KEY_ITERATOR, ValaHashMapKeyIteratorPrivate))
enum  {
	VALA_HASH_MAP_KEY_ITERATOR_DUMMY_PROPERTY
};
ValaIterator* vala_iterator_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func);
static void vala_hash_map_key_iterator_set_map (ValaHashMapKeyIterator* self, ValaHashMap* value);
static gboolean vala_hash_map_key_iterator_real_next (ValaIterator* base);
static gpointer vala_hash_map_key_iterator_real_get (ValaIterator* base);
static void vala_hash_map_key_iterator_finalize (ValaIterator* obj);
#define VALA_HASH_MAP_VALUE_COLLECTION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_HASH_MAP_TYPE_VALUE_COLLECTION, ValaHashMapValueCollectionPrivate))
enum  {
	VALA_HASH_MAP_VALUE_COLLECTION_DUMMY_PROPERTY
};
ValaCollection* vala_collection_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func);
static void vala_hash_map_value_collection_set_map (ValaHashMapValueCollection* self, ValaHashMap* value);
static GType vala_hash_map_value_collection_real_get_element_type (ValaIterable* base);
static ValaIterator* vala_hash_map_value_collection_real_iterator (ValaIterable* base);
static ValaHashMapValueIterator* vala_hash_map_value_iterator_new (GType k_type, GBoxedCopyFunc k_dup_func, GDestroyNotify k_destroy_func, GType v_type, GBoxedCopyFunc v_dup_func, GDestroyNotify v_destroy_func, ValaHashMap* map);
static ValaHashMapValueIterator* vala_hash_map_value_iterator_construct (GType object_type, GType k_type, GBoxedCopyFunc k_dup_func, GDestroyNotify k_destroy_func, GType v_type, GBoxedCopyFunc v_dup_func, GDestroyNotify v_destroy_func, ValaHashMap* map);
static GType vala_hash_map_value_iterator_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static gboolean vala_hash_map_value_collection_real_add (ValaCollection* base, gconstpointer value);
static void vala_hash_map_value_collection_real_clear (ValaCollection* base);
static gboolean vala_hash_map_value_collection_real_remove (ValaCollection* base, gconstpointer value);
static gboolean vala_hash_map_value_collection_real_contains (ValaCollection* base, gconstpointer value);
ValaIterator* vala_iterable_iterator (ValaIterable* self);
gboolean vala_iterator_next (ValaIterator* self);
gpointer vala_iterator_get (ValaIterator* self);
static void vala_hash_map_value_collection_finalize (ValaIterable* obj);
#define VALA_HASH_MAP_VALUE_ITERATOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_HASH_MAP_TYPE_VALUE_ITERATOR, ValaHashMapValueIteratorPrivate))
enum  {
	VALA_HASH_MAP_VALUE_ITERATOR_DUMMY_PROPERTY
};
static void vala_hash_map_value_iterator_set_map (ValaHashMapValueIterator* self, ValaHashMap* value);
static gboolean vala_hash_map_value_iterator_real_next (ValaIterator* base);
static gpointer vala_hash_map_value_iterator_real_get (ValaIterator* base);
static void vala_hash_map_value_iterator_finalize (ValaIterator* obj);
static void vala_hash_map_finalize (ValaMap* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


ValaHashMap* vala_hash_map_construct (GType object_type, GType k_type, GBoxedCopyFunc k_dup_func, GDestroyNotify k_destroy_func, GType v_type, GBoxedCopyFunc v_dup_func, GDestroyNotify v_destroy_func, GHashFunc key_hash_func, GEqualFunc key_equal_func, GEqualFunc value_equal_func) {
	ValaHashMap* self = NULL;
	ValaHashMapNode** _tmp0_ = NULL;
	self = (ValaHashMap*) vala_map_construct (object_type, k_type, (GBoxedCopyFunc) k_dup_func, k_destroy_func, v_type, (GBoxedCopyFunc) v_dup_func, v_destroy_func);
	self->priv->k_type = k_type;
	self->priv->k_dup_func = k_dup_func;
	self->priv->k_destroy_func = k_destroy_func;
	self->priv->v_type = v_type;
	self->priv->v_dup_func = v_dup_func;
	self->priv->v_destroy_func = v_destroy_func;
	vala_hash_map_set_key_hash_func (self, key_hash_func);
	vala_hash_map_set_key_equal_func (self, key_equal_func);
	vala_hash_map_set_value_equal_func (self, value_equal_func);
	self->priv->_array_size = VALA_HASH_MAP_MIN_SIZE;
	_tmp0_ = g_new0 (ValaHashMapNode*, self->priv->_array_size + 1);
	self->priv->_nodes = (_vala_array_free (self->priv->_nodes, self->priv->_nodes_length1, (GDestroyNotify) vala_hash_map_node_free), NULL);
	self->priv->_nodes = _tmp0_;
	self->priv->_nodes_length1 = self->priv->_array_size;
	self->priv->__nodes_size_ = self->priv->_array_size;
	return self;
}


ValaHashMap* vala_hash_map_new (GType k_type, GBoxedCopyFunc k_dup_func, GDestroyNotify k_destroy_func, GType v_type, GBoxedCopyFunc v_dup_func, GDestroyNotify v_destroy_func, GHashFunc key_hash_func, GEqualFunc key_equal_func, GEqualFunc value_equal_func) {
	return vala_hash_map_construct (VALA_TYPE_HASH_MAP, k_type, k_dup_func, k_destroy_func, v_type, v_dup_func, v_destroy_func, key_hash_func, key_equal_func, value_equal_func);
}


static ValaSet* vala_hash_map_real_get_keys (ValaMap* base) {
	ValaHashMap * self;
	ValaSet* result = NULL;
	ValaHashMapKeySet* _tmp0_ = NULL;
	self = (ValaHashMap*) base;
	_tmp0_ = vala_hash_map_key_set_new (self->priv->k_type, (GBoxedCopyFunc) self->priv->k_dup_func, self->priv->k_destroy_func, self->priv->v_type, (GBoxedCopyFunc) self->priv->v_dup_func, self->priv->v_destroy_func, self);
	result = (ValaSet*) _tmp0_;
	return result;
}


static ValaCollection* vala_hash_map_real_get_values (ValaMap* base) {
	ValaHashMap * self;
	ValaCollection* result = NULL;
	ValaHashMapValueCollection* _tmp0_ = NULL;
	self = (ValaHashMap*) base;
	_tmp0_ = vala_hash_map_value_collection_new (self->priv->k_type, (GBoxedCopyFunc) self->priv->k_dup_func, self->priv->k_destroy_func, self->priv->v_type, (GBoxedCopyFunc) self->priv->v_dup_func, self->priv->v_destroy_func, self);
	result = (ValaCollection*) _tmp0_;
	return result;
}


static ValaHashMapNode** vala_hash_map_lookup_node (ValaHashMap* self, gconstpointer key) {
	ValaHashMapNode** result = NULL;
	guint _tmp0_;
	guint hash_value;
	ValaHashMapNode** node;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_key_hash_func (key);
	hash_value = _tmp0_;
	node = &self->priv->_nodes[hash_value % self->priv->_array_size];
	while (TRUE) {
		gboolean _tmp1_ = FALSE;
		if ((*node) != NULL) {
			gboolean _tmp2_ = FALSE;
			if (hash_value != (*node)->key_hash) {
				_tmp2_ = TRUE;
			} else {
				gboolean _tmp3_;
				_tmp3_ = self->priv->_key_equal_func ((*node)->key, key);
				_tmp2_ = !_tmp3_;
			}
			_tmp1_ = _tmp2_;
		} else {
			_tmp1_ = FALSE;
		}
		if (!_tmp1_) {
			break;
		}
		node = &(*node)->next;
	}
	result = node;
	return result;
}


static gboolean vala_hash_map_real_contains (ValaMap* base, gconstpointer key) {
	ValaHashMap * self;
	gboolean result = FALSE;
	ValaHashMapNode** _tmp0_ = NULL;
	ValaHashMapNode** node;
	self = (ValaHashMap*) base;
	_tmp0_ = vala_hash_map_lookup_node (self, key);
	node = _tmp0_;
	result = (*node) != NULL;
	return result;
}


static gpointer vala_hash_map_real_get (ValaMap* base, gconstpointer key) {
	ValaHashMap * self;
	gpointer result = NULL;
	ValaHashMapNode** _tmp0_ = NULL;
	ValaHashMapNode* node;
	self = (ValaHashMap*) base;
	_tmp0_ = vala_hash_map_lookup_node (self, key);
	node = *_tmp0_;
	if (node != NULL) {
		gpointer _tmp1_;
		gconstpointer _tmp2_;
		_tmp1_ = (_tmp2_ = node->value, ((_tmp2_ == NULL) || (self->priv->v_dup_func == NULL)) ? ((gpointer) _tmp2_) : self->priv->v_dup_func ((gpointer) _tmp2_));
		result = _tmp1_;
		return result;
	} else {
		result = NULL;
		return result;
	}
}


static void vala_hash_map_real_set (ValaMap* base, gconstpointer key, gconstpointer value) {
	ValaHashMap * self;
	ValaHashMapNode** _tmp0_ = NULL;
	ValaHashMapNode** node;
	self = (ValaHashMap*) base;
	_tmp0_ = vala_hash_map_lookup_node (self, key);
	node = _tmp0_;
	if ((*node) != NULL) {
		gpointer _tmp1_;
		gconstpointer _tmp2_;
		_tmp1_ = (_tmp2_ = value, ((_tmp2_ == NULL) || (self->priv->v_dup_func == NULL)) ? ((gpointer) _tmp2_) : self->priv->v_dup_func ((gpointer) _tmp2_));
		(((*node)->value == NULL) || (self->priv->v_destroy_func == NULL)) ? NULL : ((*node)->value = (self->priv->v_destroy_func ((*node)->value), NULL));
		(*node)->value = _tmp1_;
	} else {
		guint _tmp3_;
		guint hash_value;
		gpointer _tmp4_;
		gconstpointer _tmp5_;
		gpointer _tmp6_;
		gconstpointer _tmp7_;
		ValaHashMapNode* _tmp8_ = NULL;
		_tmp3_ = self->priv->_key_hash_func (key);
		hash_value = _tmp3_;
		_tmp4_ = (_tmp5_ = key, ((_tmp5_ == NULL) || (self->priv->k_dup_func == NULL)) ? ((gpointer) _tmp5_) : self->priv->k_dup_func ((gpointer) _tmp5_));
		_tmp6_ = (_tmp7_ = value, ((_tmp7_ == NULL) || (self->priv->v_dup_func == NULL)) ? ((gpointer) _tmp7_) : self->priv->v_dup_func ((gpointer) _tmp7_));
		_tmp8_ = vala_hash_map_node_new (_tmp4_, _tmp6_, hash_value);
		*node = _tmp8_;
		self->priv->_nnodes++;
		vala_hash_map_resize (self);
	}
	self->priv->_stamp++;
}


static gboolean vala_hash_map_real_remove (ValaMap* base, gconstpointer key) {
	ValaHashMap * self;
	gboolean result = FALSE;
	ValaHashMapNode** _tmp0_ = NULL;
	ValaHashMapNode** node;
	self = (ValaHashMap*) base;
	_tmp0_ = vala_hash_map_lookup_node (self, key);
	node = _tmp0_;
	if ((*node) != NULL) {
		ValaHashMapNode* _tmp1_;
		ValaHashMapNode* next;
		ValaHashMapNode* _tmp2_;
		_tmp1_ = (*node)->next;
		(*node)->next = NULL;
		next = _tmp1_;
		(((*node)->key == NULL) || (self->priv->k_destroy_func == NULL)) ? NULL : ((*node)->key = (self->priv->k_destroy_func ((*node)->key), NULL));
		(*node)->key = NULL;
		(((*node)->value == NULL) || (self->priv->v_destroy_func == NULL)) ? NULL : ((*node)->value = (self->priv->v_destroy_func ((*node)->value), NULL));
		(*node)->value = NULL;
		vala_hash_map_node_free (*node);
		_tmp2_ = next;
		next = NULL;
		*node = _tmp2_;
		self->priv->_nnodes--;
		vala_hash_map_resize (self);
		self->priv->_stamp++;
		result = TRUE;
		_vala_hash_map_node_free0 (next);
		return result;
	}
	result = FALSE;
	return result;
}


static void vala_hash_map_real_clear (ValaMap* base) {
	ValaHashMap * self;
	self = (ValaHashMap*) base;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				ValaHashMapNode* _tmp1_;
				ValaHashMapNode* node;
				if (!_tmp0_) {
					i++;
				}
				_tmp0_ = FALSE;
				if (!(i < self->priv->_array_size)) {
					break;
				}
				_tmp1_ = self->priv->_nodes[i];
				self->priv->_nodes[i] = NULL;
				node = _tmp1_;
				while (TRUE) {
					ValaHashMapNode* _tmp2_;
					ValaHashMapNode* next;
					ValaHashMapNode* _tmp3_;
					if (!(node != NULL)) {
						break;
					}
					_tmp2_ = node->next;
					node->next = NULL;
					next = _tmp2_;
					((node->key == NULL) || (self->priv->k_destroy_func == NULL)) ? NULL : (node->key = (self->priv->k_destroy_func (node->key), NULL));
					node->key = NULL;
					((node->value == NULL) || (self->priv->v_destroy_func == NULL)) ? NULL : (node->value = (self->priv->v_destroy_func (node->value), NULL));
					node->value = NULL;
					_tmp3_ = next;
					next = NULL;
					_vala_hash_map_node_free0 (node);
					node = _tmp3_;
					_vala_hash_map_node_free0 (next);
				}
				_vala_hash_map_node_free0 (node);
			}
		}
	}
	self->priv->_nnodes = 0;
	vala_hash_map_resize (self);
}


static void vala_hash_map_resize (ValaHashMap* self) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	if (self->priv->_array_size >= (3 * self->priv->_nnodes)) {
		_tmp1_ = self->priv->_array_size >= VALA_HASH_MAP_MIN_SIZE;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp2_ = FALSE;
		if ((3 * self->priv->_array_size) <= self->priv->_nnodes) {
			_tmp2_ = self->priv->_array_size < VALA_HASH_MAP_MAX_SIZE;
		} else {
			_tmp2_ = FALSE;
		}
		_tmp0_ = _tmp2_;
	}
	if (_tmp0_) {
		guint _tmp3_;
		gint new_array_size;
		gint _tmp4_;
		ValaHashMapNode** _tmp5_ = NULL;
		ValaHashMapNode** new_nodes;
		gint new_nodes_length1;
		gint _new_nodes_size_;
		ValaHashMapNode** _tmp14_;
		_tmp3_ = g_spaced_primes_closest ((guint) self->priv->_nnodes);
		new_array_size = (gint) _tmp3_;
		_tmp4_ = CLAMP (new_array_size, VALA_HASH_MAP_MIN_SIZE, VALA_HASH_MAP_MAX_SIZE);
		new_array_size = _tmp4_;
		_tmp5_ = g_new0 (ValaHashMapNode*, new_array_size + 1);
		new_nodes = _tmp5_;
		new_nodes_length1 = new_array_size;
		_new_nodes_size_ = new_array_size;
		{
			gint i;
			i = 0;
			{
				gboolean _tmp6_;
				_tmp6_ = TRUE;
				while (TRUE) {
					ValaHashMapNode* node = NULL;
					ValaHashMapNode* next;
					if (!_tmp6_) {
						i++;
					}
					_tmp6_ = FALSE;
					if (!(i < self->priv->_array_size)) {
						break;
					}
					next = NULL;
					{
						ValaHashMapNode* _tmp7_;
						gboolean _tmp8_;
						_tmp7_ = self->priv->_nodes[i];
						self->priv->_nodes[i] = NULL;
						_vala_hash_map_node_free0 (node);
						node = _tmp7_;
						_tmp8_ = TRUE;
						while (TRUE) {
							ValaHashMapNode* _tmp10_;
							guint hash_val;
							ValaHashMapNode* _tmp11_;
							ValaHashMapNode* _tmp12_;
							ValaHashMapNode* _tmp13_;
							if (!_tmp8_) {
								ValaHashMapNode* _tmp9_;
								_tmp9_ = next;
								next = NULL;
								_vala_hash_map_node_free0 (node);
								node = _tmp9_;
							}
							_tmp8_ = FALSE;
							if (!(node != NULL)) {
								break;
							}
							_tmp10_ = node->next;
							node->next = NULL;
							_vala_hash_map_node_free0 (next);
							next = _tmp10_;
							hash_val = node->key_hash % new_array_size;
							_tmp11_ = new_nodes[hash_val];
							new_nodes[hash_val] = NULL;
							_vala_hash_map_node_free0 (node->next);
							node->next = _tmp11_;
							_tmp12_ = node;
							node = NULL;
							_tmp13_ = _tmp12_;
							_vala_hash_map_node_free0 (new_nodes[hash_val]);
							new_nodes[hash_val] = _tmp13_;
						}
					}
					_vala_hash_map_node_free0 (next);
					_vala_hash_map_node_free0 (node);
				}
			}
		}
		_tmp14_ = new_nodes;
		new_nodes = NULL;
		self->priv->_nodes = (_vala_array_free (self->priv->_nodes, self->priv->_nodes_length1, (GDestroyNotify) vala_hash_map_node_free), NULL);
		self->priv->_nodes = _tmp14_;
		self->priv->_nodes_length1 = new_nodes_length1;
		self->priv->__nodes_size_ = new_nodes_length1;
		self->priv->_array_size = new_array_size;
		new_nodes = (_vala_array_free (new_nodes, new_nodes_length1, (GDestroyNotify) vala_hash_map_node_free), NULL);
	}
}


static gint vala_hash_map_real_get_size (ValaMap* base) {
	gint result;
	ValaHashMap* self;
	self = (ValaHashMap*) base;
	result = self->priv->_nnodes;
	return result;
}


void vala_hash_map_set_key_hash_func (ValaHashMap* self, GHashFunc value) {
	g_return_if_fail (self != NULL);
	self->priv->_key_hash_func = value;
}


void vala_hash_map_set_key_equal_func (ValaHashMap* self, GEqualFunc value) {
	g_return_if_fail (self != NULL);
	self->priv->_key_equal_func = value;
}


void vala_hash_map_set_value_equal_func (ValaHashMap* self, GEqualFunc value) {
	g_return_if_fail (self != NULL);
	self->priv->_value_equal_func = value;
}


static ValaHashMapNode* vala_hash_map_node_new (gpointer k, gpointer v, guint hash) {
	ValaHashMapNode* self;
	gpointer _tmp0_;
	gpointer _tmp1_;
	self = g_slice_new0 (ValaHashMapNode);
	vala_hash_map_node_instance_init (self);
	_tmp0_ = k;
	k = NULL;
	self->key = _tmp0_;
	_tmp1_ = v;
	v = NULL;
	self->value = _tmp1_;
	self->key_hash = hash;
	return self;
}


static void vala_hash_map_node_instance_init (ValaHashMapNode * self) {
}


static void vala_hash_map_node_free (ValaHashMapNode* self) {
	_vala_hash_map_node_free0 (self->next);
	g_slice_free (ValaHashMapNode, self);
}


static ValaHashMapKeySet* vala_hash_map_key_set_construct (GType object_type, GType k_type, GBoxedCopyFunc k_dup_func, GDestroyNotify k_destroy_func, GType v_type, GBoxedCopyFunc v_dup_func, GDestroyNotify v_destroy_func, ValaHashMap* map) {
	ValaHashMapKeySet* self = NULL;
	g_return_val_if_fail (map != NULL, NULL);
	self = (ValaHashMapKeySet*) vala_set_construct (object_type, k_type, (GBoxedCopyFunc) k_dup_func, k_destroy_func);
	self->priv->k_type = k_type;
	self->priv->k_dup_func = k_dup_func;
	self->priv->k_destroy_func = k_destroy_func;
	self->priv->v_type = v_type;
	self->priv->v_dup_func = v_dup_func;
	self->priv->v_destroy_func = v_destroy_func;
	vala_hash_map_key_set_set_map (self, map);
	return self;
}


static ValaHashMapKeySet* vala_hash_map_key_set_new (GType k_type, GBoxedCopyFunc k_dup_func, GDestroyNotify k_destroy_func, GType v_type, GBoxedCopyFunc v_dup_func, GDestroyNotify v_destroy_func, ValaHashMap* map) {
	return vala_hash_map_key_set_construct (VALA_HASH_MAP_TYPE_KEY_SET, k_type, k_dup_func, k_destroy_func, v_type, v_dup_func, v_destroy_func, map);
}


static GType vala_hash_map_key_set_real_get_element_type (ValaIterable* base) {
	ValaHashMapKeySet * self;
	GType result = 0UL;
	self = (ValaHashMapKeySet*) base;
	result = self->priv->k_type;
	return result;
}


static ValaIterator* vala_hash_map_key_set_real_iterator (ValaIterable* base) {
	ValaHashMapKeySet * self;
	ValaIterator* result = NULL;
	ValaHashMapKeyIterator* _tmp0_ = NULL;
	self = (ValaHashMapKeySet*) base;
	_tmp0_ = vala_hash_map_key_iterator_new (self->priv->k_type, (GBoxedCopyFunc) self->priv->k_dup_func, self->priv->k_destroy_func, self->priv->v_type, (GBoxedCopyFunc) self->priv->v_dup_func, self->priv->v_destroy_func, self->priv->_map);
	result = (ValaIterator*) _tmp0_;
	return result;
}


static gboolean vala_hash_map_key_set_real_add (ValaCollection* base, gconstpointer key) {
	ValaHashMapKeySet * self;
	gboolean result = FALSE;
	self = (ValaHashMapKeySet*) base;
	g_assert_not_reached ();
	return result;
}


static void vala_hash_map_key_set_real_clear (ValaCollection* base) {
	ValaHashMapKeySet * self;
	self = (ValaHashMapKeySet*) base;
	g_assert_not_reached ();
}


static gboolean vala_hash_map_key_set_real_remove (ValaCollection* base, gconstpointer key) {
	ValaHashMapKeySet * self;
	gboolean result = FALSE;
	self = (ValaHashMapKeySet*) base;
	g_assert_not_reached ();
	return result;
}


static gboolean vala_hash_map_key_set_real_contains (ValaCollection* base, gconstpointer key) {
	ValaHashMapKeySet * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	self = (ValaHashMapKeySet*) base;
	_tmp0_ = vala_map_contains ((ValaMap*) self->priv->_map, key);
	result = _tmp0_;
	return result;
}


static gpointer _vala_map_ref0 (gpointer self) {
	return self ? vala_map_ref (self) : NULL;
}


static void vala_hash_map_key_set_set_map (ValaHashMapKeySet* self, ValaHashMap* value) {
	ValaHashMap* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_map_ref0 (value);
	_vala_map_unref0 (self->priv->_map);
	self->priv->_map = _tmp0_;
}


static gint vala_hash_map_key_set_real_get_size (ValaCollection* base) {
	gint result;
	ValaHashMapKeySet* self;
	gint _tmp0_;
	self = (ValaHashMapKeySet*) base;
	_tmp0_ = vala_map_get_size ((ValaMap*) self->priv->_map);
	result = _tmp0_;
	return result;
}


static void vala_hash_map_key_set_class_init (ValaHashMapKeySetClass * klass) {
	vala_hash_map_key_set_parent_class = g_type_class_peek_parent (klass);
	VALA_ITERABLE_CLASS (klass)->finalize = vala_hash_map_key_set_finalize;
	g_type_class_add_private (klass, sizeof (ValaHashMapKeySetPrivate));
	VALA_ITERABLE_CLASS (klass)->get_element_type = vala_hash_map_key_set_real_get_element_type;
	VALA_ITERABLE_CLASS (klass)->iterator = vala_hash_map_key_set_real_iterator;
	VALA_COLLECTION_CLASS (klass)->add = vala_hash_map_key_set_real_add;
	VALA_COLLECTION_CLASS (klass)->clear = vala_hash_map_key_set_real_clear;
	VALA_COLLECTION_CLASS (klass)->remove = vala_hash_map_key_set_real_remove;
	VALA_COLLECTION_CLASS (klass)->contains = vala_hash_map_key_set_real_contains;
	VALA_COLLECTION_CLASS (klass)->get_size = vala_hash_map_key_set_real_get_size;
}


static void vala_hash_map_key_set_instance_init (ValaHashMapKeySet * self) {
	self->priv = VALA_HASH_MAP_KEY_SET_GET_PRIVATE (self);
}


static void vala_hash_map_key_set_finalize (ValaIterable* obj) {
	ValaHashMapKeySet * self;
	self = VALA_HASH_MAP_KEY_SET (obj);
	_vala_map_unref0 (self->priv->_map);
	VALA_ITERABLE_CLASS (vala_hash_map_key_set_parent_class)->finalize (obj);
}


static GType vala_hash_map_key_set_get_type (void) {
	static volatile gsize vala_hash_map_key_set_type_id__volatile = 0;
	if (g_once_init_enter (&vala_hash_map_key_set_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaHashMapKeySetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_hash_map_key_set_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaHashMapKeySet), 0, (GInstanceInitFunc) vala_hash_map_key_set_instance_init, NULL };
		GType vala_hash_map_key_set_type_id;
		vala_hash_map_key_set_type_id = g_type_register_static (VALA_TYPE_SET, "ValaHashMapKeySet", &g_define_type_info, 0);
		g_once_init_leave (&vala_hash_map_key_set_type_id__volatile, vala_hash_map_key_set_type_id);
	}
	return vala_hash_map_key_set_type_id__volatile;
}


static ValaHashMapKeyIterator* vala_hash_map_key_iterator_construct (GType object_type, GType k_type, GBoxedCopyFunc k_dup_func, GDestroyNotify k_destroy_func, GType v_type, GBoxedCopyFunc v_dup_func, GDestroyNotify v_destroy_func, ValaHashMap* map) {
	ValaHashMapKeyIterator* self = NULL;
	g_return_val_if_fail (map != NULL, NULL);
	self = (ValaHashMapKeyIterator*) vala_iterator_construct (object_type, k_type, (GBoxedCopyFunc) k_dup_func, k_destroy_func);
	self->priv->k_type = k_type;
	self->priv->k_dup_func = k_dup_func;
	self->priv->k_destroy_func = k_destroy_func;
	self->priv->v_type = v_type;
	self->priv->v_dup_func = v_dup_func;
	self->priv->v_destroy_func = v_destroy_func;
	vala_hash_map_key_iterator_set_map (self, map);
	return self;
}


static ValaHashMapKeyIterator* vala_hash_map_key_iterator_new (GType k_type, GBoxedCopyFunc k_dup_func, GDestroyNotify k_destroy_func, GType v_type, GBoxedCopyFunc v_dup_func, GDestroyNotify v_destroy_func, ValaHashMap* map) {
	return vala_hash_map_key_iterator_construct (VALA_HASH_MAP_TYPE_KEY_ITERATOR, k_type, k_dup_func, k_destroy_func, v_type, v_dup_func, v_destroy_func, map);
}


static gboolean vala_hash_map_key_iterator_real_next (ValaIterator* base) {
	ValaHashMapKeyIterator * self;
	gboolean result = FALSE;
	self = (ValaHashMapKeyIterator*) base;
	if (self->priv->_node != NULL) {
		self->priv->_node = self->priv->_node->next;
	}
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		if (self->priv->_node == NULL) {
			_tmp0_ = (self->priv->_index + 1) < self->priv->_map->priv->_array_size;
		} else {
			_tmp0_ = FALSE;
		}
		if (!_tmp0_) {
			break;
		}
		self->priv->_index++;
		self->priv->_node = self->priv->_map->priv->_nodes[self->priv->_index];
	}
	result = self->priv->_node != NULL;
	return result;
}


static gpointer vala_hash_map_key_iterator_real_get (ValaIterator* base) {
	ValaHashMapKeyIterator * self;
	gpointer result = NULL;
	gpointer _tmp0_;
	gconstpointer _tmp1_;
	self = (ValaHashMapKeyIterator*) base;
	g_assert (self->priv->_stamp == self->priv->_map->priv->_stamp);
	g_assert (self->priv->_node != NULL);
	_tmp0_ = (_tmp1_ = self->priv->_node->key, ((_tmp1_ == NULL) || (self->priv->k_dup_func == NULL)) ? ((gpointer) _tmp1_) : self->priv->k_dup_func ((gpointer) _tmp1_));
	result = _tmp0_;
	return result;
}


static void vala_hash_map_key_iterator_set_map (ValaHashMapKeyIterator* self, ValaHashMap* value) {
	ValaHashMap* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_map_ref0 (value);
	_vala_map_unref0 (self->priv->_map);
	self->priv->_map = _tmp0_;
	self->priv->_stamp = self->priv->_map->priv->_stamp;
}


static void vala_hash_map_key_iterator_class_init (ValaHashMapKeyIteratorClass * klass) {
	vala_hash_map_key_iterator_parent_class = g_type_class_peek_parent (klass);
	VALA_ITERATOR_CLASS (klass)->finalize = vala_hash_map_key_iterator_finalize;
	g_type_class_add_private (klass, sizeof (ValaHashMapKeyIteratorPrivate));
	VALA_ITERATOR_CLASS (klass)->next = vala_hash_map_key_iterator_real_next;
	VALA_ITERATOR_CLASS (klass)->get = vala_hash_map_key_iterator_real_get;
}


static void vala_hash_map_key_iterator_instance_init (ValaHashMapKeyIterator * self) {
	self->priv = VALA_HASH_MAP_KEY_ITERATOR_GET_PRIVATE (self);
	self->priv->_index = -1;
}


static void vala_hash_map_key_iterator_finalize (ValaIterator* obj) {
	ValaHashMapKeyIterator * self;
	self = VALA_HASH_MAP_KEY_ITERATOR (obj);
	_vala_map_unref0 (self->priv->_map);
	VALA_ITERATOR_CLASS (vala_hash_map_key_iterator_parent_class)->finalize (obj);
}


static GType vala_hash_map_key_iterator_get_type (void) {
	static volatile gsize vala_hash_map_key_iterator_type_id__volatile = 0;
	if (g_once_init_enter (&vala_hash_map_key_iterator_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaHashMapKeyIteratorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_hash_map_key_iterator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaHashMapKeyIterator), 0, (GInstanceInitFunc) vala_hash_map_key_iterator_instance_init, NULL };
		GType vala_hash_map_key_iterator_type_id;
		vala_hash_map_key_iterator_type_id = g_type_register_static (VALA_TYPE_ITERATOR, "ValaHashMapKeyIterator", &g_define_type_info, 0);
		g_once_init_leave (&vala_hash_map_key_iterator_type_id__volatile, vala_hash_map_key_iterator_type_id);
	}
	return vala_hash_map_key_iterator_type_id__volatile;
}


static ValaHashMapValueCollection* vala_hash_map_value_collection_construct (GType object_type, GType k_type, GBoxedCopyFunc k_dup_func, GDestroyNotify k_destroy_func, GType v_type, GBoxedCopyFunc v_dup_func, GDestroyNotify v_destroy_func, ValaHashMap* map) {
	ValaHashMapValueCollection* self = NULL;
	g_return_val_if_fail (map != NULL, NULL);
	self = (ValaHashMapValueCollection*) vala_collection_construct (object_type, v_type, (GBoxedCopyFunc) v_dup_func, v_destroy_func);
	self->priv->k_type = k_type;
	self->priv->k_dup_func = k_dup_func;
	self->priv->k_destroy_func = k_destroy_func;
	self->priv->v_type = v_type;
	self->priv->v_dup_func = v_dup_func;
	self->priv->v_destroy_func = v_destroy_func;
	vala_hash_map_value_collection_set_map (self, map);
	return self;
}


static ValaHashMapValueCollection* vala_hash_map_value_collection_new (GType k_type, GBoxedCopyFunc k_dup_func, GDestroyNotify k_destroy_func, GType v_type, GBoxedCopyFunc v_dup_func, GDestroyNotify v_destroy_func, ValaHashMap* map) {
	return vala_hash_map_value_collection_construct (VALA_HASH_MAP_TYPE_VALUE_COLLECTION, k_type, k_dup_func, k_destroy_func, v_type, v_dup_func, v_destroy_func, map);
}


static GType vala_hash_map_value_collection_real_get_element_type (ValaIterable* base) {
	ValaHashMapValueCollection * self;
	GType result = 0UL;
	self = (ValaHashMapValueCollection*) base;
	result = self->priv->v_type;
	return result;
}


static ValaIterator* vala_hash_map_value_collection_real_iterator (ValaIterable* base) {
	ValaHashMapValueCollection * self;
	ValaIterator* result = NULL;
	ValaHashMapValueIterator* _tmp0_ = NULL;
	self = (ValaHashMapValueCollection*) base;
	_tmp0_ = vala_hash_map_value_iterator_new (self->priv->k_type, (GBoxedCopyFunc) self->priv->k_dup_func, self->priv->k_destroy_func, self->priv->v_type, (GBoxedCopyFunc) self->priv->v_dup_func, self->priv->v_destroy_func, self->priv->_map);
	result = (ValaIterator*) _tmp0_;
	return result;
}


static gboolean vala_hash_map_value_collection_real_add (ValaCollection* base, gconstpointer value) {
	ValaHashMapValueCollection * self;
	gboolean result = FALSE;
	self = (ValaHashMapValueCollection*) base;
	g_assert_not_reached ();
	return result;
}


static void vala_hash_map_value_collection_real_clear (ValaCollection* base) {
	ValaHashMapValueCollection * self;
	self = (ValaHashMapValueCollection*) base;
	g_assert_not_reached ();
}


static gboolean vala_hash_map_value_collection_real_remove (ValaCollection* base, gconstpointer value) {
	ValaHashMapValueCollection * self;
	gboolean result = FALSE;
	self = (ValaHashMapValueCollection*) base;
	g_assert_not_reached ();
	return result;
}


static gboolean vala_hash_map_value_collection_real_contains (ValaCollection* base, gconstpointer value) {
	ValaHashMapValueCollection * self;
	gboolean result = FALSE;
	ValaIterator* _tmp0_ = NULL;
	ValaIterator* it;
	self = (ValaHashMapValueCollection*) base;
	_tmp0_ = vala_iterable_iterator ((ValaIterable*) self);
	it = _tmp0_;
	while (TRUE) {
		gboolean _tmp1_;
		gpointer _tmp2_ = NULL;
		gpointer _tmp3_;
		gboolean _tmp4_;
		gboolean _tmp5_;
		_tmp1_ = vala_iterator_next (it);
		if (!_tmp1_) {
			break;
		}
		_tmp2_ = vala_iterator_get (it);
		_tmp3_ = _tmp2_;
		_tmp4_ = self->priv->_map->priv->_value_equal_func (_tmp3_, value);
		_tmp5_ = _tmp4_;
		((_tmp3_ == NULL) || (self->priv->v_destroy_func == NULL)) ? NULL : (_tmp3_ = (self->priv->v_destroy_func (_tmp3_), NULL));
		if (_tmp5_) {
			result = TRUE;
			_vala_iterator_unref0 (it);
			return result;
		}
	}
	result = FALSE;
	_vala_iterator_unref0 (it);
	return result;
}


static void vala_hash_map_value_collection_set_map (ValaHashMapValueCollection* self, ValaHashMap* value) {
	ValaHashMap* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_map_ref0 (value);
	_vala_map_unref0 (self->priv->_map);
	self->priv->_map = _tmp0_;
}


static gint vala_hash_map_value_collection_real_get_size (ValaCollection* base) {
	gint result;
	ValaHashMapValueCollection* self;
	gint _tmp0_;
	self = (ValaHashMapValueCollection*) base;
	_tmp0_ = vala_map_get_size ((ValaMap*) self->priv->_map);
	result = _tmp0_;
	return result;
}


static void vala_hash_map_value_collection_class_init (ValaHashMapValueCollectionClass * klass) {
	vala_hash_map_value_collection_parent_class = g_type_class_peek_parent (klass);
	VALA_ITERABLE_CLASS (klass)->finalize = vala_hash_map_value_collection_finalize;
	g_type_class_add_private (klass, sizeof (ValaHashMapValueCollectionPrivate));
	VALA_ITERABLE_CLASS (klass)->get_element_type = vala_hash_map_value_collection_real_get_element_type;
	VALA_ITERABLE_CLASS (klass)->iterator = vala_hash_map_value_collection_real_iterator;
	VALA_COLLECTION_CLASS (klass)->add = vala_hash_map_value_collection_real_add;
	VALA_COLLECTION_CLASS (klass)->clear = vala_hash_map_value_collection_real_clear;
	VALA_COLLECTION_CLASS (klass)->remove = vala_hash_map_value_collection_real_remove;
	VALA_COLLECTION_CLASS (klass)->contains = vala_hash_map_value_collection_real_contains;
	VALA_COLLECTION_CLASS (klass)->get_size = vala_hash_map_value_collection_real_get_size;
}


static void vala_hash_map_value_collection_instance_init (ValaHashMapValueCollection * self) {
	self->priv = VALA_HASH_MAP_VALUE_COLLECTION_GET_PRIVATE (self);
}


static void vala_hash_map_value_collection_finalize (ValaIterable* obj) {
	ValaHashMapValueCollection * self;
	self = VALA_HASH_MAP_VALUE_COLLECTION (obj);
	_vala_map_unref0 (self->priv->_map);
	VALA_ITERABLE_CLASS (vala_hash_map_value_collection_parent_class)->finalize (obj);
}


static GType vala_hash_map_value_collection_get_type (void) {
	static volatile gsize vala_hash_map_value_collection_type_id__volatile = 0;
	if (g_once_init_enter (&vala_hash_map_value_collection_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaHashMapValueCollectionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_hash_map_value_collection_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaHashMapValueCollection), 0, (GInstanceInitFunc) vala_hash_map_value_collection_instance_init, NULL };
		GType vala_hash_map_value_collection_type_id;
		vala_hash_map_value_collection_type_id = g_type_register_static (VALA_TYPE_COLLECTION, "ValaHashMapValueCollection", &g_define_type_info, 0);
		g_once_init_leave (&vala_hash_map_value_collection_type_id__volatile, vala_hash_map_value_collection_type_id);
	}
	return vala_hash_map_value_collection_type_id__volatile;
}


static ValaHashMapValueIterator* vala_hash_map_value_iterator_construct (GType object_type, GType k_type, GBoxedCopyFunc k_dup_func, GDestroyNotify k_destroy_func, GType v_type, GBoxedCopyFunc v_dup_func, GDestroyNotify v_destroy_func, ValaHashMap* map) {
	ValaHashMapValueIterator* self = NULL;
	g_return_val_if_fail (map != NULL, NULL);
	self = (ValaHashMapValueIterator*) vala_iterator_construct (object_type, v_type, (GBoxedCopyFunc) v_dup_func, v_destroy_func);
	self->priv->k_type = k_type;
	self->priv->k_dup_func = k_dup_func;
	self->priv->k_destroy_func = k_destroy_func;
	self->priv->v_type = v_type;
	self->priv->v_dup_func = v_dup_func;
	self->priv->v_destroy_func = v_destroy_func;
	vala_hash_map_value_iterator_set_map (self, map);
	return self;
}


static ValaHashMapValueIterator* vala_hash_map_value_iterator_new (GType k_type, GBoxedCopyFunc k_dup_func, GDestroyNotify k_destroy_func, GType v_type, GBoxedCopyFunc v_dup_func, GDestroyNotify v_destroy_func, ValaHashMap* map) {
	return vala_hash_map_value_iterator_construct (VALA_HASH_MAP_TYPE_VALUE_ITERATOR, k_type, k_dup_func, k_destroy_func, v_type, v_dup_func, v_destroy_func, map);
}


static gboolean vala_hash_map_value_iterator_real_next (ValaIterator* base) {
	ValaHashMapValueIterator * self;
	gboolean result = FALSE;
	self = (ValaHashMapValueIterator*) base;
	if (self->priv->_node != NULL) {
		self->priv->_node = self->priv->_node->next;
	}
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		if (self->priv->_node == NULL) {
			_tmp0_ = (self->priv->_index + 1) < self->priv->_map->priv->_array_size;
		} else {
			_tmp0_ = FALSE;
		}
		if (!_tmp0_) {
			break;
		}
		self->priv->_index++;
		self->priv->_node = self->priv->_map->priv->_nodes[self->priv->_index];
	}
	result = self->priv->_node != NULL;
	return result;
}


static gpointer vala_hash_map_value_iterator_real_get (ValaIterator* base) {
	ValaHashMapValueIterator * self;
	gpointer result = NULL;
	gpointer _tmp0_;
	gconstpointer _tmp1_;
	self = (ValaHashMapValueIterator*) base;
	g_assert (self->priv->_stamp == self->priv->_map->priv->_stamp);
	g_assert (self->priv->_node != NULL);
	_tmp0_ = (_tmp1_ = self->priv->_node->value, ((_tmp1_ == NULL) || (self->priv->v_dup_func == NULL)) ? ((gpointer) _tmp1_) : self->priv->v_dup_func ((gpointer) _tmp1_));
	result = _tmp0_;
	return result;
}


static void vala_hash_map_value_iterator_set_map (ValaHashMapValueIterator* self, ValaHashMap* value) {
	ValaHashMap* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_map_ref0 (value);
	_vala_map_unref0 (self->priv->_map);
	self->priv->_map = _tmp0_;
	self->priv->_stamp = self->priv->_map->priv->_stamp;
}


static void vala_hash_map_value_iterator_class_init (ValaHashMapValueIteratorClass * klass) {
	vala_hash_map_value_iterator_parent_class = g_type_class_peek_parent (klass);
	VALA_ITERATOR_CLASS (klass)->finalize = vala_hash_map_value_iterator_finalize;
	g_type_class_add_private (klass, sizeof (ValaHashMapValueIteratorPrivate));
	VALA_ITERATOR_CLASS (klass)->next = vala_hash_map_value_iterator_real_next;
	VALA_ITERATOR_CLASS (klass)->get = vala_hash_map_value_iterator_real_get;
}


static void vala_hash_map_value_iterator_instance_init (ValaHashMapValueIterator * self) {
	self->priv = VALA_HASH_MAP_VALUE_ITERATOR_GET_PRIVATE (self);
	self->priv->_index = -1;
}


static void vala_hash_map_value_iterator_finalize (ValaIterator* obj) {
	ValaHashMapValueIterator * self;
	self = VALA_HASH_MAP_VALUE_ITERATOR (obj);
	_vala_map_unref0 (self->priv->_map);
	VALA_ITERATOR_CLASS (vala_hash_map_value_iterator_parent_class)->finalize (obj);
}


static GType vala_hash_map_value_iterator_get_type (void) {
	static volatile gsize vala_hash_map_value_iterator_type_id__volatile = 0;
	if (g_once_init_enter (&vala_hash_map_value_iterator_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaHashMapValueIteratorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_hash_map_value_iterator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaHashMapValueIterator), 0, (GInstanceInitFunc) vala_hash_map_value_iterator_instance_init, NULL };
		GType vala_hash_map_value_iterator_type_id;
		vala_hash_map_value_iterator_type_id = g_type_register_static (VALA_TYPE_ITERATOR, "ValaHashMapValueIterator", &g_define_type_info, 0);
		g_once_init_leave (&vala_hash_map_value_iterator_type_id__volatile, vala_hash_map_value_iterator_type_id);
	}
	return vala_hash_map_value_iterator_type_id__volatile;
}


static void vala_hash_map_class_init (ValaHashMapClass * klass) {
	vala_hash_map_parent_class = g_type_class_peek_parent (klass);
	VALA_MAP_CLASS (klass)->finalize = vala_hash_map_finalize;
	g_type_class_add_private (klass, sizeof (ValaHashMapPrivate));
	VALA_MAP_CLASS (klass)->get_keys = vala_hash_map_real_get_keys;
	VALA_MAP_CLASS (klass)->get_values = vala_hash_map_real_get_values;
	VALA_MAP_CLASS (klass)->contains = vala_hash_map_real_contains;
	VALA_MAP_CLASS (klass)->get = vala_hash_map_real_get;
	VALA_MAP_CLASS (klass)->set = vala_hash_map_real_set;
	VALA_MAP_CLASS (klass)->remove = vala_hash_map_real_remove;
	VALA_MAP_CLASS (klass)->clear = vala_hash_map_real_clear;
	VALA_MAP_CLASS (klass)->get_size = vala_hash_map_real_get_size;
}


static void vala_hash_map_instance_init (ValaHashMap * self) {
	self->priv = VALA_HASH_MAP_GET_PRIVATE (self);
	self->priv->_stamp = 0;
}


static void vala_hash_map_finalize (ValaMap* obj) {
	ValaHashMap * self;
	self = VALA_HASH_MAP (obj);
	vala_map_clear ((ValaMap*) self);
	self->priv->_nodes = (_vala_array_free (self->priv->_nodes, self->priv->_nodes_length1, (GDestroyNotify) vala_hash_map_node_free), NULL);
	VALA_MAP_CLASS (vala_hash_map_parent_class)->finalize (obj);
}


/**
 * Hashtable implementation of the Map interface.
 */
GType vala_hash_map_get_type (void) {
	static volatile gsize vala_hash_map_type_id__volatile = 0;
	if (g_once_init_enter (&vala_hash_map_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaHashMapClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_hash_map_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaHashMap), 0, (GInstanceInitFunc) vala_hash_map_instance_init, NULL };
		GType vala_hash_map_type_id;
		vala_hash_map_type_id = g_type_register_static (VALA_TYPE_MAP, "ValaHashMap", &g_define_type_info, 0);
		g_once_init_leave (&vala_hash_map_type_id__volatile, vala_hash_map_type_id);
	}
	return vala_hash_map_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



