# usbredir-0.11.0 - 10 Aug 2021

- !40 Fixes use-after-free on usbredirparser serialization
- !25 Fixes memory leak in usbredirparser
- !32 Fixes build in MacOS related to visibility of exported symbols
- !36 Adds usbredirfilter_free function
- !29 Adds Fuzzing for Filters
- !34 Improvements to usbredirfilter_string_to_rules()

# usbredir-0.10.0 - 27 May 2021

- !23 Fixes 0.9.0 regression in bulk transfer message size
- !20 Drops autotools, only meson is supported now
- !15, !16, !18, !21 Improves fuzzing code base and meson builds
- !17 Fixes libusbredirhost.pc when generated by meson

# usbredir-0.9.0 - 02 Apr 2021

-  !2 Add usbredirect tool with feature parity with usbredirserver
-  !6 Add fuzzer for usbredirparser
- !12 Add MSI installer for usbredirect tool
- !11 Add meson build: autotool will be removed in a future release
-  !5 Limit packet's length to 65 kB
-  !4 Fix wrong up-cast when checking for package's length
- Require LLVM's compiler-rt (optional: for fuzzer)
- Require glib2 >= 2.44 (optional: for usbredirect)
- Deprecate usbredirserver in favor of usbredirect

# usbredir-0.8.0 - 03 Aug 2018

- Source code and bug tracker hosted in Freedesktop's instance of Gitlab
  - https://gitlab.freedesktop.org/spice/usbredir
- usbredirfilter
  - Fix busy wait due endless recursion when `interface_count` is zero
- usbredirhost:
  - Fix leak on error
- usbredirserver:
  - Use 'busnum-devnum' instead of 'usbbus-usbaddr'
  - Add support for bind specific address -4 for ipv4, -6 for ipv6
  - Reject empty vendorid from command line
  - Enable TCP keepalive

# usbredir-0.7.1 - 29 Oct 2015

- usbredirfilter
  - force check to device which had all interfaces skipped. This fix a bug
  which allow a KVM device to be redirect when it should not
- usbredirparser:
  - allow missing capabilities from source host when loading a USB
  redirection stream during a qemu migration
- usbredirhost:
  - new callback to drop isoc packets when application's pending writes buffer
  size is too big; The threshold calculation aims at 10fps as worst case to
  give at least 150ms of continuous data to application.

# usbredir-0.7 - 19 May 2014

- usbredirproto:
  - the `usb_redir_ep_info_header` has been extended with a `max_streams` field,
  this is only send / received if both sides have `usb_redir_cap_bulk_streams`
  - Change `bulk_stream` packet definitions to allow allocating / freeing
  streams on multiple endpoints in one go, technically this is a protocol
  change, but no-one has implemented `usb_redir_cap_bulk_streams` so far, so
  we can safely do this
  - add a `USBREDIR_VERSION` define so applications can test against which
  version they are building
- usbredirparser:
  - fix a bug causing parsing breakage when receiving a hello packet with 64 bit
  id capabiliy and another packet in succession so that they both got parsed
  in one `usbredirparser_do_read` call
- usbredirhost:
  - use `libusb_set_auto_detach_kernel_driver` when available
  - add support for bulk streams, this only gets enabled with libusbx >= 1.0.19
  - stop iso / bulk streams on reset
  - make cancellation handeling more robust
  - reset device on release
- usbredirserver:
  - listen to both ipv4 and ipv6 addresses on ipv6 capable systems

# usbredir-0.6 - 13 December 2012

- usbredirproto:
  - add support for bulk packets with 32 bits length
  - add support for buffered bulk input
- usbredirparser:
  - add support for bulk packets with 32 bits length
  - add support for buffered bulk input
- usbredirhost:
  - add support for bulk packets with 32 bits length
  - queue multiple transfers for interrupt receiving
  - add support for buffered bulk input
  - only apply mult to max-packet-size for isoc high speed endpoints
  - add a do-not-reset device blacklist, populate it with 1210:001c

# usbredir-0.5.3 - 7 October 2012

- usbredirparser:
  - add support for bulk packets longer then 65535 bytes
- usbredirhost:
  - add support for bulk packets longer then 65535 bytes

# usbredir-0.5.2 - 25 September 2012

- usbredirparser:
  - rename libusbredirparser.pc to libusbredirparser-0.5.pc
  This should really have been done with the 0.5 release as API
  compatibility with previous releases was broken there!

# usbredir-0.5.1 - 19 September 2012

- usbredirparser:
  - `usbredirparser_has_data_to_write` now returns the write queue depth, instead
  of only 0 or 1
- usbredirhost:
  - `usbredirhost_has_data_to_write` now returns the write queue depth, instead
  of only 0 or 1
  - when the write queue gets too large, drop isochronous input packets

# usbredir-0.5 - 7 September 2012

- Windows support
- Add support for 64 bit packet ids
- usbredirparser:
  - Add state serialization support
  - API and ABI changed to use 64 bit ids, all users need to be adjusted and
  recompiled for this!!
- usbredirhost:
  - Remove bulk packets time out, this fixes various devices not working
  - Ack packet cancels immediately
  - Now supports 64 bits packet ids
  - Use `libusb_error_name` instead of logging raw error codes
- `usbredirfilter_check` return `-ENOENT` rather then `-EPERM` if no rules match a
 device, this way the caller can differentiate between a deny caused by a
 matching rule, and one caused by there being no matching rules.

# usbredir-0.4.3 - 2 April 2012

- usbredirhost:
  - Don't crash on devices in unconfigured state
  - Restore original device configuration when releasing the device
  - Significantly speed up reset handling
- usbredirserver:
  - Add a manpage

# usbredir-0.4.2 - 6 March 2012

- Add `usb_redir_babble` status code

- usbredirparser:
  - extend the `usb_redir_ep_info` packet header with a `max_packet_size` field
  This new field is only send / received if both sides have the (new)
  `usb_redir_cap_ep_info_max_packet_size` capability

- usbredirhost:
  - Ensure we always re-attach kernel drivers on cleanup
  - Make `set_config` handling more robust
  - A `set_config` or a reset can cause us to loose access to the device, if
  this happens this now gets reported by `usbredirhost_read_guest_data`
  returning `usbredirhost_read_device_lost`

# usbredir-0.4.1 - 25 February 2012

- Brown paper bag release, fix a return without value in a non void function
 which completely breaks usbredir in some cases

# usbredir-0.4 - 22 February 2012

- Add `usb_redir_filter_reject` and `usb_redir_filter_filter` packets and
 an `usb_redir_cap_filter` capability flag
- Add an `usb_redir_device_disconnect_ack` packet and
 an `usb_redir_cap_device_disconnect_ack` capability flag

- usbredirparser:
  - Add an `usbredirparser_have_peer_caps` function

- usbredirhost:
  - Allow re-using a host instance with multiple devices, see the documentation
  for the new `usbredirhost_set_device()` function in usbredirhost.h
  - Quite a few bugfixes


# usbredir-0.3.3 - 12 January 2012

- usbredirparser:
  - add usbredirfilter code, to help apps exclude certain devices from
  redirection. See usbredirfilter.h for details.

- usbredirhost:
  - add a `usbredirhost_check_device_filter` helper function. See usbredirhost.h


# usbredir-0.3.2 - 3 January 2012

- Switched to automake/autoconf/libtool based make system (Christophe Fergeau)

- usbredirparser:
  - limited multi-thread safeness, see [multi-thread in docs](docs/multi-thread.md)
  - extend the device_connect packet header with a device_version field
  This new field is only send / received if both sides have the (new)
  `usb_redir_cap_connect_device_version` capability.
  - Add a hello_func callback which gets called after receiving the hello
  packet from the other side. This can be used to determine when the caps
  from the other side have been received and it thus is safe to call
  `usbredirparser_send_device_connect`.

- usbredirhost:
  - limited multi-thread safeness, see [multi-thread in docs](docs/multi-thread.md)
  - properly handle clear stalls send from the usbguest
  - try to keep our iso buffer size near the target size
  - implement `usb_redir_cap_connect_device_version`


# usbredir-0.3.1 - 18 August 2011

- usbredirparser:
  - add a `usbredirparser_fl_write_cb_owns_buffer` flag
  See the comment in usbredirparser.h above `usbredirparser_write` for details.
  - add a `usbredirparser_free_packet_data` function for symetry with
  `usbredirparser_free_write_buffer`

- usbredirhost:
  - Fix device resets
  - Add a flags parameter to `usbredirhost_open,` this accepts the following flags:
  `usbredirhost_fl_write_cb_owns_buffer`
  - The flags parameter causes an ABI breakage, new soname: libusbredirhost.so.1

- usbredirserver:
  - Fix -v flag


# ubsredir-0.3 - 14 July 2011

- Initial release, start at version 0.3 to match the version of
 the protocol desciption doc [usb-redirection-protocol.md](docs/usb-redirection-protocol.md)
