/*
 * Copyright (C) 2011 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Alex Launi <alex.launi@canonical.com>
 *
 */

using GLib;

namespace Unity.MusicLens {
  
  public class MusicStoreDecadeFilterParser : DecadeFilterParser, MusicStoreFilterParser
  {

    public MusicStoreDecadeFilterParser (DecadeFilterParser parser)
    {
      base (parser.filter as MultiRangeFilter);
    }
    
    public override string parse ()
    {
      StringBuilder builder = new StringBuilder ("&decade=");
      MultiRangeFilter range_filter = filter as MultiRangeFilter;
      string start = range_filter.get_first_active ().id;
      string end = range_filter.get_last_active ().id;
      
      int start_year = int.parse (start);
      int end_year = int.parse (end);
      
      for (; start_year <= end_year; start_year += 10)
      {
	builder.append_printf ("%d,", start_year);
      }
      
      // chop off the last ,
      builder.truncate (builder.len - 1);

      return builder.str;
    }
  }
}