/* banshee-collection.c generated by valac 0.12.1, the Vala compiler
 * generated from banshee-collection.vala, do not modify */

/*
 * Copyright (C) 2011 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Alex Launi <alex.launi@canonical.com>
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <sqlite3.h>
#include <stdlib.h>
#include <string.h>
#include <unity.h>
#include <dee.h>
#include <gee.h>
#include <gio/gio.h>


#define UNITY_MUSIC_LENS_TYPE_BANSHEE_COLLECTION (unity_music_lens_banshee_collection_get_type ())
#define UNITY_MUSIC_LENS_BANSHEE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_MUSIC_LENS_TYPE_BANSHEE_COLLECTION, UnityMusicLensBansheeCollection))
#define UNITY_MUSIC_LENS_BANSHEE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_MUSIC_LENS_TYPE_BANSHEE_COLLECTION, UnityMusicLensBansheeCollectionClass))
#define UNITY_MUSIC_LENS_IS_BANSHEE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_MUSIC_LENS_TYPE_BANSHEE_COLLECTION))
#define UNITY_MUSIC_LENS_IS_BANSHEE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_MUSIC_LENS_TYPE_BANSHEE_COLLECTION))
#define UNITY_MUSIC_LENS_BANSHEE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_MUSIC_LENS_TYPE_BANSHEE_COLLECTION, UnityMusicLensBansheeCollectionClass))

typedef struct _UnityMusicLensBansheeCollection UnityMusicLensBansheeCollection;
typedef struct _UnityMusicLensBansheeCollectionClass UnityMusicLensBansheeCollectionClass;
typedef struct _UnityMusicLensBansheeCollectionPrivate UnityMusicLensBansheeCollectionPrivate;
#define _sqlite3_close0(var) ((var == NULL) ? NULL : (var = (sqlite3_close (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define UNITY_MUSIC_LENS_TYPE_FILTER_PARSER (unity_music_lens_filter_parser_get_type ())
#define UNITY_MUSIC_LENS_FILTER_PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_MUSIC_LENS_TYPE_FILTER_PARSER, UnityMusicLensFilterParser))
#define UNITY_MUSIC_LENS_FILTER_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_MUSIC_LENS_TYPE_FILTER_PARSER, UnityMusicLensFilterParserClass))
#define UNITY_MUSIC_LENS_IS_FILTER_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_MUSIC_LENS_TYPE_FILTER_PARSER))
#define UNITY_MUSIC_LENS_IS_FILTER_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_MUSIC_LENS_TYPE_FILTER_PARSER))
#define UNITY_MUSIC_LENS_FILTER_PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_MUSIC_LENS_TYPE_FILTER_PARSER, UnityMusicLensFilterParserClass))

typedef struct _UnityMusicLensFilterParser UnityMusicLensFilterParser;
typedef struct _UnityMusicLensFilterParserClass UnityMusicLensFilterParserClass;
#define _sqlite3_finalize0(var) ((var == NULL) ? NULL : (var = (sqlite3_finalize (var), NULL)))

#define UNITY_MUSIC_LENS_TYPE_TRACK (unity_music_lens_track_get_type ())
#define UNITY_MUSIC_LENS_TRACK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_MUSIC_LENS_TYPE_TRACK, UnityMusicLensTrack))
#define UNITY_MUSIC_LENS_TRACK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_MUSIC_LENS_TYPE_TRACK, UnityMusicLensTrackClass))
#define UNITY_MUSIC_LENS_IS_TRACK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_MUSIC_LENS_TYPE_TRACK))
#define UNITY_MUSIC_LENS_IS_TRACK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_MUSIC_LENS_TYPE_TRACK))
#define UNITY_MUSIC_LENS_TRACK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_MUSIC_LENS_TYPE_TRACK, UnityMusicLensTrackClass))

typedef struct _UnityMusicLensTrack UnityMusicLensTrack;
typedef struct _UnityMusicLensTrackClass UnityMusicLensTrackClass;

#define UNITY_MUSIC_LENS_TYPE_ALBUM (unity_music_lens_album_get_type ())
#define UNITY_MUSIC_LENS_ALBUM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_MUSIC_LENS_TYPE_ALBUM, UnityMusicLensAlbum))
#define UNITY_MUSIC_LENS_ALBUM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_MUSIC_LENS_TYPE_ALBUM, UnityMusicLensAlbumClass))
#define UNITY_MUSIC_LENS_IS_ALBUM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_MUSIC_LENS_TYPE_ALBUM))
#define UNITY_MUSIC_LENS_IS_ALBUM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_MUSIC_LENS_TYPE_ALBUM))
#define UNITY_MUSIC_LENS_ALBUM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_MUSIC_LENS_TYPE_ALBUM, UnityMusicLensAlbumClass))

typedef struct _UnityMusicLensAlbum UnityMusicLensAlbum;
typedef struct _UnityMusicLensAlbumClass UnityMusicLensAlbumClass;
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

#define UNITY_MUSIC_LENS_TYPE_BANSHEE_FILTER_PARSER (unity_music_lens_banshee_filter_parser_get_type ())
#define UNITY_MUSIC_LENS_BANSHEE_FILTER_PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_MUSIC_LENS_TYPE_BANSHEE_FILTER_PARSER, UnityMusicLensBansheeFilterParser))
#define UNITY_MUSIC_LENS_IS_BANSHEE_FILTER_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_MUSIC_LENS_TYPE_BANSHEE_FILTER_PARSER))
#define UNITY_MUSIC_LENS_BANSHEE_FILTER_PARSER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), UNITY_MUSIC_LENS_TYPE_BANSHEE_FILTER_PARSER, UnityMusicLensBansheeFilterParserIface))

typedef struct _UnityMusicLensBansheeFilterParser UnityMusicLensBansheeFilterParser;
typedef struct _UnityMusicLensBansheeFilterParserIface UnityMusicLensBansheeFilterParserIface;

#define UNITY_MUSIC_LENS_TYPE_GENRE_FILTER_PARSER (unity_music_lens_genre_filter_parser_get_type ())
#define UNITY_MUSIC_LENS_GENRE_FILTER_PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_MUSIC_LENS_TYPE_GENRE_FILTER_PARSER, UnityMusicLensGenreFilterParser))
#define UNITY_MUSIC_LENS_GENRE_FILTER_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_MUSIC_LENS_TYPE_GENRE_FILTER_PARSER, UnityMusicLensGenreFilterParserClass))
#define UNITY_MUSIC_LENS_IS_GENRE_FILTER_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_MUSIC_LENS_TYPE_GENRE_FILTER_PARSER))
#define UNITY_MUSIC_LENS_IS_GENRE_FILTER_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_MUSIC_LENS_TYPE_GENRE_FILTER_PARSER))
#define UNITY_MUSIC_LENS_GENRE_FILTER_PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_MUSIC_LENS_TYPE_GENRE_FILTER_PARSER, UnityMusicLensGenreFilterParserClass))

typedef struct _UnityMusicLensGenreFilterParser UnityMusicLensGenreFilterParser;
typedef struct _UnityMusicLensGenreFilterParserClass UnityMusicLensGenreFilterParserClass;

#define UNITY_MUSIC_LENS_TYPE_BANSHEE_GENRE_FILTER_PARSER (unity_music_lens_banshee_genre_filter_parser_get_type ())
#define UNITY_MUSIC_LENS_BANSHEE_GENRE_FILTER_PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_MUSIC_LENS_TYPE_BANSHEE_GENRE_FILTER_PARSER, UnityMusicLensBansheeGenreFilterParser))
#define UNITY_MUSIC_LENS_BANSHEE_GENRE_FILTER_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_MUSIC_LENS_TYPE_BANSHEE_GENRE_FILTER_PARSER, UnityMusicLensBansheeGenreFilterParserClass))
#define UNITY_MUSIC_LENS_IS_BANSHEE_GENRE_FILTER_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_MUSIC_LENS_TYPE_BANSHEE_GENRE_FILTER_PARSER))
#define UNITY_MUSIC_LENS_IS_BANSHEE_GENRE_FILTER_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_MUSIC_LENS_TYPE_BANSHEE_GENRE_FILTER_PARSER))
#define UNITY_MUSIC_LENS_BANSHEE_GENRE_FILTER_PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_MUSIC_LENS_TYPE_BANSHEE_GENRE_FILTER_PARSER, UnityMusicLensBansheeGenreFilterParserClass))

typedef struct _UnityMusicLensBansheeGenreFilterParser UnityMusicLensBansheeGenreFilterParser;
typedef struct _UnityMusicLensBansheeGenreFilterParserClass UnityMusicLensBansheeGenreFilterParserClass;

#define UNITY_MUSIC_LENS_TYPE_DECADE_FILTER_PARSER (unity_music_lens_decade_filter_parser_get_type ())
#define UNITY_MUSIC_LENS_DECADE_FILTER_PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_MUSIC_LENS_TYPE_DECADE_FILTER_PARSER, UnityMusicLensDecadeFilterParser))
#define UNITY_MUSIC_LENS_DECADE_FILTER_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_MUSIC_LENS_TYPE_DECADE_FILTER_PARSER, UnityMusicLensDecadeFilterParserClass))
#define UNITY_MUSIC_LENS_IS_DECADE_FILTER_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_MUSIC_LENS_TYPE_DECADE_FILTER_PARSER))
#define UNITY_MUSIC_LENS_IS_DECADE_FILTER_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_MUSIC_LENS_TYPE_DECADE_FILTER_PARSER))
#define UNITY_MUSIC_LENS_DECADE_FILTER_PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_MUSIC_LENS_TYPE_DECADE_FILTER_PARSER, UnityMusicLensDecadeFilterParserClass))

typedef struct _UnityMusicLensDecadeFilterParser UnityMusicLensDecadeFilterParser;
typedef struct _UnityMusicLensDecadeFilterParserClass UnityMusicLensDecadeFilterParserClass;

#define UNITY_MUSIC_LENS_TYPE_BANSHEE_DECADE_FILTER_PARSER (unity_music_lens_banshee_decade_filter_parser_get_type ())
#define UNITY_MUSIC_LENS_BANSHEE_DECADE_FILTER_PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_MUSIC_LENS_TYPE_BANSHEE_DECADE_FILTER_PARSER, UnityMusicLensBansheeDecadeFilterParser))
#define UNITY_MUSIC_LENS_BANSHEE_DECADE_FILTER_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_MUSIC_LENS_TYPE_BANSHEE_DECADE_FILTER_PARSER, UnityMusicLensBansheeDecadeFilterParserClass))
#define UNITY_MUSIC_LENS_IS_BANSHEE_DECADE_FILTER_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_MUSIC_LENS_TYPE_BANSHEE_DECADE_FILTER_PARSER))
#define UNITY_MUSIC_LENS_IS_BANSHEE_DECADE_FILTER_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_MUSIC_LENS_TYPE_BANSHEE_DECADE_FILTER_PARSER))
#define UNITY_MUSIC_LENS_BANSHEE_DECADE_FILTER_PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_MUSIC_LENS_TYPE_BANSHEE_DECADE_FILTER_PARSER, UnityMusicLensBansheeDecadeFilterParserClass))

typedef struct _UnityMusicLensBansheeDecadeFilterParser UnityMusicLensBansheeDecadeFilterParser;
typedef struct _UnityMusicLensBansheeDecadeFilterParserClass UnityMusicLensBansheeDecadeFilterParserClass;

typedef enum  {
	UNITY_MUSIC_LENS_DATABASE_ERROR_FAILED_TO_OPEN
} UnityMusicLensDatabaseError;
#define UNITY_MUSIC_LENS_DATABASE_ERROR unity_music_lens_database_error_quark ()
struct _UnityMusicLensBansheeCollection {
	GObject parent_instance;
	UnityMusicLensBansheeCollectionPrivate * priv;
};

struct _UnityMusicLensBansheeCollectionClass {
	GObjectClass parent_class;
};

struct _UnityMusicLensBansheeCollectionPrivate {
	sqlite3* db;
};

struct _UnityMusicLensBansheeFilterParserIface {
	GTypeInterface parent_iface;
};


static gpointer unity_music_lens_banshee_collection_parent_class = NULL;

GQuark unity_music_lens_database_error_quark (void);
GType unity_music_lens_banshee_collection_get_type (void) G_GNUC_CONST;
#define UNITY_MUSIC_LENS_BANSHEE_COLLECTION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), UNITY_MUSIC_LENS_TYPE_BANSHEE_COLLECTION, UnityMusicLensBansheeCollectionPrivate))
enum  {
	UNITY_MUSIC_LENS_BANSHEE_COLLECTION_DUMMY_PROPERTY
};
#define UNITY_MUSIC_LENS_BANSHEE_COLLECTION_MAX_RESULTS 100
UnityMusicLensBansheeCollection* unity_music_lens_banshee_collection_new (GError** error);
UnityMusicLensBansheeCollection* unity_music_lens_banshee_collection_construct (GType object_type, GError** error);
GType unity_music_lens_filter_parser_get_type (void) G_GNUC_CONST;
void unity_music_lens_banshee_collection_search (UnityMusicLensBansheeCollection* self, UnityLensSearch* search, DeeModel* results_model, GList* filters, gint max_results);
static gchar* unity_music_lens_banshee_collection_build_sql_from_filters (UnityMusicLensBansheeCollection* self, GList* filters);
static gint unity_music_lens_banshee_collection_execute_sql (UnityMusicLensBansheeCollection* self, const gchar* sql, sqlite3_stmt** stmt);
UnityMusicLensTrack* unity_music_lens_track_new (void);
UnityMusicLensTrack* unity_music_lens_track_construct (GType object_type);
GType unity_music_lens_track_get_type (void) G_GNUC_CONST;
void unity_music_lens_track_set_title (UnityMusicLensTrack* self, const gchar* value);
void unity_music_lens_track_set_artist (UnityMusicLensTrack* self, const gchar* value);
void unity_music_lens_track_set_uri (UnityMusicLensTrack* self, const gchar* value);
void unity_music_lens_track_set_mime_type (UnityMusicLensTrack* self, const gchar* value);
void unity_music_lens_track_set_artwork_path (UnityMusicLensTrack* self, const gchar* value);
UnityMusicLensAlbum* unity_music_lens_album_new (void);
UnityMusicLensAlbum* unity_music_lens_album_construct (GType object_type);
GType unity_music_lens_album_get_type (void) G_GNUC_CONST;
void unity_music_lens_album_set_title (UnityMusicLensAlbum* self, const gchar* value);
void unity_music_lens_album_set_artist (UnityMusicLensAlbum* self, const gchar* value);
const gchar* unity_music_lens_album_get_artist (UnityMusicLensAlbum* self);
const gchar* unity_music_lens_album_get_title (UnityMusicLensAlbum* self);
void unity_music_lens_album_set_uri (UnityMusicLensAlbum* self, const gchar* value);
void unity_music_lens_album_set_artwork_path (UnityMusicLensAlbum* self, const gchar* value);
const gchar* unity_music_lens_track_get_uri (UnityMusicLensTrack* self);
const gchar* unity_music_lens_track_get_artwork_path (UnityMusicLensTrack* self);
const gchar* unity_music_lens_track_get_mime_type (UnityMusicLensTrack* self);
const gchar* unity_music_lens_track_get_title (UnityMusicLensTrack* self);
const gchar* unity_music_lens_track_get_artist (UnityMusicLensTrack* self);
gchar** unity_music_lens_banshee_collection_get_track_uris (UnityMusicLensBansheeCollection* self, UnityMusicLensAlbum* album, int* result_length1);
const gchar* unity_music_lens_album_get_uri (UnityMusicLensAlbum* self);
const gchar* unity_music_lens_album_get_artwork_path (UnityMusicLensAlbum* self);
GType unity_music_lens_banshee_filter_parser_get_type (void) G_GNUC_CONST;
GType unity_music_lens_genre_filter_parser_get_type (void) G_GNUC_CONST;
UnityMusicLensBansheeGenreFilterParser* unity_music_lens_banshee_genre_filter_parser_new (UnityMusicLensGenreFilterParser* parser);
UnityMusicLensBansheeGenreFilterParser* unity_music_lens_banshee_genre_filter_parser_construct (GType object_type, UnityMusicLensGenreFilterParser* parser);
GType unity_music_lens_banshee_genre_filter_parser_get_type (void) G_GNUC_CONST;
GType unity_music_lens_decade_filter_parser_get_type (void) G_GNUC_CONST;
UnityMusicLensBansheeDecadeFilterParser* unity_music_lens_banshee_decade_filter_parser_new (UnityMusicLensDecadeFilterParser* parser);
UnityMusicLensBansheeDecadeFilterParser* unity_music_lens_banshee_decade_filter_parser_construct (GType object_type, UnityMusicLensDecadeFilterParser* parser);
GType unity_music_lens_banshee_decade_filter_parser_get_type (void) G_GNUC_CONST;
gchar* unity_music_lens_filter_parser_parse (UnityMusicLensFilterParser* self);
static void unity_music_lens_banshee_collection_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


GQuark unity_music_lens_database_error_quark (void) {
	return g_quark_from_static_string ("unity_music_lens_database_error-quark");
}


UnityMusicLensBansheeCollection* unity_music_lens_banshee_collection_construct (GType object_type, GError** error) {
	UnityMusicLensBansheeCollection * self = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	sqlite3* _tmp3_ = NULL;
	gint _tmp4_;
	gint _tmp5_;
	gint rc;
	GError * _inner_error_ = NULL;
	self = (UnityMusicLensBansheeCollection*) g_object_new (object_type, NULL);
	_tmp0_ = g_get_user_config_dir ();
	_tmp1_ = g_strdup_printf ("%s/banshee-1/banshee.db", _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp4_ = sqlite3_open (_tmp2_, &_tmp3_);
	_sqlite3_close0 (self->priv->db);
	self->priv->db = _tmp3_;
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp2_);
	rc = _tmp5_;
	if (rc != SQLITE_OK) {
		const gchar* _tmp6_ = NULL;
		GError* _tmp7_ = NULL;
		_tmp6_ = sqlite3_errmsg (self->priv->db);
		g_printerr ("failed to open db, %d, %s\n", rc, _tmp6_);
		_tmp7_ = g_error_new_literal (UNITY_MUSIC_LENS_DATABASE_ERROR, UNITY_MUSIC_LENS_DATABASE_ERROR_FAILED_TO_OPEN, "Failed to open banshee database");
		_inner_error_ = _tmp7_;
		if (_inner_error_->domain == UNITY_MUSIC_LENS_DATABASE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	return self;
}


UnityMusicLensBansheeCollection* unity_music_lens_banshee_collection_new (GError** error) {
	return unity_music_lens_banshee_collection_construct (UNITY_MUSIC_LENS_TYPE_BANSHEE_COLLECTION, error);
}


/**
     * Performs a search on the banshee db
     */
void unity_music_lens_banshee_collection_search (UnityMusicLensBansheeCollection* self, UnityLensSearch* search, DeeModel* results_model, GList* filters, gint max_results) {
	static const gint TRACK_TITLE = 0;
	static const gint TRACK_URI = 1;
	static const gint TRACK_MIMETYPE = 2;
	static const gint ALBUM_TITLE = 3;
	static const gint ALBUM_ARTWORKID = 4;
	static const gint ARTIST_NAME = 5;
	gint rc;
	sqlite3_stmt* stmt = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* album_art_dir;
	GeeTreeSet* _tmp2_ = NULL;
	GeeTreeSet* albums;
	gchar* _tmp3_ = NULL;
	gchar* filters_sql;
	gint _tmp4_ = 0;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* sql;
	sqlite3_stmt* _tmp9_ = NULL;
	gint _tmp10_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (results_model != NULL);
	rc = 0;
	_tmp0_ = g_get_user_cache_dir ();
	_tmp1_ = g_strdup_printf ("%s/media-art/", _tmp0_);
	album_art_dir = _tmp1_;
	_tmp2_ = gee_tree_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
	albums = _tmp2_;
	_tmp3_ = unity_music_lens_banshee_collection_build_sql_from_filters (self, filters);
	filters_sql = _tmp3_;
	if (max_results == (-1)) {
		_tmp4_ = UNITY_MUSIC_LENS_BANSHEE_COLLECTION_MAX_RESULTS;
	} else {
		_tmp4_ = max_results;
	}
	_tmp5_ = unity_lens_search_get_search_string (search);
	_tmp6_ = unity_lens_search_get_search_string (search);
	_tmp7_ = unity_lens_search_get_search_string (search);
	_tmp8_ = g_strdup_printf ("SELECT CoreTracks.Title, CoreTracks.Uri, CoreTracks.MimeType, CoreAlbu" \
"ms.Title, CoreAlbums.ArtworkID, CoreArtists.Name                      " \
"FROM CoreTracks \n" \
"                      CROSS JOIN CoreArtists, CoreAlbums \n" \
"                      WHERE CoreArtists.ArtistID = CoreTracks.ArtistID" \
" \n" \
"                                                   AND CoreAlbums.Albu" \
"mID = CoreTracks.AlbumID \n" \
"                                                   AND CoreTracks.Prim" \
"arySourceID = 1 \n" \
"\t\t\t\t\t\t   AND ((CoreArtists.NameLowered LIKE '%%%s%%' ESCAPE '\\'" \
" \n" \
"\t\t\t\t\t\t  \t AND CoreArtists.NameLowered IS NOT NULL) \n" \
"\t\t\t\t\t\t        OR (CoreAlbums.TitleLowered LIKE '%%%s%%' ESCAPE '" \
"\\' \n" \
"\t\t\t\t\t\t  \t    AND CoreAlbums.TitleLowered IS NOT NULL) \n" \
"\t\t\t\t\t\t  \tOR (CoreTracks.TitleLowered LIKE '%%%s%%' ESCAPE '\\' " \
"\n" \
"\t\t\t\t\t\t  \t    AND CoreTracks.TitleLowered IS NOT NULL)\n" \
"                                                       )\n" \
"                                 %s\n" \
"                      ORDER BY CoreTracks.Score DESC\n" \
"                      LIMIT 0, %d;", _tmp5_, _tmp6_, _tmp7_, filters_sql, _tmp4_);
	sql = _tmp8_;
	_tmp10_ = unity_music_lens_banshee_collection_execute_sql (self, sql, &_tmp9_);
	_sqlite3_finalize0 (stmt);
	stmt = _tmp9_;
	rc = _tmp10_;
	if (stmt == NULL) {
		_g_free0 (sql);
		_g_free0 (filters_sql);
		_g_object_unref0 (albums);
		_g_free0 (album_art_dir);
		_sqlite3_finalize0 (stmt);
		return;
	}
	{
		gboolean _tmp11_;
		_tmp11_ = TRUE;
		while (TRUE) {
			gint _tmp12_;
			if (!_tmp11_) {
				if (!(rc == SQLITE_ROW)) {
					break;
				}
			}
			_tmp11_ = FALSE;
			_tmp12_ = sqlite3_step (stmt);
			rc = _tmp12_;
			switch (rc) {
				case SQLITE_DONE:
				{
					break;
				}
				case SQLITE_ROW:
				{
					const gchar* _tmp13_ = NULL;
					gchar* _tmp14_ = NULL;
					gchar* artwork_path;
					GFile* _tmp15_ = NULL;
					GFile* artwork_file;
					gboolean _tmp16_;
					UnityMusicLensTrack* _tmp18_ = NULL;
					UnityMusicLensTrack* track;
					const gchar* _tmp19_ = NULL;
					const gchar* _tmp20_ = NULL;
					const gchar* _tmp21_ = NULL;
					const gchar* _tmp22_ = NULL;
					UnityMusicLensAlbum* _tmp23_ = NULL;
					UnityMusicLensAlbum* album;
					const gchar* _tmp24_ = NULL;
					const gchar* _tmp25_ = NULL;
					const gchar* _tmp26_ = NULL;
					const gchar* _tmp27_ = NULL;
					gchar* _tmp28_ = NULL;
					gchar* _tmp29_;
					const gchar* _tmp30_ = NULL;
					const gchar* _tmp31_ = NULL;
					const gchar* _tmp32_ = NULL;
					const gchar* _tmp33_ = NULL;
					const gchar* _tmp34_ = NULL;
					const gchar* _tmp35_ = NULL;
					const gchar* _tmp36_ = NULL;
					const gchar* _tmp37_ = NULL;
					gchar* _tmp38_;
					gchar* _tmp39_;
					gboolean _tmp40_;
					gboolean _tmp41_;
					_tmp13_ = sqlite3_column_text (stmt, ALBUM_ARTWORKID);
					_tmp14_ = g_strdup_printf ("%s/%s.jpg", album_art_dir, _tmp13_);
					artwork_path = _tmp14_;
					_tmp15_ = g_file_new_for_path (artwork_path);
					artwork_file = _tmp15_;
					_tmp16_ = g_file_query_exists (artwork_file, NULL);
					if (!_tmp16_) {
						gchar* _tmp17_;
						_tmp17_ = g_strdup ("audio-x-generic");
						_g_free0 (artwork_path);
						artwork_path = _tmp17_;
					}
					_tmp18_ = unity_music_lens_track_new ();
					track = _tmp18_;
					_tmp19_ = sqlite3_column_text (stmt, TRACK_TITLE);
					unity_music_lens_track_set_title (track, _tmp19_);
					_tmp20_ = sqlite3_column_text (stmt, ARTIST_NAME);
					unity_music_lens_track_set_artist (track, _tmp20_);
					_tmp21_ = sqlite3_column_text (stmt, TRACK_URI);
					unity_music_lens_track_set_uri (track, _tmp21_);
					_tmp22_ = sqlite3_column_text (stmt, TRACK_MIMETYPE);
					unity_music_lens_track_set_mime_type (track, _tmp22_);
					unity_music_lens_track_set_artwork_path (track, artwork_path);
					_tmp23_ = unity_music_lens_album_new ();
					album = _tmp23_;
					_tmp24_ = sqlite3_column_text (stmt, ALBUM_TITLE);
					unity_music_lens_album_set_title (album, _tmp24_);
					_tmp25_ = sqlite3_column_text (stmt, ARTIST_NAME);
					unity_music_lens_album_set_artist (album, _tmp25_);
					_tmp26_ = unity_music_lens_album_get_artist (album);
					_tmp27_ = unity_music_lens_album_get_title (album);
					_tmp28_ = g_strdup_printf ("album://%s/%s", _tmp26_, _tmp27_);
					_tmp29_ = _tmp28_;
					unity_music_lens_album_set_uri (album, _tmp29_);
					_g_free0 (_tmp29_);
					unity_music_lens_album_set_artwork_path (album, artwork_path);
					_tmp30_ = unity_music_lens_track_get_uri (track);
					_tmp31_ = unity_music_lens_track_get_artwork_path (track);
					_tmp32_ = unity_music_lens_track_get_mime_type (track);
					_tmp33_ = unity_music_lens_track_get_title (track);
					_tmp34_ = unity_music_lens_track_get_artist (track);
					_tmp35_ = unity_music_lens_track_get_uri (track);
					dee_model_append (results_model, _tmp30_, _tmp31_, 0, _tmp32_, _tmp33_, _tmp34_, _tmp35_, NULL);
					_tmp36_ = unity_music_lens_album_get_artist (album);
					_tmp37_ = unity_music_lens_album_get_title (album);
					_tmp38_ = g_strconcat (_tmp36_, _tmp37_, NULL);
					_tmp39_ = _tmp38_;
					_tmp40_ = gee_abstract_collection_add ((GeeAbstractCollection*) albums, _tmp39_);
					_tmp41_ = _tmp40_;
					_g_free0 (_tmp39_);
					if (_tmp41_) {
						GString* _tmp42_ = NULL;
						GString* uri_list_builder;
						gint _tmp43_;
						gchar** _tmp44_ = NULL;
						const gchar* _tmp46_ = NULL;
						const gchar* _tmp47_ = NULL;
						const gchar* _tmp48_ = NULL;
						const gchar* _tmp49_ = NULL;
						_tmp42_ = g_string_new ("");
						uri_list_builder = _tmp42_;
						_tmp44_ = unity_music_lens_banshee_collection_get_track_uris (self, album, &_tmp43_);
						{
							gchar** uri_collection;
							int uri_collection_length1;
							int uri_it;
							uri_collection = _tmp44_;
							uri_collection_length1 = _tmp43_;
							for (uri_it = 0; uri_it < _tmp43_; uri_it = uri_it + 1) {
								gchar* _tmp45_;
								gchar* uri;
								_tmp45_ = g_strdup (uri_collection[uri_it]);
								uri = _tmp45_;
								{
									g_string_append (uri_list_builder, "'");
									g_string_append (uri_list_builder, uri);
									g_string_append (uri_list_builder, "' ");
									_g_free0 (uri);
								}
							}
							uri_collection = (_vala_array_free (uri_collection, uri_collection_length1, (GDestroyNotify) g_free), NULL);
						}
						_tmp46_ = unity_music_lens_album_get_uri (album);
						_tmp47_ = unity_music_lens_album_get_artwork_path (album);
						_tmp48_ = unity_music_lens_album_get_title (album);
						_tmp49_ = unity_music_lens_album_get_artist (album);
						dee_model_append (results_model, _tmp46_, _tmp47_, 1, "audio/mp3", _tmp48_, _tmp49_, uri_list_builder->str, NULL);
						_g_string_free0 (uri_list_builder);
					}
					_g_object_unref0 (album);
					_g_object_unref0 (track);
					_g_object_unref0 (artwork_file);
					_g_free0 (artwork_path);
					break;
				}
				default:
				{
					break;
				}
			}
		}
	}
	_g_free0 (sql);
	_g_free0 (filters_sql);
	_g_object_unref0 (albums);
	_g_free0 (album_art_dir);
	_sqlite3_finalize0 (stmt);
}


/**
     * returns an array like {uri://, uri://, ...}
     */
gchar** unity_music_lens_banshee_collection_get_track_uris (UnityMusicLensBansheeCollection* self, UnityMusicLensAlbum* album, int* result_length1) {
	gchar** result = NULL;
	static const gint URI_COLUMN = 0;
	gint rc = 0;
	sqlite3_stmt* stmt = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* sql;
	sqlite3_stmt* _tmp3_ = NULL;
	gint _tmp4_;
	GeeArrayList* _tmp5_ = NULL;
	GeeArrayList* uris;
	gint _tmp9_;
	gpointer* _tmp10_ = NULL;
	gchar** _tmp11_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (album != NULL, NULL);
	_tmp0_ = unity_music_lens_album_get_title (album);
	_tmp1_ = unity_music_lens_album_get_artist (album);
	_tmp2_ = g_strdup_printf ("SELECT CoreTracks.Uri \n" \
"                    FROM CoreTracks \n" \
"                    CROSS JOIN CoreAlbums, CoreArtists \n" \
"                    WHERE CoreArtists.ArtistID = CoreTracks.ArtistID \n" \
"                          AND CoreAlbums.AlbumID = CoreTracks.AlbumID " \
"\n" \
"                          AND CoreAlbums.Title IS '%s'\n" \
"                          AND CoreArtists.Name IS '%s'\n" \
"                          AND CoreTracks.URI IS NOT NULL\n" \
"                    ORDER BY CoreTracks.TrackNumber ASC", _tmp0_, _tmp1_);
	sql = _tmp2_;
	_tmp4_ = unity_music_lens_banshee_collection_execute_sql (self, sql, &_tmp3_);
	_sqlite3_finalize0 (stmt);
	stmt = _tmp3_;
	rc = _tmp4_;
	_tmp5_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
	uris = _tmp5_;
	{
		gboolean _tmp6_;
		_tmp6_ = TRUE;
		while (TRUE) {
			gint _tmp7_;
			if (!_tmp6_) {
				if (!(rc == SQLITE_ROW)) {
					break;
				}
			}
			_tmp6_ = FALSE;
			_tmp7_ = sqlite3_step (stmt);
			rc = _tmp7_;
			switch (rc) {
				case SQLITE_DONE:
				{
					break;
				}
				case SQLITE_ROW:
				{
					const gchar* _tmp8_ = NULL;
					_tmp8_ = sqlite3_column_text (stmt, URI_COLUMN);
					gee_abstract_collection_add ((GeeAbstractCollection*) uris, _tmp8_);
					break;
				}
				default:
				{
					break;
				}
			}
		}
	}
	_tmp10_ = gee_abstract_collection_to_array ((GeeAbstractCollection*) uris, &_tmp9_);
	_tmp11_ = _tmp10_;
	if (result_length1) {
		*result_length1 = _tmp9_;
	}
	result = _tmp11_;
	_g_object_unref0 (uris);
	_g_free0 (sql);
	_sqlite3_finalize0 (stmt);
	return result;
}


/**
     * returns a string like "AND (Table.Column IS filter OR Table.OtherCol IS filter2) 
     * AND (Table.OtherColAgain IS AnotherFilter)" 
     */
static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gchar* unity_music_lens_banshee_collection_build_sql_from_filters (UnityMusicLensBansheeCollection* self, GList* filters) {
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	GString* _tmp3_ = NULL;
	GString* builder;
	gchar* _tmp11_;
	g_return_val_if_fail (self != NULL, NULL);
	if (filters == NULL) {
		_tmp0_ = TRUE;
	} else {
		guint _tmp1_;
		_tmp1_ = g_list_length (filters);
		_tmp0_ = _tmp1_ == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup ("");
		result = _tmp2_;
		return result;
	}
	_tmp3_ = g_string_new ("");
	builder = _tmp3_;
	{
		GList* parser_collection;
		GList* parser_it;
		parser_collection = filters;
		for (parser_it = parser_collection; parser_it != NULL; parser_it = parser_it->next) {
			UnityMusicLensFilterParser* _tmp4_;
			UnityMusicLensFilterParser* parser;
			_tmp4_ = _g_object_ref0 ((UnityMusicLensFilterParser*) parser_it->data);
			parser = _tmp4_;
			{
				UnityMusicLensBansheeFilterParser* bparser = NULL;
				gchar* _tmp9_ = NULL;
				gchar* parsed;
				gboolean _tmp10_ = FALSE;
				if (UNITY_MUSIC_LENS_IS_GENRE_FILTER_PARSER (parser)) {
					UnityMusicLensFilterParser* _tmp5_;
					UnityMusicLensBansheeGenreFilterParser* _tmp6_ = NULL;
					_tmp5_ = parser;
					_tmp6_ = unity_music_lens_banshee_genre_filter_parser_new (UNITY_MUSIC_LENS_IS_GENRE_FILTER_PARSER (_tmp5_) ? ((UnityMusicLensGenreFilterParser*) _tmp5_) : NULL);
					_g_object_unref0 (bparser);
					bparser = (UnityMusicLensBansheeFilterParser*) _tmp6_;
				} else {
					if (UNITY_MUSIC_LENS_IS_DECADE_FILTER_PARSER (parser)) {
						UnityMusicLensFilterParser* _tmp7_;
						UnityMusicLensBansheeDecadeFilterParser* _tmp8_ = NULL;
						_tmp7_ = parser;
						_tmp8_ = unity_music_lens_banshee_decade_filter_parser_new (UNITY_MUSIC_LENS_IS_DECADE_FILTER_PARSER (_tmp7_) ? ((UnityMusicLensDecadeFilterParser*) _tmp7_) : NULL);
						_g_object_unref0 (bparser);
						bparser = (UnityMusicLensBansheeFilterParser*) _tmp8_;
					} else {
						g_warning ("banshee-collection.vala:202: Recieved an unimplemented filter type");
						_g_object_unref0 (bparser);
						_g_object_unref0 (parser);
						continue;
					}
				}
				_tmp9_ = unity_music_lens_filter_parser_parse ((UnityMusicLensFilterParser*) bparser);
				parsed = _tmp9_;
				if (parsed == NULL) {
					_tmp10_ = TRUE;
				} else {
					_tmp10_ = g_strcmp0 (parsed, "") == 0;
				}
				if (_tmp10_) {
					_g_free0 (parsed);
					_g_object_unref0 (bparser);
					_g_object_unref0 (parser);
					continue;
				}
				g_string_append (builder, " AND ");
				g_string_append (builder, parsed);
				_g_free0 (parsed);
				_g_object_unref0 (bparser);
				_g_object_unref0 (parser);
			}
		}
	}
	g_string_append (builder, " ");
	_tmp11_ = g_strdup (builder->str);
	result = _tmp11_;
	_g_string_free0 (builder);
	return result;
}


static gint unity_music_lens_banshee_collection_execute_sql (UnityMusicLensBansheeCollection* self, const gchar* sql, sqlite3_stmt** stmt) {
	sqlite3_stmt* _stmt = NULL;
	gint result = 0;
	gint rc = 0;
	sqlite3_stmt* _tmp0_ = NULL;
	gint _tmp1_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (sql != NULL, 0);
	g_debug ("banshee-collection.vala:222: preparing to execute sql %s\n", sql);
	_tmp1_ = sqlite3_prepare_v2 (self->priv->db, sql, -1, &_tmp0_, NULL);
	_sqlite3_finalize0 (_stmt);
	_stmt = _tmp0_;
	rc = _tmp1_;
	if (rc == 1) {
		const gchar* _tmp2_ = NULL;
		_tmp2_ = sqlite3_errmsg (self->priv->db);
		g_warning ("banshee-collection.vala:226: SQL Error: %d, %s\n", rc, _tmp2_);
	}
	result = rc;
	if (stmt) {
		*stmt = _stmt;
	} else {
		_sqlite3_finalize0 (_stmt);
	}
	return result;
}


static void unity_music_lens_banshee_collection_class_init (UnityMusicLensBansheeCollectionClass * klass) {
	unity_music_lens_banshee_collection_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (UnityMusicLensBansheeCollectionPrivate));
	G_OBJECT_CLASS (klass)->finalize = unity_music_lens_banshee_collection_finalize;
}


static void unity_music_lens_banshee_collection_instance_init (UnityMusicLensBansheeCollection * self) {
	self->priv = UNITY_MUSIC_LENS_BANSHEE_COLLECTION_GET_PRIVATE (self);
}


static void unity_music_lens_banshee_collection_finalize (GObject* obj) {
	UnityMusicLensBansheeCollection * self;
	self = UNITY_MUSIC_LENS_BANSHEE_COLLECTION (obj);
	_sqlite3_close0 (self->priv->db);
	G_OBJECT_CLASS (unity_music_lens_banshee_collection_parent_class)->finalize (obj);
}


/**
   * Abstracts talking to the banshee collection database
   */
GType unity_music_lens_banshee_collection_get_type (void) {
	static volatile gsize unity_music_lens_banshee_collection_type_id__volatile = 0;
	if (g_once_init_enter (&unity_music_lens_banshee_collection_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UnityMusicLensBansheeCollectionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unity_music_lens_banshee_collection_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnityMusicLensBansheeCollection), 0, (GInstanceInitFunc) unity_music_lens_banshee_collection_instance_init, NULL };
		GType unity_music_lens_banshee_collection_type_id;
		unity_music_lens_banshee_collection_type_id = g_type_register_static (G_TYPE_OBJECT, "UnityMusicLensBansheeCollection", &g_define_type_info, 0);
		g_once_init_leave (&unity_music_lens_banshee_collection_type_id__volatile, unity_music_lens_banshee_collection_type_id);
	}
	return unity_music_lens_banshee_collection_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



