/* session-chooser.c generated by valac 0.16.0, the Vala compiler
 * generated from session-chooser.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 4 -*-
 *
 * Copyright (C) 2012 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors: Michael Terry <michael.terry@canonical.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <glib/gi18n-lib.h>
#include <glib/gstdio.h>
#include <lightdm.h>


#define TYPE_FADABLE (fadable_get_type ())
#define FADABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FADABLE, Fadable))
#define IS_FADABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FADABLE))
#define FADABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_FADABLE, FadableIface))

typedef struct _Fadable Fadable;
typedef struct _FadableIface FadableIface;

#define TYPE_FADE_TRACKER (fade_tracker_get_type ())
#define FADE_TRACKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FADE_TRACKER, FadeTracker))
#define FADE_TRACKER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FADE_TRACKER, FadeTrackerClass))
#define IS_FADE_TRACKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FADE_TRACKER))
#define IS_FADE_TRACKER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FADE_TRACKER))
#define FADE_TRACKER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FADE_TRACKER, FadeTrackerClass))

typedef struct _FadeTracker FadeTracker;
typedef struct _FadeTrackerClass FadeTrackerClass;

#define TYPE_FADABLE_BOX (fadable_box_get_type ())
#define FADABLE_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FADABLE_BOX, FadableBox))
#define FADABLE_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FADABLE_BOX, FadableBoxClass))
#define IS_FADABLE_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FADABLE_BOX))
#define IS_FADABLE_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FADABLE_BOX))
#define FADABLE_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FADABLE_BOX, FadableBoxClass))

typedef struct _FadableBox FadableBox;
typedef struct _FadableBoxClass FadableBoxClass;
typedef struct _FadableBoxPrivate FadableBoxPrivate;

#define TYPE_SESSION_CHOOSER (session_chooser_get_type ())
#define SESSION_CHOOSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SESSION_CHOOSER, SessionChooser))
#define SESSION_CHOOSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SESSION_CHOOSER, SessionChooserClass))
#define IS_SESSION_CHOOSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SESSION_CHOOSER))
#define IS_SESSION_CHOOSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SESSION_CHOOSER))
#define SESSION_CHOOSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SESSION_CHOOSER, SessionChooserClass))

typedef struct _SessionChooser SessionChooser;
typedef struct _SessionChooserClass SessionChooserClass;
typedef struct _SessionChooserPrivate SessionChooserPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block1Data Block1Data;

#define TYPE_CACHED_IMAGE (cached_image_get_type ())
#define CACHED_IMAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CACHED_IMAGE, CachedImage))
#define CACHED_IMAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CACHED_IMAGE, CachedImageClass))
#define IS_CACHED_IMAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CACHED_IMAGE))
#define IS_CACHED_IMAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CACHED_IMAGE))
#define CACHED_IMAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CACHED_IMAGE, CachedImageClass))

typedef struct _CachedImage CachedImage;
typedef struct _CachedImageClass CachedImageClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))

struct _FadableIface {
	GTypeInterface parent_iface;
	FadeTracker* (*get_fade_tracker) (Fadable* self);
	void (*set_fade_tracker) (Fadable* self, FadeTracker* value);
};

struct _FadableBox {
	GtkBox parent_instance;
	FadableBoxPrivate * priv;
};

struct _FadableBoxClass {
	GtkBoxClass parent_class;
};

struct _SessionChooser {
	FadableBox parent_instance;
	SessionChooserPrivate * priv;
};

struct _SessionChooserClass {
	FadableBoxClass parent_class;
};

struct _Block1Data {
	int _ref_count_;
	SessionChooser * self;
	gchar* key;
};


static gpointer session_chooser_parent_class = NULL;
static GHashTable* session_chooser_badges;
static GHashTable* session_chooser_badges = NULL;
extern gboolean unity_greeter_test_mode;

GType fade_tracker_get_type (void) G_GNUC_CONST;
GType fadable_get_type (void) G_GNUC_CONST;
GType fadable_box_get_type (void) G_GNUC_CONST;
GType session_chooser_get_type (void) G_GNUC_CONST;
enum  {
	SESSION_CHOOSER_DUMMY_PROPERTY
};
static GtkWidget* session_chooser_build_back_button (SessionChooser* self);
void unity_greeter_add_style_class (GtkWidget* widget);
static void __lambda5_ (SessionChooser* self);
static void ___lambda5__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void session_chooser_add_session (SessionChooser* self, const gchar* key, const gchar* name);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void __lambda6_ (Block1Data* _data1_);
static void ___lambda6__gtk_button_clicked (GtkButton* _sender, gpointer self);
GdkPixbuf* session_chooser_get_badge (const gchar* session);
CachedImage* cached_image_new (GdkPixbuf* pixbuf);
CachedImage* cached_image_construct (GType object_type, GdkPixbuf* pixbuf);
GType cached_image_get_type (void) G_GNUC_CONST;
static gchar* session_chooser_get_badge_name (const gchar* session);
static void _g_free0_ (gpointer var);
static void _g_object_unref0_ (gpointer var);
SessionChooser* session_chooser_new (void);
SessionChooser* session_chooser_construct (GType object_type);
FadableBox* fadable_box_new (void);
FadableBox* fadable_box_construct (GType object_type);
static GObject * session_chooser_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void session_chooser_finalize (GObject* obj);


static void __lambda5_ (SessionChooser* self) {
	g_signal_emit_by_name (self, "session-clicked", NULL);
}


static void ___lambda5__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	__lambda5_ (self);
}


static GtkWidget* session_chooser_build_back_button (SessionChooser* self) {
	GtkWidget* result = NULL;
	GtkAlignment* _tmp0_;
	GtkAlignment* _tmp1_;
	GtkAlignment* align;
	GtkButton* _tmp2_;
	GtkButton* _tmp3_;
	GtkButton* back;
	GtkBox* _tmp4_;
	GtkBox* _tmp5_;
	GtkBox* hbox;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	GtkImage* _tmp8_;
	GtkImage* _tmp9_;
	GtkImage* _tmp10_;
	GtkImage* image;
	const gchar* _tmp11_ = NULL;
	GtkLabel* _tmp12_;
	GtkLabel* _tmp13_;
	GtkLabel* label;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = (GtkAlignment*) gtk_alignment_new (0.0f, 0.5f, 0.0f, 1.0f);
	_tmp1_ = g_object_ref_sink (_tmp0_);
	align = _tmp1_;
	_tmp2_ = (GtkButton*) gtk_button_new ();
	_tmp3_ = g_object_ref_sink (_tmp2_);
	back = _tmp3_;
	unity_greeter_add_style_class ((GtkWidget*) back);
	g_signal_connect_object (back, "clicked", (GCallback) ___lambda5__gtk_button_clicked, self, 0);
	gtk_container_add ((GtkContainer*) align, (GtkWidget*) back);
	_tmp4_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 6);
	_tmp5_ = g_object_ref_sink (_tmp4_);
	hbox = _tmp5_;
	gtk_container_add ((GtkContainer*) back, (GtkWidget*) hbox);
	_tmp6_ = g_build_filename (PKGDATADIR, "arrow_left.png", NULL, NULL);
	_tmp7_ = _tmp6_;
	_tmp8_ = (GtkImage*) gtk_image_new_from_file (_tmp7_);
	_tmp9_ = g_object_ref_sink (_tmp8_);
	_tmp10_ = _tmp9_;
	_g_free0 (_tmp7_);
	image = _tmp10_;
	gtk_box_pack_start (hbox, (GtkWidget*) image, FALSE, FALSE, (guint) 0);
	_tmp11_ = _ ("_Back");
	_tmp12_ = (GtkLabel*) gtk_label_new_with_mnemonic (_tmp11_);
	_tmp13_ = g_object_ref_sink (_tmp12_);
	label = _tmp13_;
	gtk_label_set_mnemonic_widget (label, (GtkWidget*) back);
	gtk_widget_set_halign ((GtkWidget*) label, GTK_ALIGN_START);
	gtk_box_pack_start (hbox, (GtkWidget*) label, FALSE, FALSE, (guint) 0);
	gtk_widget_show_all ((GtkWidget*) align);
	result = (GtkWidget*) align;
	_g_object_unref0 (label);
	_g_object_unref0 (image);
	_g_object_unref0 (hbox);
	_g_object_unref0 (back);
	return result;
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		SessionChooser * self;
		self = _data1_->self;
		_g_free0 (_data1_->key);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}


static void __lambda6_ (Block1Data* _data1_) {
	SessionChooser * self;
	const gchar* _tmp0_;
	self = _data1_->self;
	_tmp0_ = _data1_->key;
	g_signal_emit_by_name (self, "session-clicked", _tmp0_);
}


static void ___lambda6__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	__lambda6_ (self);
}


static void session_chooser_add_session (SessionChooser* self, const gchar* key, const gchar* name) {
	Block1Data* _data1_;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	GtkButton* _tmp2_;
	GtkButton* _tmp3_;
	GtkButton* item;
	GtkButton* _tmp4_;
	GtkButton* _tmp5_;
	GtkBox* _tmp6_;
	GtkBox* _tmp7_;
	GtkBox* hbox;
	const gchar* _tmp8_;
	GdkPixbuf* _tmp9_ = NULL;
	GdkPixbuf* pixbuf;
	GdkPixbuf* _tmp10_;
	const gchar* _tmp16_;
	GtkLabel* _tmp17_;
	GtkLabel* _tmp18_;
	GtkLabel* label;
	GtkBox* _tmp19_;
	GtkButton* _tmp20_;
	GtkButton* _tmp21_;
	GtkBox* _tmp22_;
	GtkButton* _tmp23_;
	GtkButton* _tmp29_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (key != NULL);
	g_return_if_fail (name != NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_tmp0_ = key;
	_tmp1_ = g_strdup (_tmp0_);
	_data1_->key = _tmp1_;
	_tmp2_ = (GtkButton*) gtk_button_new ();
	_tmp3_ = g_object_ref_sink (_tmp2_);
	item = _tmp3_;
	_tmp4_ = item;
	g_signal_connect_data (_tmp4_, "clicked", (GCallback) ___lambda6__gtk_button_clicked, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	_tmp5_ = item;
	unity_greeter_add_style_class ((GtkWidget*) _tmp5_);
	_tmp6_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 6);
	_tmp7_ = g_object_ref_sink (_tmp6_);
	hbox = _tmp7_;
	_tmp8_ = _data1_->key;
	_tmp9_ = session_chooser_get_badge (_tmp8_);
	pixbuf = _tmp9_;
	_tmp10_ = pixbuf;
	if (_tmp10_ != NULL) {
		GdkPixbuf* _tmp11_;
		CachedImage* _tmp12_;
		CachedImage* _tmp13_;
		CachedImage* image;
		GtkBox* _tmp14_;
		CachedImage* _tmp15_;
		_tmp11_ = pixbuf;
		_tmp12_ = cached_image_new (_tmp11_);
		_tmp13_ = g_object_ref_sink (_tmp12_);
		image = _tmp13_;
		_tmp14_ = hbox;
		_tmp15_ = image;
		gtk_box_pack_start (_tmp14_, (GtkWidget*) _tmp15_, FALSE, FALSE, (guint) 0);
		_g_object_unref0 (image);
	}
	_tmp16_ = name;
	_tmp17_ = (GtkLabel*) gtk_label_new (_tmp16_);
	_tmp18_ = g_object_ref_sink (_tmp17_);
	label = _tmp18_;
	gtk_widget_set_halign ((GtkWidget*) label, GTK_ALIGN_START);
	_tmp19_ = hbox;
	gtk_box_pack_start (_tmp19_, (GtkWidget*) label, TRUE, TRUE, (guint) 0);
	_tmp20_ = item;
	gtk_button_set_relief (_tmp20_, GTK_RELIEF_NONE);
	_tmp21_ = item;
	_tmp22_ = hbox;
	gtk_container_add ((GtkContainer*) _tmp21_, (GtkWidget*) _tmp22_);
	_tmp23_ = item;
	gtk_widget_show_all ((GtkWidget*) _tmp23_);
	{
		GtkCssProvider* _tmp24_;
		GtkCssProvider* style;
		GtkButton* _tmp25_;
		GtkStyleContext* _tmp26_ = NULL;
		_tmp24_ = gtk_css_provider_new ();
		style = _tmp24_;
		gtk_css_provider_load_from_data (style, "* {padding: 3px;}", (gssize) (-1), &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (style);
			goto __catch9_g_error;
		}
		_tmp25_ = item;
		_tmp26_ = gtk_widget_get_style_context ((GtkWidget*) _tmp25_);
		gtk_style_context_add_provider (_tmp26_, (GtkStyleProvider*) style, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
		_g_object_unref0 (style);
	}
	goto __finally9;
	__catch9_g_error:
	{
		GError* e = NULL;
		GError* _tmp27_;
		const gchar* _tmp28_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp27_ = e;
		_tmp28_ = _tmp27_->message;
		g_debug ("session-chooser.vala:104: Internal error loading session chooser style" \
": %s", _tmp28_);
		_g_error_free0 (e);
	}
	__finally9:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (label);
		_g_object_unref0 (pixbuf);
		_g_object_unref0 (hbox);
		_g_object_unref0 (item);
		block1_data_unref (_data1_);
		_data1_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp29_ = item;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp29_);
	_g_object_unref0 (label);
	_g_object_unref0 (pixbuf);
	_g_object_unref0 (hbox);
	_g_object_unref0 (item);
	block1_data_unref (_data1_);
	_data1_ = NULL;
}


static gchar* session_chooser_get_badge_name (const gchar* session) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GQuark _tmp3_ = 0U;
	static GQuark _tmp2_label0 = 0;
	static GQuark _tmp2_label1 = 0;
	static GQuark _tmp2_label2 = 0;
	static GQuark _tmp2_label3 = 0;
	static GQuark _tmp2_label4 = 0;
	static GQuark _tmp2_label5 = 0;
	static GQuark _tmp2_label6 = 0;
	static GQuark _tmp2_label7 = 0;
	g_return_val_if_fail (session != NULL, NULL);
	_tmp0_ = session;
	_tmp1_ = _tmp0_;
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	if (((_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("ubuntu")))) || (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("ubuntu-2d"))))) || (_tmp3_ == ((0 != _tmp2_label2) ? _tmp2_label2 : (_tmp2_label2 = g_quark_from_static_string ("gnome"))))) {
		switch (0) {
			default:
			{
				gchar* _tmp4_;
				_tmp4_ = g_strdup ("ubuntu_badge.png");
				result = _tmp4_;
				return result;
			}
		}
	} else if (((_tmp3_ == ((0 != _tmp2_label3) ? _tmp2_label3 : (_tmp2_label3 = g_quark_from_static_string ("gnome-classic")))) || (_tmp3_ == ((0 != _tmp2_label4) ? _tmp2_label4 : (_tmp2_label4 = g_quark_from_static_string ("gnome-fallback"))))) || (_tmp3_ == ((0 != _tmp2_label5) ? _tmp2_label5 : (_tmp2_label5 = g_quark_from_static_string ("gnome-shell"))))) {
		switch (0) {
			default:
			{
				gchar* _tmp5_;
				_tmp5_ = g_strdup ("gnome_badge.png");
				result = _tmp5_;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label6) ? _tmp2_label6 : (_tmp2_label6 = g_quark_from_static_string ("kde")))) {
		switch (0) {
			default:
			{
				gchar* _tmp6_;
				_tmp6_ = g_strdup ("kde_badge.png");
				result = _tmp6_;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label7) ? _tmp2_label7 : (_tmp2_label7 = g_quark_from_static_string ("xterm")))) {
		switch (0) {
			default:
			{
				gchar* _tmp7_;
				_tmp7_ = g_strdup ("recovery_console_badge.png");
				result = _tmp7_;
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				result = NULL;
				return result;
			}
		}
	}
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


GdkPixbuf* session_chooser_get_badge (const gchar* session) {
	GdkPixbuf* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* name;
	const gchar* _tmp2_;
	GHashTable* _tmp12_;
	GHashTable* _tmp16_;
	const gchar* _tmp17_;
	gconstpointer _tmp18_ = NULL;
	GdkPixbuf* _tmp19_;
	GdkPixbuf* pixbuf;
	GdkPixbuf* _tmp20_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (session != NULL, NULL);
	_tmp0_ = session;
	_tmp1_ = session_chooser_get_badge_name (_tmp0_);
	name = _tmp1_;
	_tmp2_ = name;
	if (_tmp2_ == NULL) {
		const gchar* _tmp3_;
		gchar* _tmp4_ = NULL;
		gchar* maybe_name;
		const gchar* _tmp5_;
		gchar* _tmp6_ = NULL;
		gchar* maybe_path;
		const gchar* _tmp7_;
		gboolean _tmp8_ = FALSE;
		_tmp3_ = session;
		_tmp4_ = g_strdup_printf ("custom_%s_badge.png", _tmp3_);
		maybe_name = _tmp4_;
		_tmp5_ = maybe_name;
		_tmp6_ = g_build_filename (PKGDATADIR, _tmp5_, NULL, NULL);
		maybe_path = _tmp6_;
		_tmp7_ = maybe_path;
		_tmp8_ = g_file_test (_tmp7_, G_FILE_TEST_EXISTS);
		if (_tmp8_) {
			const gchar* _tmp9_;
			gchar* _tmp10_;
			_tmp9_ = maybe_name;
			_tmp10_ = g_strdup (_tmp9_);
			_g_free0 (name);
			name = _tmp10_;
		} else {
			gchar* _tmp11_;
			_tmp11_ = g_strdup ("unknown_badge.png");
			_g_free0 (name);
			name = _tmp11_;
		}
		_g_free0 (maybe_path);
		_g_free0 (maybe_name);
	}
	_tmp12_ = session_chooser_badges;
	if (_tmp12_ == NULL) {
		GHashFunc _tmp13_;
		GEqualFunc _tmp14_;
		GHashTable* _tmp15_;
		_tmp13_ = g_str_hash;
		_tmp14_ = g_str_equal;
		_tmp15_ = g_hash_table_new_full (_tmp13_, _tmp14_, _g_free0_, _g_object_unref0_);
		_g_hash_table_unref0 (session_chooser_badges);
		session_chooser_badges = _tmp15_;
	}
	_tmp16_ = session_chooser_badges;
	_tmp17_ = name;
	_tmp18_ = g_hash_table_lookup (_tmp16_, _tmp17_);
	_tmp19_ = _g_object_ref0 ((GdkPixbuf*) _tmp18_);
	pixbuf = _tmp19_;
	_tmp20_ = pixbuf;
	if (_tmp20_ == NULL) {
		{
			const gchar* _tmp21_;
			gchar* _tmp22_ = NULL;
			gchar* _tmp23_;
			GdkPixbuf* _tmp24_;
			GdkPixbuf* _tmp25_;
			GdkPixbuf* _tmp26_;
			GHashTable* _tmp27_;
			const gchar* _tmp28_;
			gchar* _tmp29_;
			GdkPixbuf* _tmp30_;
			GdkPixbuf* _tmp31_;
			_tmp21_ = name;
			_tmp22_ = g_build_filename (PKGDATADIR, _tmp21_, NULL, NULL);
			_tmp23_ = _tmp22_;
			_tmp24_ = gdk_pixbuf_new_from_file (_tmp23_, &_inner_error_);
			_tmp25_ = _tmp24_;
			_g_free0 (_tmp23_);
			_tmp26_ = _tmp25_;
			if (_inner_error_ != NULL) {
				goto __catch10_g_error;
			}
			_g_object_unref0 (pixbuf);
			pixbuf = _tmp26_;
			_tmp27_ = session_chooser_badges;
			_tmp28_ = name;
			_tmp29_ = g_strdup (_tmp28_);
			_tmp30_ = pixbuf;
			_tmp31_ = _g_object_ref0 (_tmp30_);
			g_hash_table_insert (_tmp27_, _tmp29_, _tmp31_);
		}
		goto __finally10;
		__catch10_g_error:
		{
			GError* e = NULL;
			const gchar* _tmp32_;
			GError* _tmp33_;
			const gchar* _tmp34_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp32_ = name;
			_tmp33_ = e;
			_tmp34_ = _tmp33_->message;
			g_debug ("session-chooser.vala:162: Error loading badge %s: %s", _tmp32_, _tmp34_);
			_g_error_free0 (e);
		}
		__finally10:
		if (_inner_error_ != NULL) {
			_g_object_unref0 (pixbuf);
			_g_free0 (name);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = pixbuf;
	_g_free0 (name);
	return result;
}


SessionChooser* session_chooser_construct (GType object_type) {
	SessionChooser * self = NULL;
	self = (SessionChooser*) fadable_box_construct (object_type);
	return self;
}


SessionChooser* session_chooser_new (void) {
	return session_chooser_construct (TYPE_SESSION_CHOOSER);
}


static GObject * session_chooser_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	SessionChooser * self;
	GtkWidget* _tmp0_ = NULL;
	GtkWidget* back;
	GtkWidget* _tmp1_;
	gboolean _tmp2_;
	parent_class = G_OBJECT_CLASS (session_chooser_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = SESSION_CHOOSER (obj);
	gtk_orientable_set_orientation ((GtkOrientable*) self, GTK_ORIENTATION_VERTICAL);
	gtk_container_set_border_width ((GtkContainer*) self, (guint) 6);
	_tmp0_ = session_chooser_build_back_button (self);
	back = _tmp0_;
	_tmp1_ = back;
	gtk_box_pack_start ((GtkBox*) self, _tmp1_, FALSE, FALSE, (guint) 0);
	_tmp2_ = unity_greeter_test_mode;
	if (_tmp2_) {
		session_chooser_add_session (self, "gnome", "Ubuntu");
		session_chooser_add_session (self, "gnome-shell", "GNOME");
		session_chooser_add_session (self, "kde", "KDE");
	} else {
		GList* _tmp3_ = NULL;
		_tmp3_ = lightdm_get_sessions ();
		{
			GList* session_collection = NULL;
			GList* session_it = NULL;
			session_collection = _tmp3_;
			for (session_it = session_collection; session_it != NULL; session_it = session_it->next) {
				LightDMSession* session = NULL;
				session = (LightDMSession*) session_it->data;
				{
					LightDMSession* _tmp4_;
					const gchar* _tmp5_;
					const gchar* _tmp6_;
					LightDMSession* _tmp7_;
					const gchar* _tmp8_;
					const gchar* _tmp9_;
					LightDMSession* _tmp10_;
					const gchar* _tmp11_;
					const gchar* _tmp12_;
					LightDMSession* _tmp13_;
					const gchar* _tmp14_;
					const gchar* _tmp15_;
					_tmp4_ = session;
					_tmp5_ = lightdm_session_get_key (_tmp4_);
					_tmp6_ = _tmp5_;
					_tmp7_ = session;
					_tmp8_ = lightdm_session_get_name (_tmp7_);
					_tmp9_ = _tmp8_;
					g_debug ("session-chooser.vala:42: Adding session %s (%s)", _tmp6_, _tmp9_);
					_tmp10_ = session;
					_tmp11_ = lightdm_session_get_key (_tmp10_);
					_tmp12_ = _tmp11_;
					_tmp13_ = session;
					_tmp14_ = lightdm_session_get_name (_tmp13_);
					_tmp15_ = _tmp14_;
					session_chooser_add_session (self, _tmp12_, _tmp15_);
				}
			}
		}
	}
	_g_object_unref0 (back);
	return obj;
}


static void session_chooser_class_init (SessionChooserClass * klass) {
	session_chooser_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->constructor = session_chooser_constructor;
	G_OBJECT_CLASS (klass)->finalize = session_chooser_finalize;
	g_signal_new ("session_clicked", TYPE_SESSION_CHOOSER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
}


static void session_chooser_instance_init (SessionChooser * self) {
}


static void session_chooser_finalize (GObject* obj) {
	SessionChooser * self;
	self = SESSION_CHOOSER (obj);
	G_OBJECT_CLASS (session_chooser_parent_class)->finalize (obj);
}


GType session_chooser_get_type (void) {
	static volatile gsize session_chooser_type_id__volatile = 0;
	if (g_once_init_enter (&session_chooser_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SessionChooserClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) session_chooser_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SessionChooser), 0, (GInstanceInitFunc) session_chooser_instance_init, NULL };
		GType session_chooser_type_id;
		session_chooser_type_id = g_type_register_static (TYPE_FADABLE_BOX, "SessionChooser", &g_define_type_info, 0);
		g_once_init_leave (&session_chooser_type_id__volatile, session_chooser_type_id);
	}
	return session_chooser_type_id__volatile;
}



