# ubuntuone.storageprotocol.context - ssl context creation
#
# Copyright 2009 Canonical Ltd.
#
# This program is free software: you can redistribute it and/or modify it 
# under the terms of the GNU Affero General Public License version 3,
# as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful, but 
# WITHOUT ANY WARRANTY; without even the implied warranties of 
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR 
# PURPOSE.  See the GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
""" 
Standard Routines for working with ssl context creation
"""

from OpenSSL import SSL
from twisted.internet import ssl

def get_ssl_context(no_verify):
    """ Get the ssl context """
    if no_verify:
        ctx = ssl.ClientContextFactory()
    else:
        ca_file = ssl.Certificate.loadPEM(file(
            '/etc/ssl/certs/UbuntuOne-Go_Daddy_Class_2_CA.pem', 'r').read())
        ca_file_2 = ssl.Certificate.loadPEM(file(
            '/etc/ssl/certs/UbuntuOne-Go_Daddy_CA.pem', 'r').read())
        ctx = ssl.CertificateOptions(verify=True, 
            caCerts=[ca_file.original, ca_file_2.original],
                     method=SSL.SSLv23_METHOD)
    return ctx
