# ubuntuone.storageprotocol.tests.test_request -
#     request class tests
#
# Author: Tim Cole <tim.cole@canonical.com>
#
# Copyright (C) 2009 Canonical
#
# This program is free software: you can redistribute it and/or modify it 
# under the terms of the GNU Affero General Public License version 3,
# as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful, but 
# WITHOUT ANY WARRANTY; without even the implied warranties of 
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR 
# PURPOSE.  See the GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
"""Tests for directory content serialization/unserialization."""

from __future__ import with_statement

from twisted.trial.unittest import TestCase
from twisted.internet.defer import inlineCallbacks
from twisted.python.failure import Failure
from ubuntuone.storageprotocol.request import (
    RequestHandler, Request)


class MindlessRequest(Request):
    """A mindless request which never actually does anything."""

    def _start(self):
        """Does nothing."""


class ConnectionLike(object):
    """An object vaguely resembling a FileDescriptor."""

    def __init__(self):
        """Initialize an instance."""
        self.producer = None

    def registerProducer(self, producer, streaming=False):
        """Fake registering a producer."""
        self.producer = producer

    def unregisterProducer(self):
        """Fake unregistering a producer."""
        self.producer = None


class TestRequests(TestCase):
    """Tests for request handling."""

    @inlineCallbacks
    def test_disconnect_aborts_requests(self):
        """Test that disconnection aborts outstanding requests."""


        class OurException(RuntimeError):
            """An exception class to look for."""


        transport = ConnectionLike()
        protocol = RequestHandler()
        protocol.makeConnection(transport)
        request = MindlessRequest(protocol)
        request.start()
        protocol.connectionLost(Failure(OurException()))
        try:
            yield request.deferred
        except OurException:
            pass # passed
        else:
            self.fail("Expected to fail with the correct reason.")
