# -*- coding: utf-8 -*-
#
# Copyright 2011-2012 Canonical Ltd.
#
# This program is free software: you can redistribute it and/or modify it
# under the terms of the GNU General Public License version 3, as published
# by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranties of
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
# PURPOSE.  See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program.  If not, see <http://www.gnu.org/licenses/>.

"""The base widget for the Control Panel tabs."""

from PyQt4 import QtGui

from ubuntuone.controlpanel import cache
from ubuntuone.controlpanel.gui.qt import handle_errors
from ubuntuone.controlpanel.gui.qt.loadingoverlay import LoadingOverlay


class UbuntuOneBin(cache.Cache, QtGui.QWidget):
    """The base widget for the Control Panel's tabs."""

    ui_class = None

    def __init__(self, *args, **kwargs):
        """Initialize the UI of the widget."""
        super(UbuntuOneBin, self).__init__(*args, **kwargs)
        self.ui = None
        if self.ui_class is not None:
            # self.ui_class is not callable
            self.ui = self.ui_class.Ui_Form()
            # pylint: disable=E1102
            self.ui.setupUi(self)

        self.overlay = LoadingOverlay(self)
        self.overlay.hide()

        self._is_processing = None
        self.is_processing = False

        # pylint: disable=E0202
        handler = handle_errors(logger=self.logger,
                                error_handler=self._error_handler)
        self.load = handler(self.load)

        self._setup()

    def _get_is_processing(self):
        """Get the value of is_processing."""
        return self._is_processing

    def _set_is_processing(self, new_value):
        """Set the value of is_processing.

        If is_processing, disable the UI and show a spinner.
        If not is_processing, enable the UI and hide the spinner.

        """
        self.overlay.setVisible(new_value)
        self.setEnabled(not new_value)
        self._is_processing = new_value

    is_processing = property(fget=_get_is_processing, fset=_set_is_processing)

    def _error_handler(self):
        """Custom error handler, unset is_processing."""
        self.is_processing = False

    def _setup(self):
        """Do some extra setupping for the UI."""

    # Invalid name "showEvent", "resizeEvent"
    # pylint: disable=C0103

    def showEvent(self, event):
        """Load info."""
        super(UbuntuOneBin, self).showEvent(event)
        if not self.is_processing:
            self.load()

    def resizeEvent(self, event):
        """Resize the overlay to fit all the widget."""
        self.overlay.resize(event.size())
        event.accept()

    # pylint: enable=C0103

    # pylint: disable=E0202
    def load(self):
        """Load the widget with specific info."""
