# -*- coding: utf-8 -*-
#
# Copyright 2011 Canonical Ltd.
#
# This program is free software: you can redistribute it and/or modify it
# under the terms of the GNU General Public License version 3, as published
# by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranties of
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
# PURPOSE.  See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program.  If not, see <http://www.gnu.org/licenses/>.

"""Provide the correct ui main module."""

import argparse
import sys

from PyQt4 import QtCore

from ubuntuone.controlpanel.gui.qt.gui import start
# Module used to include the resources into this file
# Unused import images_rc, pylint: disable=W0611
from ubuntuone.controlpanel.gui.qt.ui import images_rc
# pylint: enable=W0611
from ubuntuone.controlpanel.gui.qt.uniqueapp import UniqueApplication

# Invalid name "source", pylint: disable=C0103
if sys.platform == 'win32':
    from ubuntuone.controlpanel.gui.qt.main import windows
    source = windows
else:
    from ubuntuone.controlpanel.gui.qt.main import linux
    source = linux
# pylint: enable=C0103


def parser_options():
    """Parse command line parameters."""
    result = argparse.ArgumentParser()
    result.add_argument("--switch-to", dest="switch_to",
                        metavar="PANEL_NAME", default="",
                        help="Start Ubuntu One in the "
                             "PANEL_NAME tab. Possible values are: "
                             "folders, devices, settings, account")
    result.add_argument("--minimized", dest="minimized", action="store_true",
                        default=False,
                        help="Start Ubuntu One "
                             "only in the notification area, with no "
                             "visible window. Implies --with-icon")
    result.add_argument("--with-icon", dest="with_icon", action="store_true",
                        default=False,
                        help="Start Ubuntu One "
                             "with an icon in the notification area.")
    result.add_argument("--installer", dest="installer", action="store_true",
                        default=False,
                        help="Show the license agreement page first.")
    return result


def main(args):
    """Start the Qt mainloop and open the main window."""
    # The following cannot be imported outside this function
    # because u1trial already provides a reactor.

    args = ['ubuntuone-installer'] + args
    app = UniqueApplication(args, "ubuntuone-control-panel")

    # Install translator for standard dialogs.
    locale = unicode(QtCore.QLocale.system().name())
    translator = QtCore.QTranslator()
    translator.load("qt_" + locale,
        QtCore.QLibraryInfo.location(QtCore.QLibraryInfo.TranslationsPath))
    app.installTranslator(translator)

    parser = parser_options()
    # Use only the arguments that are not recognized by Qt
    # and after the name of the binary (bug #956143)
    arg_list = [unicode(arg) for arg in app.arguments()]
    bin_position = arg_list.index(sys.argv[0]) + 1
    args = parser.parse_args(args=arg_list[bin_position:])
    switch_to = args.switch_to
    minimized = args.minimized
    with_icon = args.with_icon
    installer = args.installer
    source.main(app)

    data = []
    for qss_name in (":/ubuntuone.qss", source.PLATFORM_QSS):
        qss = QtCore.QResource(qss_name)
        data.append(unicode(qss.data()))
    app.setStyleSheet('\n'.join(data))

    # Unused variable 'window', 'icon', pylint: disable=W0612
    icon, window = start(lambda: source.main_quit(app),
                         minimized=minimized, with_icon=with_icon,
                         installer=installer)
    if window:
        window.switch_to(switch_to)
    # pylint: enable=W0612
    if icon:
        app.new_instance.connect(icon.restore_window)

    source.main_start(app)
