# -*- coding: utf-8 -*-
#
# Author: Manuel de la Pena <manuel@canonical.com>
#
# Copyright 2011 Canonical Ltd.
#
# This program is free software: you can redistribute it and/or modify it
# under the terms of the GNU General Public License version 3, as published
# by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranties of
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
# PURPOSE.  See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program.  If not, see <http://www.gnu.org/licenses/>.
"""Test for the pyinotify implementation on windows."""

from twisted.trial.unittest import TestCase

from ubuntuone.platform.windows.pyinotify import RawOutputFormat

class RawOutputFormatTest(TestCase):
    """Test te formatter to ensure it can deal with mbcs."""

    def setUp(self):
        """Set tests."""
        self.format = {'normal': 'normal'}
        self.formatter = RawOutputFormat(self.format)

    def test_simple_unicode(self):
        """Test the formatting of a simple value that is unicode."""
        attr = 'attribute'
        self.format[attr] = attr
        value = u'ñoño'
        expected_result = (attr + value.encode('mbcs', 'replace') +
                           self.format['normal'])
        self.assertEqual(expected_result, self.formatter.simple(value, attr))

    def test_simple_not_unicode(self):
        """Test the formatting of a simple value that is not unicode."""
        attr = 'attribute'
        self.format[attr] = attr
        value = True
        expected_result = (attr + str(value) + self.format['normal'])
        self.assertEqual(expected_result, self.formatter.simple(value, attr))
