/*
 * Syncdaemon API
 *
 * Authors: Rodrigo Moya <rodrigo.moya@canonical.com>
 *
 * Copyright 2010 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 3, as published
 * by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef __SYNCDAEMON_FILESYSTEM_INTERFACE_H__
#define __SYNCDAEMON_FILESYSTEM_INTERFACE_H__

#include "syncdaemon-daemon.h"
#include "syncdaemon-interface.h"
#include "syncdaemon-metadata.h"

G_BEGIN_DECLS

#define SYNCDAEMON_TYPE_FILESYSTEM_INTERFACE                (syncdaemon_filesystem_interface_get_type ())
#define SYNCDAEMON_FILESYSTEM_INTERFACE(obj)                (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNCDAEMON_TYPE_FILESYSTEM_INTERFACE, SyncdaemonFilesystemInterface))
#define SYNCDAEMON_IS_FILESYSTEM_INTERFACE(obj)             (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNCDAEMON_TYPE_FILESYSTEM_INTERFACE))
#define SYNCDAEMON_FILESYSTEM_INTERFACE_CLASS(klass)        (G_TYPE_CHECK_CLASS_CAST ((klass), SYNCDAEMON_TYPE_FILESYSTEM_INTERFACE, SyncdaemonFilesystemInterfaceClass))
#define SYNCDAEMON_IS_FILESYSTEM_INTERFACE_CLASS(klass)     (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNCDAEMON_TYPE_FILESYSTEM_INTERFACE))
#define SYNCDAEMON_FILESYSTEM_INTERFACE_GET_CLASS(obj)      (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNCDAEMON_TYPE_FILESYSTEM_INTERFACE, SyncdaemonFilesystemInterfaceClass))

typedef struct _SyncdaemonFilesystemInterfacePrivate SyncdaemonFilesystemInterfacePrivate;

typedef struct {
	SyncdaemonInterface parent;
	SyncdaemonFilesystemInterfacePrivate *priv;
} SyncdaemonFilesystemInterface;

typedef struct {
	SyncdaemonInterfaceClass parent_class;
} SyncdaemonFilesystemInterfaceClass;

GType                          syncdaemon_filesystem_interface_get_type (void);

SyncdaemonFilesystemInterface *syncdaemon_filesystem_interface_new (SyncdaemonDaemon *daemon);

SyncdaemonMetadata            *syncdaemon_filesystem_interface_get_metadata (SyncdaemonFilesystemInterface *interface,
									     const gchar *path,
                                                                             gboolean with_subtree_sync_check);

typedef void (* SyncdaemonGotMetadataFunc) (SyncdaemonFilesystemInterface *interface,
					    gboolean success,
					    SyncdaemonMetadata *metadata,
					    gpointer user_data);

void                           syncdaemon_filesystem_interface_get_metadata_async (SyncdaemonFilesystemInterface *interface,
										   const gchar *path,
                                                                                   gboolean with_subtree_sync_check,
										   SyncdaemonGotMetadataFunc callback,
										   gpointer user_data);


G_END_DECLS

#endif
