/*
 * Syncdaemon API
 *
 * Authors: Rodrigo Moya <rodrigo.moya@canonical.com>
 *
 * Copyright 2010 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 3, as published
 * by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef __SYNCDAEMON_EVENTS_INTERFACE_H__
#define __SYNCDAEMON_EVENTS_INTERFACE_H__

#include "syncdaemon-daemon.h"
#include "syncdaemon-interface.h"

G_BEGIN_DECLS

#define SYNCDAEMON_TYPE_EVENTS_INTERFACE                (syncdaemon_events_interface_get_type ())
#define SYNCDAEMON_EVENTS_INTERFACE(obj)                (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNCDAEMON_TYPE_EVENTS_INTERFACE, SyncdaemonEventsInterface))
#define SYNCDAEMON_IS_EVENTS_INTERFACE(obj)             (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNCDAEMON_TYPE_EVENTS_INTERFACE))
#define SYNCDAEMON_EVENTS_INTERFACE_CLASS(klass)        (G_TYPE_CHECK_CLASS_CAST ((klass), SYNCDAEMON_TYPE_EVENTS_INTERFACE, SyncdaemonEventsInterfaceClass))
#define SYNCDAEMON_IS_EVENTS_INTERFACE_CLASS(klass)     (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNCDAEMON_TYPE_EVENTS_INTERFACE))
#define SYNCDAEMON_EVENTS_INTERFACE_GET_CLASS(obj)      (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNCDAEMON_TYPE_EVENTS_INTERFACE, SyncdaemonEventsInterfaceClass))

typedef struct _SyncdaemonEventsInterfacePrivate SyncdaemonEventsInterfacePrivate;

typedef struct {
	SyncdaemonInterface parent;
	SyncdaemonEventsInterfacePrivate *priv;
} SyncdaemonEventsInterface;

typedef struct {
	SyncdaemonInterfaceClass parent_class;
} SyncdaemonEventsInterfaceClass;

GType                      syncdaemon_events_interface_get_type (void);

SyncdaemonEventsInterface *syncdaemon_events_interface_new (SyncdaemonDaemon *daemon);

void                       syncdaemon_events_interface_push_event (SyncdaemonEventsInterface *interface,
								   const gchar *event_name,
								   const gchar **args);

G_END_DECLS

#endif
