/*
 * Syncdaemon API
 *
 * Authors: Rodrigo Moya <rodrigo.moya@canonical.com>
 *
 * Copyright 2010 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 3, as published
 * by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef __SYNCDAEMON_SHARES_INTERFACE_H__
#define __SYNCDAEMON_SHARES_INTERFACE_H__

#include "syncdaemon-daemon.h"
#include "syncdaemon-interface.h"

G_BEGIN_DECLS

#define SYNCDAEMON_TYPE_SHARES_INTERFACE                (syncdaemon_shares_interface_get_type ())
#define SYNCDAEMON_SHARES_INTERFACE(obj)                (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNCDAEMON_TYPE_SHARES_INTERFACE, SyncdaemonSharesInterface))
#define SYNCDAEMON_IS_SHARES_INTERFACE(obj)             (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNCDAEMON_TYPE_SHARES_INTERFACE))
#define SYNCDAEMON_SHARES_INTERFACE_CLASS(klass)        (G_TYPE_CHECK_CLASS_CAST ((klass), SYNCDAEMON_TYPE_SHARES_INTERFACE, SyncdaemonSharesInterfaceClass))
#define SYNCDAEMON_IS_SHARES_INTERFACE_CLASS(klass)     (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNCDAEMON_TYPE_SHARES_INTERFACE))
#define SYNCDAEMON_SHARES_INTERFACE_GET_CLASS(obj)      (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNCDAEMON_TYPE_SHARES_INTERFACE, SyncdaemonSharesInterfaceClass))

typedef struct _SyncdaemonSharesInterfacePrivate SyncdaemonSharesInterfacePrivate;

typedef struct {
	SyncdaemonInterface parent;
	SyncdaemonSharesInterfacePrivate *priv;
} SyncdaemonSharesInterface;

typedef struct {
	SyncdaemonInterfaceClass parent_class;
} SyncdaemonSharesInterfaceClass;

GType                      syncdaemon_shares_interface_get_type (void);

SyncdaemonSharesInterface *syncdaemon_shares_interface_new (SyncdaemonDaemon *daemon);

void                       syncdaemon_shares_interface_accept (SyncdaemonSharesInterface *interface, const gchar *share_id);
void                       syncdaemon_shares_interface_create (SyncdaemonSharesInterface *interface,
							       const gchar *path,
							       GSList *usernames,
							       const gchar *name,
							       gboolean allow_modifications);
void                       syncdaemon_shares_interface_delete (SyncdaemonSharesInterface *interface, const gchar *share_id);
GSList                    *syncdaemon_shares_interface_get_shared (SyncdaemonSharesInterface *interface);
GSList                    *syncdaemon_shares_interface_get_shares (SyncdaemonSharesInterface *interface);
void                       syncdaemon_shares_interface_refresh (SyncdaemonSharesInterface *interface);
void                       syncdaemon_shares_interface_reject (SyncdaemonSharesInterface *interface, const gchar *share_id);

G_END_DECLS

#endif
