/*
 * UbuntuOne Nautilus plugin
 *
 * Authors: Rodrigo Moya <rodrigo.moya@canonical.com>
 *
 * Copyright 2009-2010 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 3, as published
 * by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef __LOCATION_WIDGET_H__
#define __LOCATION_WIDGET_H__

#include <gtk/gtk.h>
#include "ubuntuone-nautilus.h"

#define TYPE_LOCATION_WIDGET                (location_widget_get_type ())
#define LOCATION_WIDGET(obj)                (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LOCATION_WIDGET, LocationWidget))
#define IS_LOCATION_WIDGET(obj)             (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LOCATION_WIDGET))
#define LOCATION_WIDGET_CLASS(klass)        (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LOCATION_WIDGET, LocationWidgetClass))
#define IS_LOCATION_WIDGET_CLASS(klass)     (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LOCATION_WIDGET))
#define LOCATION_WIDGET_GET_CLASS(obj)      (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LOCATION_WIDGET, LocationWidgetClass))

#ifdef HAVE_NAUTILUS_30
#include <gio/gio.h>
#define SETTINGS_DOMAIN "org.gnome.nautilus.extensions.ubuntuone"
#define SETTINGS_EXPAND_KEY "expand-location"
#define SETTINGS_SHOWN_KEY "show-location"
#else
#include <gconf/gconf-client.h>
#define EXPANDER_STATUS_SECTION "/apps/ubuntuone/nautilus"
#define EXPANDER_STATUS_KEY EXPANDER_STATUS_SECTION "/expand-location"
#define EXPANDER_SHOWN_KEY EXPANDER_STATUS_SECTION "/show-location"
#endif

typedef struct {
	GtkHBox parent;

	/* Private data */
	UbuntuOneNautilus *uon;
	gchar *path;
	GtkWidget *expander;
	gboolean expander_status;
	GtkWidget *info_label;
	GtkWidget *help_label;
	GtkWidget *spinner;
	GtkWidget *toggle_button;

#ifdef HAVE_NAUTILUS_30
    GSettings *settings;
#else
	GConfClient *conf_client;
	guint conf_notify_id;
#endif
} LocationWidget;

typedef struct {
	GtkHBoxClass parent_class;
} LocationWidgetClass;

GType      location_widget_get_type (void);
GtkWidget *location_widget_new (UbuntuOneNautilus *uon, const gchar *path);

#endif
